/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.entity.UserHistory;
import kr.osci.luffy.entity.UserHistoryEntity;
import kr.osci.luffy.services.ActivateObjectsService;
import net.java.ao.DBParam;
import net.java.ao.Preload;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Preload
public class UserHistoryService
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ActivateObjectsService.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String LOG_STATUS_PREFIX = "-log.user-log.type.";
    private static final String LOG_TABLE_HEAD_PREFIX = "-log.user-log.table.head.";
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final TimeZoneManager timeZoneManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final I18nResolver i18n;

    @Inject
    public UserHistoryService(ActiveObjects activeObjects, TimeZoneManager timeZoneManager, UserAccessor userAccessor, I18nResolver i18n) {
        this.activeObjects = activeObjects;
        this.timeZoneManager = timeZoneManager;
        this.userAccessor = userAccessor;
        this.i18n = i18n;
    }

    public UserHistoryEntity insertUserHistory(String userName, String historyType, String createdUserName) throws Exception {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        String userId = String.valueOf(user.getKey());
        String userMail = user.getEmail();
        UserHistoryEntity userHistoryEntity = (UserHistoryEntity)this.activeObjects.create(UserHistoryEntity.class, new DBParam[0]);
        userHistoryEntity.setUserId(userId);
        userHistoryEntity.setUserName(userName);
        userHistoryEntity.setUserMail(userMail);
        userHistoryEntity.setHistoryType(historyType);
        userHistoryEntity.setCreatedAt(this.getCurrentTimestamp());
        userHistoryEntity.setCreatedBy(createdUserName);
        userHistoryEntity.save();
        return userHistoryEntity;
    }

    public UserHistoryEntity insertUserHistory(String userName, String historyType, String createdUserName, int progressId) throws Exception {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        String userId = String.valueOf(user.getKey());
        String userMail = user.getEmail();
        UserHistoryEntity userHistoryEntity = (UserHistoryEntity)this.activeObjects.create(UserHistoryEntity.class, new DBParam[0]);
        userHistoryEntity.setUserId(userId);
        userHistoryEntity.setUserName(userName);
        userHistoryEntity.setUserMail(userMail);
        userHistoryEntity.setHistoryType(historyType);
        userHistoryEntity.setCreatedAt(this.getCurrentTimestamp());
        userHistoryEntity.setCreatedBy(createdUserName);
        userHistoryEntity.setProgressId(progressId);
        userHistoryEntity.save();
        return userHistoryEntity;
    }

    public Timestamp getCurrentTimestamp() throws ParseException {
        TimeZone timeZone = this.timeZoneManager.getDefaultTimeZone();
        Instant instant = Instant.now();
        ZoneId zoneId = ZoneId.of(timeZone.getID());
        ZonedDateTime zonedDateTime = instant.atZone(zoneId);
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        Timestamp timestamp = Timestamp.valueOf(localDateTime);
        return timestamp;
    }

    public List<UserHistory> getUsersHistoryList() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date oneMonthsAgo = calendar.getTime();
        UserHistoryEntity[] userHistoryEntities = (UserHistoryEntity[])this.activeObjects.find(UserHistoryEntity.class, Query.select().where("CREATED_AT >= ?", new Object[]{oneMonthsAgo}).order("CREATED_AT DESC"));
        List<UserHistory> userHistoryList = this.convertToUserHistory(userHistoryEntities);
        return userHistoryList;
    }

    public List<UserHistory> getUsersHistoryListBySearch(String keyword, List<String> actionType, String beforeDate, String afterDate) throws Exception, IllegalAccessException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (beforeDate == null) {
            beforeDate = this.getDefaultBeforeDate();
        }
        if (afterDate == null) {
            afterDate = this.getDefaultAfterDate();
        }
        Date beforeDateTime = dateFormat.parse(beforeDate);
        Date afterDateTime = dateFormat.parse(afterDate);
        afterDateTime = this.addOneDay(afterDateTime);
        String queryClause = this.buildQueryClause(keyword, actionType, beforeDateTime, afterDateTime);
        try {
            UserHistoryEntity[] userHistoryEntities = (UserHistoryEntity[])this.activeObjects.find(UserHistoryEntity.class, Query.select().where(queryClause, new Object[]{"%" + keyword + "%", "%" + keyword + "%", beforeDateTime, afterDateTime}).order("CREATED_AT DESC").from(UserHistoryEntity.class));
            List<UserHistory> userHistoryList = this.convertToUserHistory(userHistoryEntities);
            return userHistoryList;
        }
        catch (Exception e) {
            throw new Exception("Error retrieving user history", e);
        }
    }

    private String getDefaultBeforeDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
    }

    private String getDefaultAfterDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
    }

    private Date addOneDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    private String buildQueryClause(String keyword, List<String> actionType, Date beforeDateTime, Date afterDateTime) {
        StringBuilder queryClause = new StringBuilder();
        if (!actionType.isEmpty() && !actionType.contains("ALL")) {
            String typeQuery = actionType.stream().map(type -> "'" + type + "'").collect(Collectors.joining(", "));
            queryClause.append("HISTORY_TYPE IN (").append(typeQuery).append(") AND ");
        }
        queryClause.append("(USER_NAME LIKE ? OR USER_MAIL LIKE ?) AND ");
        queryClause.append("(CREATED_AT >= ? AND CREATED_AT < ?)");
        return queryClause.toString();
    }

    private List<UserHistory> convertToUserHistory(UserHistoryEntity[] userHistoryEntities) throws InvocationTargetException, IllegalAccessException {
        ArrayList<UserHistory> userHistoryList = new ArrayList<UserHistory>();
        for (UserHistoryEntity entity : userHistoryEntities) {
            String historyType = this.i18n.getText(LOG_STATUS_PREFIX + entity.getHistoryType());
            UserHistory userHistory = new UserHistory(entity.getUserId(), entity.getUserName(), entity.getUserMail(), historyType, entity.getCreatedAt(), entity.getCreatedBy());
            userHistoryList.add(userHistory);
        }
        return userHistoryList;
    }

    public String createUserHistoryCsvFileName() {
        LocalDateTime currentTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss");
        String formattedTime = currentTime.format(formatter);
        return "flexible_wiki_log_" + formattedTime + ".csv";
    }

    /*
     * Exception decompiling
     */
    public byte[] writeEntitiesToCsv(List<UserHistory> entities) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String buildCsvLine(int index, UserHistory entity) {
        StringBuilder lineBuilder = new StringBuilder();
        lineBuilder.append(index).append(",").append(entity.getUserName()).append(",").append(entity.getUserMail()).append(",").append(entity.getHistoryType()).append(",").append(DATE_FORMAT.format(entity.getCreatedAt())).append(",").append(entity.getCreatedBy());
        return lineBuilder.toString();
    }
}

