/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.entity.NotiEntity;
import kr.osci.luffy.entity.NotiSetupEntity;
import kr.osci.luffy.entity.NtfTrgLog;
import kr.osci.luffy.entity.NtfTrgLogEntity;
import kr.osci.luffy.entity.SysHistory;
import kr.osci.luffy.entity.SysHistoryActionDetailType;
import kr.osci.luffy.entity.SysHistoryAttributesSuffixType;
import kr.osci.luffy.entity.SysHistoryAttributesType;
import kr.osci.luffy.entity.SysHistoryEntity;
import kr.osci.luffy.entity.SysHistoryType;
import net.java.ao.DBParam;
import net.java.ao.Preload;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Preload
public class SystemHistoryService
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SystemHistoryService.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String LOG_TYPE_PREFIX = "-log.system-log.type.";
    private static final String LOG_STATUS_PREFIX = "-log.system-log.status.";
    private static final String LOG_SUMMARY_PREFIX = "-log.system-log.summary.";
    private static final String LOG_ATTR_PREFIX = "-log.system-log.attr.";
    private static final String LOG_TABLE_HEAD_PREFIX = "-log.system-log.table.head.";
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final TimeZoneManager timeZoneManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Inject
    public SystemHistoryService(ActiveObjects activeObjects, TimeZoneManager timeZoneManager, I18nResolver i18n) {
        this.activeObjects = activeObjects;
        this.timeZoneManager = timeZoneManager;
        this.i18n = i18n;
    }

    public void insertNotiSetupChangeLog(String userName, boolean inuse) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.NOTIFICATION_INUSE, inuse);
        this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.NOTIFICATION_SETUP_INUSE_CHANGE, attributes);
    }

    public void insertNotiTargetChangeLog(String userName, String targetAction, int type, String value) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addTargetAttribute(attributes, SysHistoryAttributesType.NOTIFICATION_TARGET.getKey(), targetAction, type, value);
        this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.NOTIFICATION_TARGET_CHANGE, attributes);
    }

    public void insertNotiScheduleChangeLog(String userName, NotiSetupEntity prevNotiSetupEntity, NotiSetupEntity savedEntity) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.NOTIFICATION_SCHEDULE_HOUR, prevNotiSetupEntity.getScheduleHour(), savedEntity.getScheduleHour());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.NOTIFICATION_SCHEDULE_INTERVAL, prevNotiSetupEntity.getScheduleInterval(), savedEntity.getScheduleInterval());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.NOTIFICATION_LIMIT, prevNotiSetupEntity.getNotiLimit(), savedEntity.getNotiLimit());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.NOTIFICATION_SCHEDULE_WEEK, prevNotiSetupEntity.getScheduleWeek(), savedEntity.getScheduleWeek());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.NOTIFICATION_SCHEDULE_DAY, prevNotiSetupEntity.getScheduleDay(), savedEntity.getScheduleDay());
        if (attributes.length() > 0) {
            this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.NOTIFICATION_SCHEDULE_CHANGE, attributes);
        }
    }

    public void insertAutoLoginSetupInuseChangeLog(String userName, boolean inuse) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.AUTO_LOGIN_INUSE, inuse);
        this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.AUTO_LOGIN_SETUP_INUSE_CHANGE, attributes);
    }

    public void insertMaintainSetupInuseChangeLog(String userName, boolean inuse) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.MAINTAIN_LICENSE_INUSE, inuse);
        this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.MAINTAIN_LICENSE_SETUP_INUSE_CHANGE, attributes);
    }

    public void insertAutoLoginSettingChangeLog(String userName, LicenseEntity prevEntity, LicenseEntity savedEntity) throws Exception {
        if (this.checkAutoLoginSetupChang(prevEntity, savedEntity)) {
            this.insertAutoLoginSetupChangeLog(userName, savedEntity.getIsReactive());
        } else if (this.checkMaintainSetupChange(prevEntity, savedEntity)) {
            this.insertMaintainSetupChangeLog(userName, prevEntity, savedEntity);
        }
    }

    public void insertAutoLoginSetupChangeLog(String userName, boolean isReactive) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.AUTO_LOGIN_REACTIVATE, isReactive);
        this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.AUTO_LOGIN_SETUP_CHANGE, attributes);
    }

    public void insertMaintainSetupChangeLog(String userName, LicenseEntity prevEntity, LicenseEntity savedEntity) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.MAINTAIN_LICENSE_EXCLUDE_NOT_LOGIN, prevEntity.getIsNotLoginInLicense(), savedEntity.getIsNotLoginInLicense());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.MAINTAIN_LICENSE_COUNT, prevEntity.getLicenseKeepingCount(), savedEntity.getLicenseKeepingCount());
        if (attributes.length() > 0) {
            this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.MAINTAIN_LICENSE_SETUP_CHANGE, attributes);
        }
    }

    private boolean checkAutoLoginSetupChang(LicenseEntity prevLicenseEntity, LicenseEntity savedEntity) {
        return prevLicenseEntity.getIsReactive() != savedEntity.getIsReactive();
    }

    private boolean checkMaintainSetupChange(LicenseEntity prevLicenseEntity, LicenseEntity savedEntity) {
        return prevLicenseEntity.getIsNotLoginInLicense() != savedEntity.getIsNotLoginInLicense() || prevLicenseEntity.getLicenseKeepingCount() != savedEntity.getLicenseKeepingCount();
    }

    public void createLicenseEntityLog(String userName, LicenseEntity prevLicenseEntity, LicenseEntity savedEntity) throws Exception {
        if (this.checkAutoRemoveEnabledChange(prevLicenseEntity, savedEntity)) {
            this.insertAutoRemoveEnabledChangeLog(userName, savedEntity);
        } else if (this.checkAutoRemoveScheduleChange(prevLicenseEntity, savedEntity)) {
            this.insertAutoRemoveScheduleChangeLog(userName, prevLicenseEntity, savedEntity);
        }
    }

    private boolean checkAutoRemoveScheduleChange(LicenseEntity prevLicenseEntity, LicenseEntity savedEntity) {
        return prevLicenseEntity.getDeactiveScheduleHour() != savedEntity.getDeactiveScheduleHour() || prevLicenseEntity.getDeactiveScheduleInterval() != savedEntity.getDeactiveScheduleInterval() || prevLicenseEntity.getDeactiveScheduleWeek() != savedEntity.getDeactiveScheduleWeek() || !Objects.equals(prevLicenseEntity.getDeactiveScheduleDay(), savedEntity.getDeactiveScheduleDay()) || prevLicenseEntity.getLastLogin() != savedEntity.getLastLogin() || prevLicenseEntity.getIsInactive() != savedEntity.getIsInactive() || prevLicenseEntity.getIsNotLogin() != savedEntity.getIsNotLogin();
    }

    private boolean checkAutoRemoveEnabledChange(LicenseEntity prevLicenseEntity, LicenseEntity savedEntity) {
        return prevLicenseEntity.isDeactiveEnabled() != savedEntity.isDeactiveEnabled();
    }

    public void insertAutoRemoveEnabledChangeLog(String userName, LicenseEntity entity) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.AUTO_REMOVE_ENABLED, entity.isDeactiveEnabled());
        this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.AUTO_REMOVE_SETUP_ENABLED_CHANGE, attributes);
    }

    private void insertAutoRemoveScheduleChangeLog(String userName, LicenseEntity prevLicenseEntity, LicenseEntity savedEntity) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.AUTO_REMOVE_SCHEDULE_HOUR, prevLicenseEntity.getDeactiveScheduleHour(), savedEntity.getDeactiveScheduleHour());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.AUTO_REMOVE_SCHEDULE_INTERVAL, prevLicenseEntity.getDeactiveScheduleInterval(), savedEntity.getDeactiveScheduleInterval());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.AUTO_REMOVE_SCHEDULE_WEEK, prevLicenseEntity.getDeactiveScheduleWeek(), savedEntity.getDeactiveScheduleWeek());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.AUTO_REMOVE_SCHEDULE_DAY, prevLicenseEntity.getDeactiveScheduleDay(), savedEntity.getDeactiveScheduleDay());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.AUTO_REMOVE_LAST_LOGIN, prevLicenseEntity.getLastLogin(), savedEntity.getLastLogin());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.AUTO_REMOVE_IS_INACTIVE, prevLicenseEntity.getIsInactive(), savedEntity.getIsInactive());
        this.addAttributeIfChanged(attributes, SysHistoryAttributesType.AUTO_REMOVE_IS_NOT_LOGIN, prevLicenseEntity.getIsNotLogin(), savedEntity.getIsNotLogin());
        if (attributes.length() > 0) {
            this.insertSystemHistory(userName, SysHistoryType.SETTING_CHANGE, SysHistoryActionDetailType.AUTO_REMOVE_SCHEDULE_CHANGE, attributes);
        }
    }

    public void insertExecuteNotiLog(String triggerEvent) throws Exception {
        NotiEntity[] notiEntities;
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.NOTIFICATION_EXECUTE_EVENT, triggerEvent);
        SysHistoryEntity sysHistoryEntity = this.insertSystemHistory("SYSTEM", SysHistoryType.NOTIFICATION_EXECUTE, SysHistoryActionDetailType.NOTIFICATION_ACTION, attributes);
        for (NotiEntity notiEntity : notiEntities = (NotiEntity[])this.activeObjects.find(NotiEntity.class)) {
            this.insertNtfTrgLog(notiEntity.getNotificationType(), notiEntity.getNotificationTarget(), sysHistoryEntity);
        }
        this.addAttribute(attributes, SysHistoryAttributesType.NOTIFICATION_EXECUTE_TARGET, sysHistoryEntity.getID());
        this.updateSystemHistory("SYSTEM", SysHistoryType.NOTIFICATION_EXECUTE, SysHistoryActionDetailType.NOTIFICATION_ACTION, attributes, sysHistoryEntity.getID());
    }

    public void insertExecuteAutoRemoveJobLog(int removedUserCnt) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.AUTO_REMOVE_EXECUTE_COUNT, removedUserCnt);
        this.insertSystemHistory("SYSTEM", SysHistoryType.AUTO_REMOVE_EXECUTE, SysHistoryActionDetailType.AUTO_REMOVE_ACTION, attributes);
    }

    public void insertExecuteForceRemoveLog(String username, int removedUserCnt, boolean exclude) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.FORCE_REMOVE_EXECUTE_COUNT, removedUserCnt);
        this.addAttribute(attributes, SysHistoryAttributesType.FORCE_REMOVE_EXECUTE_IS_NOT_LOGIN, exclude);
        this.insertSystemHistory(username, SysHistoryType.FORCE_REMOVE_EXECUTE, SysHistoryActionDetailType.FORCE_REMOVE_ACTION, attributes);
    }

    public void insertExecuteMaintainLicenseCountsLog(int value) throws Exception {
        if (value == 0) {
            return;
        }
        JSONArray attributes = new JSONArray();
        this.addAttribute(attributes, SysHistoryAttributesType.MAINTAIN_LICENSE_EXECUTE_COUNT, value);
        this.insertSystemHistory("SYSTEM", SysHistoryType.MAINTAIN_LICENSE_USER_COUNT_EXECUTE, SysHistoryActionDetailType.MAINTAIN_LICENSE_ACTION, attributes);
    }

    public void insertExcludeTargetChangeLog(String userName, String targetAction, int type, String value) throws Exception {
        JSONArray attributes = new JSONArray();
        this.addTargetAttribute(attributes, SysHistoryAttributesType.EXCLUDE_TARGET.getKey(), targetAction, type, value);
        this.insertSystemHistory(userName, SysHistoryType.EXCLUDE_TARGET_SETTING_CHANGE, SysHistoryActionDetailType.EXCLUDE_TARGET_CHANGE, attributes);
    }

    private void addTargetAttribute(JSONArray attributes, String key, String action, int type, String value) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)key);
        jsonObject.put("action", (Object)action);
        jsonObject.put("type", type);
        jsonObject.put("value", (Object)value);
        attributes.put((Object)jsonObject);
    }

    private void addAttribute(JSONArray attributes, SysHistoryAttributesType attributesType, boolean value) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)attributesType.getKey());
        jsonObject.put("name", (Object)attributesType.getDescription());
        jsonObject.put("dataType", (Object)attributesType.getType());
        jsonObject.put("value", value);
        attributes.put((Object)jsonObject);
    }

    private void addAttribute(JSONArray attributes, SysHistoryAttributesType attributesType, String value) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)attributesType.getKey());
        jsonObject.put("name", (Object)attributesType.getDescription());
        jsonObject.put("dataType", (Object)attributesType.getType());
        jsonObject.put("value", (Object)value);
        attributes.put((Object)jsonObject);
    }

    private void addAttribute(JSONArray attributes, SysHistoryAttributesType attributesType, int value) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)attributesType.getKey());
        jsonObject.put("name", (Object)attributesType.getDescription());
        jsonObject.put("dataType", (Object)attributesType.getType());
        jsonObject.put("value", value);
        attributes.put((Object)jsonObject);
    }

    private void addAttributeIfChanged(JSONArray attributes, SysHistoryAttributesType attributesType, Object prevValue, Object newValue) throws JSONException {
        if (prevValue == null && newValue != null || prevValue != null && !prevValue.equals(newValue)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", (Object)attributesType.getKey());
            jsonObject.put("name", (Object)attributesType.getDescription());
            jsonObject.put("dataType", (Object)attributesType.getType());
            jsonObject.put("value", newValue);
            attributes.put((Object)jsonObject);
        }
    }

    public SysHistoryEntity insertSystemHistory(String userName, SysHistoryType sysHistoryType, SysHistoryActionDetailType sysHistoryActionDetailType, JSONArray attributes) throws Exception {
        SysHistoryEntity sysHistoryEntity = (SysHistoryEntity)this.activeObjects.create(SysHistoryEntity.class, new DBParam[0]);
        sysHistoryEntity.setAction(sysHistoryType.getValue());
        sysHistoryEntity.setActionDKey(sysHistoryActionDetailType.getValue());
        sysHistoryEntity.setAttributes(String.valueOf(attributes));
        sysHistoryEntity.setCreatedAt(this.getCurrentTimestamp());
        sysHistoryEntity.setCreatedBy(userName);
        sysHistoryEntity.save();
        return sysHistoryEntity;
    }

    public SysHistoryEntity updateSystemHistory(String userName, SysHistoryType sysHistoryType, SysHistoryActionDetailType sysHistoryActionDetailType, JSONArray attributes, int targetId) throws Exception {
        SysHistoryEntity sysHistoryEntity = this.getSystemsHistory(targetId);
        sysHistoryEntity.setAction(sysHistoryType.getValue());
        sysHistoryEntity.setActionDKey(sysHistoryActionDetailType.getValue());
        sysHistoryEntity.setAttributes(String.valueOf(attributes));
        sysHistoryEntity.setCreatedAt(this.getCurrentTimestamp());
        sysHistoryEntity.setCreatedBy(userName);
        sysHistoryEntity.save();
        return sysHistoryEntity;
    }

    public SysHistoryEntity getSystemsHistory(int targetId) throws Exception {
        SysHistoryEntity[] SysHistoryEntity2 = (SysHistoryEntity[])this.activeObjects.find(SysHistoryEntity.class, Query.select().where("ID = ?", new Object[]{targetId}));
        return SysHistoryEntity2[0];
    }

    public SysHistoryEntity[] getSystemsHistoryList() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date oneMonthsAgo = calendar.getTime();
        SysHistoryEntity[] SysHistoryEntities = (SysHistoryEntity[])this.activeObjects.find(SysHistoryEntity.class, Query.select().where("CREATED_AT >= ?", new Object[]{oneMonthsAgo}).order("CREATED_AT DESC"));
        return SysHistoryEntities;
    }

    public List<SysHistory> convertToSystemHistory(SysHistoryEntity[] SysHistoryEntities) throws InvocationTargetException, IllegalAccessException {
        ArrayList<SysHistory> systemHistoryList = new ArrayList<SysHistory>();
        for (SysHistoryEntity entity : SysHistoryEntities) {
            NtfTrgLogEntity[] ntfTrgLogsEntities = entity.getNtfTrgLogsEntities();
            List<NtfTrgLog> ntfTrgLogList = this.convertToNtfTrgLog(ntfTrgLogsEntities);
            String logStatus = this.i18n.getText(LOG_STATUS_PREFIX + entity.getActionDKey());
            String logSummary = this.i18n.getText(LOG_SUMMARY_PREFIX + entity.getActionDKey());
            String attributes = this.convertAttribute(entity.getAttributes());
            SysHistory sysHistory = new SysHistory(entity.getID(), entity.getAction(), entity.getActionDKey(), attributes, entity.getCreatedAt(), entity.getCreatedBy(), ntfTrgLogList, logStatus, logSummary);
            systemHistoryList.add(sysHistory);
        }
        return systemHistoryList;
    }

    public List<SysHistory> convertToSystemHistoryForExport(SysHistoryEntity[] SysHistoryEntities) throws InvocationTargetException, IllegalAccessException {
        ArrayList<SysHistory> systemHistoryList = new ArrayList<SysHistory>();
        for (SysHistoryEntity entity : SysHistoryEntities) {
            NtfTrgLogEntity[] ntfTrgLogsEntities = entity.getNtfTrgLogsEntities();
            List<NtfTrgLog> ntfTrgLogList = this.convertToNtfTrgLog(ntfTrgLogsEntities);
            String logStatus = this.i18n.getText(LOG_STATUS_PREFIX + entity.getActionDKey());
            String logSummary = this.i18n.getText(LOG_SUMMARY_PREFIX + entity.getActionDKey());
            String attributes = this.convertAttributeForExport(entity.getAttributes());
            SysHistory sysHistory = new SysHistory(entity.getID(), entity.getAction(), entity.getActionDKey(), attributes, entity.getCreatedAt(), entity.getCreatedBy(), ntfTrgLogList, logStatus, logSummary);
            systemHistoryList.add(sysHistory);
        }
        return systemHistoryList;
    }

    private String convertAttribute(String attribute) {
        JSONArray jsonArray = new JSONArray(attribute);
        JSONArray attributesJsonArray = new JSONArray();
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String key = LOG_ATTR_PREFIX + jsonObject.get("key");
            jsonObject.put("name", (Object)this.i18n.getText(key));
            jsonObject.put("value", (Object)this.formatAttributeValue(jsonObject));
            attributesJsonArray.put((Object)jsonObject);
        }
        return attributesJsonArray.toString();
    }

    private String convertAttributeForExport(String attribute) {
        JSONArray jsonArray = new JSONArray(attribute);
        JSONArray attributesJsonArray = new JSONArray();
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String key = LOG_ATTR_PREFIX + jsonObject.get("key");
            jsonObject.put("name", (Object)this.i18n.getText(key));
            jsonObject.put("value", (Object)this.formatAttributeValueForExport(jsonObject));
            attributesJsonArray.put((Object)jsonObject);
        }
        return attributesJsonArray.toString();
    }

    public List<NtfTrgLog> getNtfTrgLog(int ntfTrgLogId) throws Exception {
        NtfTrgLogEntity[] ntfTrgLogEntities = (NtfTrgLogEntity[])this.activeObjects.find(NtfTrgLogEntity.class, Query.select().where("SYS_HISTORY_ENTITY_ID = ?", new Object[]{ntfTrgLogId}));
        List<NtfTrgLog> ntfTrgLogList = this.convertToNtfTrgLog(ntfTrgLogEntities);
        return ntfTrgLogList;
    }

    private List<NtfTrgLog> convertToNtfTrgLog(NtfTrgLogEntity[] NtfTrgLogEntities) throws InvocationTargetException, IllegalAccessException {
        ArrayList<NtfTrgLog> ntfTrgLogList = new ArrayList<NtfTrgLog>();
        for (NtfTrgLogEntity entity : NtfTrgLogEntities) {
            NtfTrgLog ntfTrgLog = new NtfTrgLog();
            ntfTrgLog.setNotificationTarget(entity.getNotificationTarget());
            ntfTrgLog.setNotificationType(this.formatNotiTargetType(entity.getNotificationType()));
            ntfTrgLog.setCreatedAt(entity.getCreatedAt());
            ntfTrgLogList.add(ntfTrgLog);
        }
        return ntfTrgLogList;
    }

    public NtfTrgLogEntity insertNtfTrgLog(int notificationType, String notificationTarget, SysHistoryEntity sysHistoryEntity) throws Exception {
        NtfTrgLogEntity ntfTrgLogEntity = (NtfTrgLogEntity)this.activeObjects.create(NtfTrgLogEntity.class, new DBParam[0]);
        ntfTrgLogEntity.setNotificationType(notificationType);
        ntfTrgLogEntity.setNotificationTarget(notificationTarget);
        ntfTrgLogEntity.setSysHistoryEntity(sysHistoryEntity);
        ntfTrgLogEntity.setCreatedAt(this.getCurrentTimestamp());
        ntfTrgLogEntity.save();
        return ntfTrgLogEntity;
    }

    public Timestamp getCurrentTimestamp() throws ParseException {
        TimeZone timeZone = this.timeZoneManager.getDefaultTimeZone();
        Instant instant = Instant.now();
        ZoneId zoneId = ZoneId.of(timeZone.getID());
        ZonedDateTime zonedDateTime = instant.atZone(zoneId);
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        Timestamp timestamp = Timestamp.valueOf(localDateTime);
        return timestamp;
    }

    public SysHistoryEntity[] getSystemHistoryListBySearch(List<String> actionTypes, String beforeDate, String afterDate) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (beforeDate == null) {
            beforeDate = this.getDefaultBeforeDate();
        }
        if (afterDate == null) {
            afterDate = this.getDefaultAfterDate();
        }
        Date beforeDateTime = dateFormat.parse(beforeDate);
        Date afterDateTime = dateFormat.parse(afterDate);
        afterDateTime = this.addOneDay(afterDateTime);
        String queryClause = this.buildSearchQueryClause(actionTypes, beforeDateTime, afterDateTime);
        try {
            SysHistoryEntity[] systemHistoryEntities = (SysHistoryEntity[])this.activeObjects.find(SysHistoryEntity.class, Query.select().where(queryClause, new Object[]{beforeDateTime, afterDateTime}).order("CREATED_AT DESC").from(SysHistoryEntity.class));
            return systemHistoryEntities;
        }
        catch (Exception e) {
            throw new Exception("Error retrieving system history", e);
        }
    }

    public String createSystemHistoryCsvFileName() {
        LocalDateTime currentTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss");
        String formattedTime = currentTime.format(formatter);
        return "flexible_wiki_system_log_" + formattedTime + ".csv";
    }

    /*
     * Exception decompiling
     */
    public byte[] writeEntitiesToCsv(List<SysHistory> entities) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String buildCsvLine(int index, SysHistory entity) {
        StringBuilder lineBuilder = new StringBuilder();
        lineBuilder.append(index).append(",").append(this.formatSystemHistoryType(entity.getAction())).append(",").append(entity.getLogSummary()).append(",").append(DATE_FORMAT.format(entity.getCreatedAt())).append(",").append(entity.getCreatedBy()).append(",");
        String lastColumn = SystemHistoryService.isNotificationAction(entity) ? this.formatNotificationTargets(entity.getNtfTrgLogs()) : this.formatAttributes(entity.getAttributes());
        lineBuilder.append(lastColumn);
        return lineBuilder.toString();
    }

    private static boolean isNotificationAction(SysHistory entity) {
        return Objects.equals(entity.getActionDKey(), SysHistoryActionDetailType.NOTIFICATION_ACTION.getValue());
    }

    private String formatNotificationTargets(List<NtfTrgLog> ntfTrgLogs) {
        StringBuilder text = new StringBuilder("\"");
        for (NtfTrgLog ntfTrgLog : ntfTrgLogs) {
            text.append(ntfTrgLog.getNotificationType()).append(": ").append(ntfTrgLog.getNotificationTarget()).append("\n");
        }
        return text.append("\"").toString();
    }

    private String formatAttributes(String attributes) {
        JSONArray jsonArray = new JSONArray(attributes);
        StringBuilder text = new StringBuilder("\"");
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String name = jsonObject.getString("name");
            String value = jsonObject.getString("value");
            text.append(name).append(": ").append(value).append("\n");
        }
        return text.append("\"").toString();
    }

    private String formatAttributeValue(JSONObject jsonObject) {
        String type;
        JSONObject attribute = jsonObject;
        String string = type = attribute.has("dataType") ? attribute.getString("dataType") : "";
        if (!attribute.has("value")) {
            return "";
        }
        switch (type) {
            case "hour": {
                return SystemHistoryService.formatScheduleHour(attribute.getInt("value"));
            }
            case "week": {
                return this.formatScheduleWeek(attribute.getInt("value"));
            }
            case "interval": {
                return this.formatScheduleInterval(attribute.getInt("value"));
            }
            case "people": {
                return attribute.getString("value") + this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.PEOPLE.getKey());
            }
            case "day": {
                return this.formatScheduleDay(attribute.getString("value"));
            }
            case "days": {
                return attribute.getString("value") + this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.DAYS.getKey());
            }
            case "boolean": {
                return attribute.getBoolean("value") ? "<span class=\"aui-lozenge aui-lozenge-success\">True</span>" : "<span class=\"aui-lozenge aui-lozenge-removed\">False</span>";
            }
        }
        return attribute.getString("value");
    }

    private String formatAttributeValueForExport(JSONObject jsonObject) {
        String type;
        JSONObject attribute = jsonObject;
        String string = type = attribute.has("dataType") ? attribute.getString("dataType") : "";
        if (!attribute.has("value")) {
            return "";
        }
        switch (type) {
            case "hour": {
                return SystemHistoryService.formatScheduleHour(attribute.getInt("value"));
            }
            case "week": {
                return this.formatScheduleWeek(attribute.getInt("value"));
            }
            case "interval": {
                return this.formatScheduleInterval(attribute.getInt("value"));
            }
            case "people": {
                return attribute.getString("value") + this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.PEOPLE.getKey());
            }
            case "day": {
                return this.formatScheduleDay(attribute.getString("value"));
            }
            case "days": {
                return attribute.getString("value") + this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.DAYS.getKey());
            }
            case "boolean": {
                return attribute.getBoolean("value") ? "true" : "false";
            }
        }
        return attribute.getString("value");
    }

    private String formatNotiTargetType(int notiTargetType) {
        switch (notiTargetType) {
            case 1: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.NOTI_GROUP.getKey());
            }
            case 2: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.NOTI_USER.getKey());
            }
            case 3: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.NOTI_EXTERNAL_EMAIL.getKey());
            }
        }
        return "";
    }

    private String formatScheduleDay(String scheduleDay) {
        if (Objects.equals(scheduleDay, "L")) {
            return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.LAST_DAY.getKey());
        }
        return scheduleDay + this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.DAY.getKey());
    }

    private String formatScheduleWeek(int scheduleHour) {
        switch (scheduleHour) {
            case 1: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.WEEK_SUN.getKey());
            }
            case 2: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.WEEK_MON.getKey());
            }
            case 3: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.WEEK_TUE.getKey());
            }
            case 4: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.WEEK_WED.getKey());
            }
            case 5: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.WEEK_THU.getKey());
            }
            case 6: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.WEEK_FRI.getKey());
            }
            case 7: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.WEEK_SAT.getKey());
            }
        }
        return "";
    }

    public String formatScheduleInterval(int scheduleInterval) {
        switch (scheduleInterval) {
            case 1: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.INTERVAL_DAILY.getKey());
            }
            case 7: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.INTERVAL_WEEKLY.getKey());
            }
            case 30: {
                return this.i18n.getText(LOG_ATTR_PREFIX + SysHistoryAttributesSuffixType.INTERVAL_MONTHLY.getKey());
            }
        }
        return "";
    }

    private static String formatScheduleHour(int value) {
        if (value > 9) {
            return value + ":00";
        }
        return "0" + value + ":00";
    }

    private String formatSystemHistoryType(String historyType) {
        return this.i18n.getText(LOG_TYPE_PREFIX + historyType);
    }

    private String getDefaultBeforeDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
    }

    private String getDefaultAfterDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
    }

    private Date addOneDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    private String buildSearchQueryClause(List<String> actionType, Date beforeDateTime, Date afterDateTime) {
        StringBuilder queryClause = new StringBuilder();
        if (!actionType.isEmpty() && !actionType.contains("ALL")) {
            String typeQuery = actionType.stream().map(type -> "'" + type + "'").collect(Collectors.joining(", "));
            queryClause.append("ACTION IN (").append(typeQuery).append(") AND ");
        }
        queryClause.append("(CREATED_AT >= ? AND CREATED_AT < ?)");
        return queryClause.toString();
    }
}

