/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.services;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.common.GlobalStorage;
import kr.osci.luffy.entity.ProgressInfo;
import kr.osci.luffy.entity.ProgressInfoEntity;
import kr.osci.luffy.services.ActivateObjectsService;
import net.java.ao.Preload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

@Named
@Preload
public class ProgressInfoService
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ProgressInfoService.class);
    private final ActivateObjectsService activateObjectsService;
    @ComponentImport
    private final LicenseService licenseService;

    @Inject
    public ProgressInfoService(ActivateObjectsService activateObjectsService, LicenseService licenseService) {
        this.activateObjectsService = activateObjectsService;
        this.licenseService = licenseService;
    }

    public ProgressInfo getProgressInfoByStatus(String jobStatus) {
        Object[] progressInfoEntities = this.activateObjectsService.getProgressInfosByStatus(jobStatus);
        if (!ObjectUtils.isEmpty((Object[])progressInfoEntities)) {
            return ProgressInfo.convert((ProgressInfoEntity)progressInfoEntities[0]);
        }
        return null;
    }

    public ProgressInfo getProgressInfoById(int id) {
        ProgressInfoEntity progressInfoEntity = this.activateObjectsService.getProgressInfoById(id);
        ProgressInfo progressInfo = ProgressInfo.convert(progressInfoEntity);
        Object obj = GlobalStorage.get(Integer.toString(id));
        if (obj instanceof Number) {
            progressInfo.setProgressedPercentage(((Number)obj).doubleValue());
        }
        return progressInfo;
    }

    public void updateProgressInfosToFail() {
        this.activateObjectsService.updateProgressInfosToFail("PROCESSING");
    }
}

