/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.services;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.config.JobId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.db.CommonDbAccessService;
import kr.osci.luffy.entity.License;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.services.ActivateObjectsService;
import kr.osci.luffy.services.SystemHistoryService;
import net.java.ao.Preload;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Preload
public class AutoLoginService
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AutoLoginService.class);
    private final ActivateObjectsService activateObjectsService;
    private final CommonDbAccessService commonDbAccessService;
    private final SystemHistoryService systemHistoryService;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final LicenseService licenseService;
    @ComponentImport
    private final TransactionTemplate template;

    @Inject
    public AutoLoginService(ActivateObjectsService activateObjectsService, CommonDbAccessService commonDbAccessService, SystemHistoryService systemHistoryService, UserAccessor userAccessor, LicenseService licenseService, TransactionTemplate template) {
        this.activateObjectsService = activateObjectsService;
        this.commonDbAccessService = commonDbAccessService;
        this.systemHistoryService = systemHistoryService;
        this.userAccessor = userAccessor;
        this.licenseService = licenseService;
        this.template = template;
    }

    public void updateAutoLoginStatus(License license) {
        this.activateObjectsService.updateAutoLoginStatus(license);
    }

    public void updateKeepingLicenseStatus(License license) throws Exception {
        this.activateObjectsService.updateKeepingLicenseStatus(license);
    }

    public void updateAutoLoginConfig(License license) throws Exception {
        LicenseEntity entity = this.activateObjectsService.getLicense();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        LicenseEntity licenseEntity = this.activateObjectsService.updateAutoLoginConfig(license);
        this.systemHistoryService.insertAutoLoginSettingChangeLog(currentUser.getName(), entity, licenseEntity);
    }

    public void updateKeepingLicenseConfig(License license) throws Exception {
        LicenseEntity entity = this.activateObjectsService.getLicense();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (entity.getIsKeepingLicense()) {
            if (license.getLicenseKeepingCount() == 0) {
                throw new RuntimeException("ZERO");
            }
            ConfluenceLicense cl = this.licenseService.retrieve();
            int limit = cl.getMaximumNumberOfUsers();
            if (limit > 1) {
                if (limit < license.getLicenseKeepingCount()) {
                    throw new RuntimeException("EXCEED");
                }
                double lowerLimitDouble = (double)limit * 0.7;
                int lowerLimit = (int)Math.floor(lowerLimitDouble);
                if (lowerLimit == 0) {
                    throw new RuntimeException("INVALID");
                }
                if (lowerLimit > license.getLicenseKeepingCount()) {
                    throw new RuntimeException("LOWER");
                }
            }
            LicenseEntity licenseEntity = this.activateObjectsService.updateKeepingLicenseConfig(license);
            this.systemHistoryService.insertAutoLoginSettingChangeLog(currentUser.getName(), entity, licenseEntity);
        }
    }

    public void setAutoLoginToOn() {
        this.activateObjectsService.setAutoLoginToOn();
    }

    public void keepingLicense(JobId jobId) {
        LicenseEntity licenseEntity = this.activateObjectsService.getLicense();
        if (!ObjectUtils.isEmpty((Object)licenseEntity) && !StringUtils.isEmpty((CharSequence)licenseEntity.getTargetGroup())) {
            log.warn("INFO fulMaintainLicenseJob id: {} - getIsKeepingLicense : {} ", (Object)jobId, (Object)licenseEntity.getIsKeepingLicense());
            if (licenseEntity.getIsKeepingLicense()) {
                String licenseGroup = licenseEntity.getTargetGroup();
                log.warn("INFO fulMaintainLicenseJob id: {} - getTargetGroup : {} ", (Object)jobId, (Object)licenseGroup);
                log.warn("INFO fulMaintainLicenseJob id: {} - getLicenseKeepingCount : {} ", (Object)jobId, (Object)licenseEntity.getLicenseKeepingCount());
                ConfluenceLicense cl = this.licenseService.retrieve();
                int licenseTier = cl.getMaximumNumberOfUsers();
                int cntLicense = this.userAccessor.countLicenseConsumingUsers();
                int limit = 0;
                if (licenseEntity.getLicenseKeepingCount() > 0) {
                    if (cntLicense >= licenseEntity.getLicenseKeepingCount()) {
                        limit = cntLicense - licenseEntity.getLicenseKeepingCount() + 1;
                        log.warn("INFO fulMaintainLicenseJob id: {} - set number exceed : {} ", (Object)jobId, (Object)limit);
                        this.removeLicenseGroupUser(licenseGroup, limit, licenseEntity, jobId);
                    } else if (cntLicense >= licenseTier && licenseTier > 0) {
                        limit = cntLicense - licenseTier + 1;
                        log.warn("INFO fulMaintainLicenseJob id: {} - tier exceed : {} ", (Object)jobId, (Object)limit);
                        this.removeLicenseGroupUser(licenseGroup, limit, licenseEntity, jobId);
                    }
                } else if (licenseEntity.getLicenseKeepingCount() == 0 && licenseTier > 0) {
                    limit = cntLicense - licenseTier + 1;
                    log.warn("INFO fulMaintainLicenseJob id: {} - default tier exceed : {} ", (Object)jobId, (Object)limit);
                    if (limit > 0) {
                        this.removeLicenseGroupUser(licenseGroup, limit, licenseEntity, jobId);
                    }
                }
            }
        }
        log.warn("INFO fulMaintainLicenseJob id: {} - end job ", (Object)jobId);
    }

    private void removeLicenseGroupUser(String licenseGroup, int limit, LicenseEntity licenseEntity, JobId jobId) {
        List<Map<String, Object>> results = this.commonDbAccessService.getLastLoginInfoList(licenseEntity.getIsNotLoginInLicense(), licenseGroup);
        Stack<String> removeUserList = new Stack<String>();
        ArrayList<String> canuseUsers = new ArrayList<String>();
        for (Map<String, Object> row : results) {
            Object userName;
            if (!row.containsKey("user_name") || !((userName = row.get("user_name")) instanceof String)) continue;
            canuseUsers.add((String)userName);
        }
        List<String> filteredCanUseUsers = this.activateObjectsService.filterRemoveUsersByExcludeEntity(canuseUsers);
        removeUserList.addAll(filteredCanUseUsers.subList(0, Math.min(limit, filteredCanUseUsers.size())));
        try {
            this.activateObjectsService.removeUserFromGroup(removeUserList, licenseGroup);
            this.systemHistoryService.insertExecuteMaintainLicenseCountsLog(removeUserList.size());
            log.warn("INFO fulMaintainLicenseJob id: {} - removeUserList.size() : {} ", (Object)jobId, (Object)removeUserList.size());
        }
        catch (Exception e) {
            log.error("AutoLoginService.removeLicenseGroupUser : ", (Throwable)e);
        }
    }
}

