/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.admin.actions.RefreshLicensingAction;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.common.GlobalStorage;
import kr.osci.luffy.entity.Active;
import kr.osci.luffy.entity.ActiveEntity;
import kr.osci.luffy.entity.Exclude;
import kr.osci.luffy.entity.ExcludeEntity;
import kr.osci.luffy.entity.GroupListEntity;
import kr.osci.luffy.entity.License;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.entity.Noti;
import kr.osci.luffy.entity.NotiEntity;
import kr.osci.luffy.entity.NotiSetup;
import kr.osci.luffy.entity.NotiSetupEntity;
import kr.osci.luffy.entity.ProgressInfo;
import kr.osci.luffy.entity.ProgressInfoEntity;
import kr.osci.luffy.entity.ReportEntity;
import kr.osci.luffy.entity.UserHistoryType;
import kr.osci.luffy.jobs.MaintainLicenseJob;
import kr.osci.luffy.jobs.UserCountController;
import kr.osci.luffy.jobs.UserCountJob;
import kr.osci.luffy.services.MailService;
import kr.osci.luffy.services.SystemHistoryService;
import kr.osci.luffy.services.UserHistoryService;
import kr.osci.luffy.utils.DateUtils;
import kr.osci.luffy.utils.MailTemplate;
import kr.osci.luffy.utils.NumberUtils;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ObjectUtils;

@Named
public class ActivateObjectsService
implements Serializable,
InitializingBean {
    private static final long serialVersionUID = 6521816437331502113L;
    private static final Logger log = LoggerFactory.getLogger(ActivateObjectsService.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd");
    private long startTime = System.currentTimeMillis();
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginManager loginManager;
    @ComponentImport
    private CrowdService crowdService;
    private ApplicationContext context;
    private UserCountJob userCountJob;
    @ComponentImport
    private final LocaleManager localeManager;
    private UserCountController userControllerJob;
    private MaintainLicenseJob maintainLicenseJob;
    private final MailService mailService;
    @ComponentImport
    private final SchedulerService schedulerService;
    @ComponentImport
    private final SettingsManager settingsManager;
    @ComponentImport
    private final UserChecker userChecker;
    private final UserHistoryService userHistoryService;
    private final SystemHistoryService systemHistoryService;
    @ComponentImport
    private final TransactionTemplate template;
    @ComponentImport
    private final I18nResolver i18n;

    @Inject
    public ActivateObjectsService(ActiveObjects activeObject, GroupManager groupManager, UserAccessor userAccessor, BandanaManager bandanaManager, UserManager userManager, MailService mailService, ApplicationContext context, CrowdService crowdService, LoginManager loginManager, LocaleManager localeManager, SchedulerService schedulerService, SettingsManager settingsManager, UserChecker userChecker, UserHistoryService userHistoryService, SystemHistoryService systemHistoryService, TransactionTemplate template, I18nResolver i18n) {
        this.activeObjects = activeObject;
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
        this.bandanaManager = bandanaManager;
        this.userManager = userManager;
        this.mailService = mailService;
        this.crowdService = crowdService;
        this.loginManager = loginManager;
        this.localeManager = localeManager;
        this.context = context;
        this.schedulerService = schedulerService;
        this.settingsManager = settingsManager;
        this.userChecker = userChecker;
        this.userHistoryService = userHistoryService;
        this.systemHistoryService = systemHistoryService;
        this.template = template;
        this.i18n = i18n;
    }

    public LicenseEntity getLicense() {
        LicenseEntity entity = (LicenseEntity)this.activeObjects.get(LicenseEntity.class, (Object)1);
        if (entity == null) {
            entity = this.initLicense();
        }
        return entity;
    }

    public boolean isDeactiveEnabled() {
        LicenseEntity entity = this.getLicense();
        return entity.isDeactiveEnabled();
    }

    public void setSourceGroup(String group) {
        LicenseEntity entity = this.getLicense();
        entity.setSourceGroup(group);
        entity.save();
    }

    public void setTargetGroup(String group) {
        LicenseEntity entity = this.getLicense();
        entity.setTargetGroup(group);
        entity.save();
    }

    public String getTargetGroup() {
        LicenseEntity entity = this.getLicense();
        return entity.getTargetGroup();
    }

    public GroupListEntity[] getGroupList() {
        GroupListEntity[] entities = null;
        try {
            entities = (GroupListEntity[])this.activeObjects.find(GroupListEntity.class, Query.select().order("ID DESC"));
            if (entities == null) {
                entities = this.initGroupLists();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entities;
    }

    private GroupListEntity[] initGroupLists() {
        Date today = new Date();
        GroupListEntity entity = (GroupListEntity)this.activeObjects.create(GroupListEntity.class, new DBParam[0]);
        entity.setUserGroupName("N");
        entity.setPriority(1);
        entity.setInUse(false);
        entity.setCreatedAt(today);
        entity.setUpdatedAt(today);
        entity.save();
        return new GroupListEntity[]{entity};
    }

    public String getFlexUrl() {
        LicenseEntity entity = this.getLicense();
        return entity.getFlexUrl();
    }

    public LicenseEntity updateControl(License license) throws SchedulerServiceException {
        LicenseEntity entity = this.getLicense();
        entity.setUserLimit(license.getUserLimit());
        entity.setNotiLimit(license.getNotiLimit());
        entity.setLastLogin(license.getLastLogin());
        entity.setDeactiveScheduleHour(license.getDeactiveScheduleHour());
        entity.setDeactiveScheduleMin(license.getDeactiveScheduleMin());
        entity.setDeactiveScheduleInterval(license.getDeactiveScheduleInterval());
        entity.setIsInactive(license.getIsInactive());
        entity.setIsReactive(license.getIsReactive());
        entity.setIsNotLogin(license.getIsNotLogin());
        entity.setDeactiveEnabled(license.isDeactiveEnabled());
        entity.setCountCanuseGroup(license.getCountCanuseGroup());
        entity.setCountCanuseDate(license.getCountCanuseDate());
        entity.setCountSourceGroup(license.getCountSourceGroup());
        entity.setCountSourceDate(license.getCountSourceDate());
        entity.setNotiGroup(license.getNotiGroup());
        entity.setFlexUrl(license.getFlexurl());
        entity.setDeactiveScheduleWeek(license.getDeactiveScheduleWeek());
        entity.setDeactiveScheduleDay(license.getDeactiveScheduleDay());
        entity.save();
        this.registAutoRemoveJob(entity);
        return entity;
    }

    public List<String> getRemoveUsersByLastLogin(List<String> canuseUsers, int days, boolean excludeNoLoginUsers) {
        long time;
        ArrayList<String> removeUserList = new ArrayList<String>();
        Date date = new Date();
        log.warn("\n Start getLoginInfo in canuse group " + date);
        Map<Long, List<String>> removeUserMap = this.getLastLogindate(canuseUsers, excludeNoLoginUsers);
        date = new Date();
        log.warn("\n End getLoginInfo in canuse group " + date);
        long agoTime = days == 0 ? System.currentTimeMillis() : System.currentTimeMillis() - TimeUnit.DAYS.toMillis(days);
        Iterator<Long> iterator = removeUserMap.keySet().iterator();
        while (iterator.hasNext() && (time = iterator.next().longValue()) < agoTime) {
            removeUserList.addAll((Collection)removeUserMap.get(time));
        }
        date = new Date();
        log.warn("\n End getRemoveUsersByLastLogin " + date);
        return removeUserList;
    }

    public Stack<String> getRemoveUsersByCount(double count, boolean test) throws Exception {
        Stack<String> removeUserList = new Stack<String>();
        LicenseEntity entity = this.getLicense();
        String canuseGroup = entity.getTargetGroup();
        List canuseUsers = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(canuseGroup));
        List<String> filteredCanUseUsers = this.filterRemoveUsersByExcludeEntity(canuseUsers);
        log.warn("filteredCanUseUsers Count ::::::" + filteredCanUseUsers);
        if (filteredCanUseUsers.size() == 0) {
            return removeUserList;
        }
        double removeUserCnt = 0.0;
        removeUserCnt = (double)canuseUsers.size() - count >= (double)filteredCanUseUsers.size() ? (double)filteredCanUseUsers.size() : (double)canuseUsers.size() - count;
        log.warn("canuseUsers.size() - count ::::::" + removeUserCnt);
        Date date = new Date();
        log.warn("\n Start getLoginInfo in canuse group " + date);
        Map<Long, List<String>> removeUserMap = this.getLastLogindate(filteredCanUseUsers, entity.getIsNotLogin());
        date = new Date();
        log.warn("\n End getLoginInfo in canuse group " + date);
        long low = 0L;
        long high = 0L;
        for (long key : removeUserMap.keySet()) {
            List<String> userList = removeUserMap.get(key);
            for (String user : userList) {
                if (!((double)removeUserList.size() < removeUserCnt)) break;
                removeUserList.push(user);
            }
            high = key;
            if (low == 0L) {
                low = key;
            }
            if (!((double)removeUserList.size() >= removeUserCnt)) continue;
            break;
        }
        if (!test) {
            this.removeUserFromGroup(removeUserList, canuseGroup);
        }
        date = new Date();
        log.warn("\n End getRemoveUsersByCount " + date);
        return removeUserList;
    }

    public List<String> filterRemoveUsersByExcludeEntity(List<String> removeUserList) {
        LinkedHashSet<String> removeUserHashSet = new LinkedHashSet<String>(removeUserList);
        try {
            Set<String> excludeUserHashSet = this.getAllUsersFromExcludeEntity();
            removeUserHashSet.removeAll(excludeUserHashSet);
        }
        catch (Exception e) {
            log.error("filterRemoveUsersByExcludeEntity Exception : " + e.getMessage());
        }
        return new ArrayList<String>(removeUserHashSet);
    }

    public Set<String> getAllUsersFromExcludeEntity() {
        HashSet<String> excludeUserHashSet = new HashSet<String>();
        try {
            ExcludeEntity[] excludeEntityUserList;
            ExcludeEntity[] excludeEntityGroupList;
            for (ExcludeEntity excludeEntity : excludeEntityGroupList = this.getExcludeEntityList(1)) {
                String groupName = excludeEntity.getExcludeTarget();
                List memberNamesAsList = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(groupName));
                excludeUserHashSet.addAll(memberNamesAsList);
            }
            for (ExcludeEntity excludeEntity : excludeEntityUserList = this.getExcludeEntityList(2)) {
                String userName = excludeEntity.getExcludeTarget();
                excludeUserHashSet.add(userName);
            }
        }
        catch (Exception e) {
            log.error("getAllUsersFromExcludeEntity Exception : " + e.getMessage());
        }
        return excludeUserHashSet;
    }

    public void removeUserFromGroup(Stack<String> removeUserList, String canuseGroup) throws Exception {
        AtomicInteger cnt = new AtomicInteger();
        log.warn("INFO {} users will be removed from the group.", (Object)removeUserList.size());
        com.atlassian.user.Group group = this.groupManager.getGroup(canuseGroup);
        Group crowdGroup = this.crowdService.getGroup(canuseGroup);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (String user : removeUserList) {
            executor.submit(() -> this.template.execute(() -> {
                try {
                    boolean removeUserFromGroup = this.crowdService.removeUserFromGroup(this.crowdService.getUser(user), crowdGroup);
                    if (!removeUserFromGroup) {
                        this.groupManager.removeMembership(group, (com.atlassian.user.User)this.userAccessor.getUserByName(user));
                    }
                    log.debug("Boolean removeUserFromGroup" + removeUserFromGroup);
                    cnt.getAndIncrement();
                    log.debug("cnt++" + cnt);
                    this.userHistoryService.insertUserHistory(user, UserHistoryType.FORCE_REMOVE.getValue(), "SYSTEM");
                }
                catch (Exception e) {
                    log.warn("removeUserFromGroup fail - user : {}, group : {}", (Object)user, (Object)canuseGroup);
                    log.error("removeUserFromGroup error", (Throwable)e);
                }
                return null;
            }));
        }
        executor.shutdown();
        try {
            boolean terminated;
            while (!executor.isTerminated() && !(terminated = executor.awaitTermination(1L, TimeUnit.SECONDS))) {
            }
        }
        catch (InterruptedException e) {
            log.error("Executor interrupted while awaiting termination", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.refreshLicenseCnt();
    }

    public Stack<String> getRemoveUsersByCount(double count, boolean excludeNoLogin, int id) throws Exception {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ProgressInfo progressInfo = ProgressInfo.convert(this.getProgressInfoById(id));
        String progressInfoId = Integer.toString(id);
        Stack<String> removeUserList = new Stack<String>();
        LicenseEntity entity = this.getLicense();
        String canuseGroup = entity.getTargetGroup();
        List canuseUsers = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(canuseGroup));
        List<String> filteredCanUseUsers = this.filterRemoveUsersByExcludeEntity(canuseUsers);
        log.warn("filteredCanUseUsers Count ::::::" + filteredCanUseUsers);
        if (filteredCanUseUsers.size() == 0) {
            progressInfo.setTotal(0);
            progressInfo.setJobStatus("COMPLETE");
            progressInfo.setCompletedAt(new Date());
            this.updateProgressInfo(progressInfo);
            return removeUserList;
        }
        double removeUserCnt = 0.0;
        removeUserCnt = (double)canuseUsers.size() - count >= (double)filteredCanUseUsers.size() ? (double)filteredCanUseUsers.size() : (double)canuseUsers.size() - count;
        log.warn("canuseUsers.size() - count ::::::" + removeUserCnt);
        Date date = new Date();
        log.warn("\n Start getLoginInfo in canuse group " + date);
        Map<Long, List<String>> removeUserMap = this.getLastLogindateForForceRemove(filteredCanUseUsers, excludeNoLogin, progressInfoId);
        date = new Date();
        log.warn("\n End getLoginInfo in canuse group " + date);
        long low = 0L;
        long high = 0L;
        for (long key : removeUserMap.keySet()) {
            List<String> userList = removeUserMap.get(key);
            for (String string : userList) {
                if (!((double)removeUserList.size() < removeUserCnt)) break;
                removeUserList.push(string);
            }
            high = key;
            if (low == 0L) {
                low = key;
            }
            if (!((double)removeUserList.size() >= removeUserCnt)) continue;
            break;
        }
        int total = removeUserList.size();
        progressInfo.setTotal(total);
        this.updateProgressInfo(progressInfo);
        AtomicInteger cnt = new AtomicInteger();
        log.warn("{} users will be removed from the group.", (Object)removeUserList.size());
        com.atlassian.user.Group group = this.groupManager.getGroup(canuseGroup);
        Group crowdGroup = this.crowdService.getGroup(canuseGroup);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (String user : removeUserList) {
            executor.submit(() -> this.template.execute(() -> {
                try {
                    boolean removeUserFromGroup = this.crowdService.removeUserFromGroup(this.crowdService.getUser(user), crowdGroup);
                    if (!removeUserFromGroup) {
                        this.groupManager.removeMembership(group, (com.atlassian.user.User)this.userAccessor.getUserByName(user));
                    }
                    log.debug("Boolean removeUserFromGroup" + removeUserFromGroup);
                    cnt.getAndIncrement();
                    log.debug("cnt++" + cnt);
                    double progressedPercentage = NumberUtils.calculateProgressPercentage(total, cnt.get()) / 2.0 + 50.0;
                    GlobalStorage.put(progressInfoId, progressedPercentage);
                    this.userHistoryService.insertUserHistory(user, UserHistoryType.FORCE_REMOVE.getValue(), currentUser.getName(), progressInfo.getID());
                }
                catch (Exception e) {
                    log.error("getRemoveUsersByCount error", (Throwable)e);
                }
                return null;
            }));
        }
        executor.shutdown();
        try {
            boolean bl;
            while (!executor.isTerminated() && !(bl = executor.awaitTermination(1L, TimeUnit.SECONDS))) {
            }
        }
        catch (InterruptedException interruptedException) {
            log.error("Executor interrupted while awaiting termination", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        this.refreshLicenseCnt();
        date = new Date();
        log.warn("\n End getRemoveUsersByCount " + date);
        progressInfo.setJobStatus("COMPLETE");
        progressInfo.setCompletedAt(new Date());
        this.updateProgressInfo(progressInfo);
        GlobalStorage.remove(progressInfoId);
        return removeUserList;
    }

    public void refreshLicenseCnt() {
        try {
            RefreshLicensingAction refreshLicensingAction = new RefreshLicensingAction();
            refreshLicensingAction.setUserChecker(this.userChecker);
            String actionResult = refreshLicensingAction.execute();
            int usageCnt = this.userAccessor.countLicenseConsumingUsers();
            log.warn("\n countLicenseConsumingUsers : " + usageCnt + " , actionResult : " + actionResult);
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred while refresh license count. ", (Throwable)e);
        }
    }

    private Map<Long, List<String>> getLastLogindate(List<String> canuseUsers, boolean excludeNoLoginUsers) {
        TreeMap<Long, List<String>> removeUserMap = new TreeMap<Long, List<String>>();
        for (String user : canuseUsers) {
            if (user == null) continue;
            try {
                Long time = this.loginManager.getLoginInfo(user).getLastSuccessfulLoginDate().getTime();
                removeUserMap.computeIfAbsent(time, k -> new ArrayList()).add(user);
            }
            catch (Exception e) {
                if (!excludeNoLoginUsers) {
                    removeUserMap.computeIfAbsent(Long.MIN_VALUE, k -> new ArrayList()).add(user);
                }
                log.debug("{} has not logged in yet.", (Object)user);
            }
        }
        return removeUserMap;
    }

    private Map<Long, List<String>> getLastLogindateForForceRemove(List<String> canuseUsers, boolean excludeNoLoginUsers, String progressInfoId) {
        TreeMap<Long, List<String>> removeUserMap = new TreeMap<Long, List<String>>();
        int total = canuseUsers.size();
        int progressedCount = 0;
        for (String user : canuseUsers) {
            if (user != null) {
                try {
                    Long time = this.loginManager.getLoginInfo(user).getLastSuccessfulLoginDate().getTime();
                    removeUserMap.computeIfAbsent(time, k -> new ArrayList()).add(user);
                }
                catch (Exception e) {
                    if (!excludeNoLoginUsers) {
                        removeUserMap.computeIfAbsent(Long.MIN_VALUE, k -> new ArrayList()).add(user);
                    }
                    log.debug("{} has not logged in yet.", (Object)user);
                }
            }
            double progressedPercentage = NumberUtils.calculateProgressPercentage(total, ++progressedCount) / 2.0;
            GlobalStorage.put(progressInfoId, progressedPercentage);
        }
        GlobalStorage.put(progressInfoId, 50);
        return removeUserMap;
    }

    private boolean isActiveUser(String user) {
        return this.userAccessor.isDeactivated(user);
    }

    private int getReduceUsersByCount(int count) throws Exception {
        LicenseEntity entity = this.getLicense();
        String canuseGroup = entity.getTargetGroup();
        List canuseUsers = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(canuseGroup));
        log.warn("canuseUsers Count ::::::", (Object)canuseUsers);
        return canuseUsers.size() - count;
    }

    public void deactiveUsersByLastLogin(List<String> removeUserList) throws Exception {
        try {
            String adminUsername = this.getAdminUser();
            ConfluenceUser adminAppUser = this.userAccessor.getUserByName(adminUsername);
            if (!this.userManager.isAdmin(adminAppUser.getKey())) {
                throw new Exception("[" + adminUsername + "] User is Not Admin");
            }
            log.debug("deactiveUsersByLastLogin ::: execute Admin User " + adminAppUser);
            AuthenticatedUserThreadLocal.set((ConfluenceUser)adminAppUser);
            for (String userName : removeUserList) {
                try {
                    ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                    this.userAccessor.deactivateUser((com.atlassian.user.User)confluenceUser);
                }
                catch (Exception e) {
                    log.error("deactiveUsersByLastLogin ::: [{}] User is Not Exist", (Object)userName);
                    log.error("crowdService.deactiveUsersByLastLogin error", (Object)e.getMessage());
                }
            }
            return;
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred while deactive user(s) in auto remove job.", (Throwable)e);
            return;
        }
    }

    public String getAdminUser() {
        try {
            Object adminUserObj = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "kr.osci.luffy.entity.admin.user");
            if (adminUserObj != null) {
                return (String)adminUserObj;
            }
            return AuthenticatedUserThreadLocal.get().getName();
        }
        catch (Exception ex) {
            log.debug(ex.getMessage());
            return null;
        }
    }

    public List<String> removeUsersByLastLogin(int day, boolean sendemail) throws Exception {
        String canuseGroup = this.getLicense().getTargetGroup();
        boolean isInactive = this.getLicense().getIsInactive();
        int oldLicenseCnt = this.userAccessor.countLicenseConsumingUsers();
        boolean excludeNoLoginUsers = this.getLicense().getIsNotLogin();
        List<String> filteredUsersByLastLogin = this.getRemoveUsersByLastLogin(this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(canuseGroup)), day, excludeNoLoginUsers);
        List<String> removeUserList = this.filterRemoveUsersByExcludeEntity(filteredUsersByLastLogin);
        log.debug("[{}] users will be removed in target group[{}].", (Object)removeUserList.size(), (Object)canuseGroup);
        try {
            com.atlassian.user.Group group = this.groupManager.getGroup(canuseGroup);
            Group crowdGroup = this.crowdService.getGroup(canuseGroup);
            for (String user : removeUserList) {
                try {
                    boolean removeUserFromGroup = this.crowdService.removeUserFromGroup(this.crowdService.getUser(user), crowdGroup);
                    if (!removeUserFromGroup) {
                        this.groupManager.removeMembership(group, (com.atlassian.user.User)this.userAccessor.getUserByName(user));
                    }
                    this.userHistoryService.insertUserHistory(user, UserHistoryType.AUTO_REMOVE.getValue(), "SYSTEM");
                }
                catch (Exception e) {
                    log.error("[{}] User is Not Exist", (Object)user);
                    log.error("crowdService.removeUserFromGroup error", (Object)e.getMessage());
                }
            }
            if (isInactive) {
                this.deactiveUsersByLastLogin(removeUserList);
            }
            this.refreshLicenseCnt();
            this.systemHistoryService.insertExecuteAutoRemoveJobLog(removeUserList.size());
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred while remove user(s) in target group.", (Throwable)e);
        }
        log.debug("[{}] users were removed successfully in target group[{}].", (Object)removeUserList.size(), (Object)canuseGroup);
        LicenseEntity entity = this.getLicense();
        NotiEntity[] notiEntities = this.getNotiEntity();
        log.warn("\n send email is " + sendemail + "\n\n");
        if (removeUserList.size() > 0) {
            if (notiEntities.length == 0) {
                return removeUserList;
            }
            Locale locale = this.localeManager.getLocale((com.atlassian.user.User)AuthenticatedUserThreadLocal.get());
            String language = locale.getLanguage();
            String subject = MailTemplate.getSubjectByRemoveUsers(this.i18n, locale);
            log.debug("locale : {}", (Object)locale);
            log.debug("subject : {}", (Object)subject);
            String baseurl = this.getFlexUrl();
            this.refreshLicenseCnt();
            int tempLicenseCnt = this.userAccessor.countLicenseConsumingUsers();
            int cntLicense = 0;
            cntLicense = oldLicenseCnt == tempLicenseCnt ? (tempLicenseCnt > removeUserList.size() ? tempLicenseCnt - removeUserList.size() : tempLicenseCnt) : tempLicenseCnt;
            String html = MailTemplate.getBodyByRemoveUsers(this.i18n, locale, baseurl, entity.getTargetGroup(), entity.getLastLogin(), removeUserList.size(), cntLicense);
            if (this.getEmailList().size() == 0) {
                return removeUserList;
            }
            Email email = new Email(StringUtils.join(this.getEmailList(), (String)","));
            email.setSubject(subject);
            email.setMimeType("text/html");
            email.setBody(html);
            email.setEncoding("UTF-8");
            SingleMailQueueItem item = new SingleMailQueueItem(email);
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SMTPMailServer.class.getClassLoader());
            item.send();
            Thread.currentThread().setContextClassLoader(threadClassLoader);
            this.systemHistoryService.insertExecuteNotiLog("Auto Remove");
            log.debug("Added removeUsersByLastLogin queue");
        }
        return removeUserList;
    }

    public String getEmailTemp(String locale, String baseurl, int licenseGroupCnt) {
        String html_ko = "<table cellpadding=\"0\" cellspacing=\"0\"style=\"border: 0; width: 100%;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Noto Sans,Ubuntu,Droid Sans,Helvetica Neue,sans-serif;color:#172b4d;font-size:14px;line-height:22px;\">\n    <tbody>\n      <tr>\n        <td>\n          <div style=\"width: 520px; margin: 0 auto;\">\n            <h1 style=\"font-size:24px;font-style:inherit;font-weight:500;letter-spacing:-0.01em;line-height:28px;margin:auto;margin-top:28px;text-align:left; padding: 40px 0; border-bottom: 1px solid #ccc;\">\n              <img src=\"https://flexjira.osci.kr/images/pluginLogo.png\" style=\"width: 30px;vertical-align: top;margin-right: 10px;\" alt=\"\">Flexible User License</h1>\n            <div style=\"margin-top: 60px;\"><p style=\"padding-left: 30px;\">\ub77c\uc774\uc120\uc2a4 \uadf8\ub8f9 \uc0ac\uc6a9\uc790 \uc218: <strong style=\"color:#0052cc;\">" + licenseGroupCnt + "</strong></p></div>\n            <div><p style=\"padding-left: 30px;\">\ub77c\uc774\uc120\uc2a4 \uadf8\ub8f9 \uc0ac\uc6a9\uc790 \uc218\uac00 <em style=\"font-weight: bold; font-style: normal;color:#0052cc;\">\ucd5c\ub300 \uc218\uce58\ub97c \ucd08\uacfc</em>\ud558\uc600\uc2b5\ub2c8\ub2e4.</p></div>\n          </div>\n        </td>\n      </tr>\n      <tr>\n        <td align=\"center\" style=\"padding-bottom:20px;padding-top:40px\">\n          <div style=\"width: 520px; margin: 40px auto 0;\">\n            <a style=\"box-sizing:border-box;border-radius:3px;border-width:0;display:inline-flex;font-style:normal;font-size:inherit;margin:0;outline:none;padding:8px 16px;text-align:center;vertical-align:middle;white-space:nowrap;background:#0052cc;color:#fff;text-decoration:none\"\n              href=\"" + baseurl + "\" target=\"_blank\">Flexible User License\ub85c \uc774\ub3d9</a>\n          </div>\n        </td>\n      </tr>\n      <tr><td style=\"font-family:'Helvetica neue',Helvetica,Arial,Verdana,sans-serif;font-size:13px;line-height:19px;color:#707070;\">\n          <div style=\"width: 520px; margin: 60px auto 0; border-top: 1px solid #ccc; padding-top: 20px; text-align: center;\">\n            <p>\uc774 \uc774\uba54\uc77c\uc740 \uacc4\uc815 \ubc0f \uc11c\ube44\uc2a4\uc758 \uc911\uc694\ud55c \ubcc0\uacbd \uc0ac\ud56d\uc744 \uc54c\ub824\ub4dc\ub9ac\uae30 \uc704\ud574 \ubc1c\uc1a1\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</p>\n            <p>\u00a9 Open Source Consulting Inc., \uc11c\uc6b8\ud2b9\ubcc4\uc2dc \uac15\ub0a8\uad6c \ud14c\ud5e4\ub780\ub85c83\uae38 32, 5\uce35 (\uc0bc\uc131\ub3d9)</p>\n          </div></td>\n      </tr></tbody></table>";
        String html_en = "<table cellpadding=\"0\" cellspacing=\"0\"style=\"border: 0; width: 100%;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Noto Sans,Ubuntu,Droid Sans,Helvetica Neue,sans-serif;color:#172b4d;font-size:14px;line-height:22px;\">\n        <tbody>\n          <tr>\n            <td>\n              <div style=\"width: 580px; margin: 0 auto;\">\n                <h1 style=\"font-size:24px;font-style:inherit;font-weight:500;letter-spacing:-0.01em;line-height:28px;margin:auto;margin-top:28px;text-align:left; padding: 40px 0; border-bottom: 1px solid #ccc;\">\n                  <img src=\"https://flexjira.osci.kr/images/pluginLogo.png\" style=\"width: 30px;vertical-align: top;margin-right: 10px;\" alt=\"\">Flexible User License</h1>\n                <div style=\"margin-top: 60px;\"><p style=\"padding-left: 30px;\">Licensed Group Count: <strong style=\"color:#0052cc;\">" + licenseGroupCnt + "</strong></p></div>\n                <div><p style=\"padding-left: 30px;\">The number of users in licensed group <em style=\"font-weight: bold; font-style: normal;color:#0052cc;\">exceeds the maximum user count.</em></p></div>\n              </div>\n            </td>\n          </tr>\n          <tr>\n            <td align=\"center\" style=\"padding-bottom:20px;padding-top:40px\">\n              <div style=\"width: 580px; margin: 40px auto 0;\">\n                <a style=\"box-sizing:border-box;border-radius:3px;border-width:0;display:inline-flex;font-style:normal;font-size:inherit;margin:0;outline:none;padding:8px 16px;text-align:center;vertical-align:middle;white-space:nowrap;background:#0052cc;color:#fff;text-decoration:none\"\n                  href=\"" + baseurl + "\" target=\"_blank\">Go to Flexible User License</a>\n              </div>\n            </td>\n          </tr>\n          <tr><td style=\"font-family:'Helvetica neue',Helvetica,Arial,Verdana,sans-serif;font-size:13px;line-height:19px;color:#707070;\">\n              <div style=\"width: 580px; margin: 60px auto 0; border-top: 1px solid #ccc; padding-top: 20px; text-align: center;\">\n                <p>This email has been sent to notify you of important changes to your account and services.</p>\n                <p>\u00a9 Open Source Consulting Inc., 5F, 32, Teheran-ro 83-gil, Gangnam-gu, Seoul, Republic of Korea</p>\n              </div></td>\n          </tr></tbody></table>";
        return locale == "ko" ? html_ko : html_en;
    }

    public List<String> reduceUsersByCount(int count) throws Exception {
        int removeCount = this.getReduceUsersByCount(count);
        String targetGroup = this.getLicense().getTargetGroup();
        Stack<String> userList = this.getRemoveUsersByCount(removeCount, false);
        log.warn("[{}] users were removed successfully in target group[{}].", (Object)userList.size(), (Object)targetGroup);
        return userList;
    }

    public List<String> reduceUsersByCountModify(double count, boolean excludeNoLogin, int id) throws Exception {
        String targetGroup = this.getLicense().getTargetGroup();
        Stack<String> userList = this.getRemoveUsersByCount(count, excludeNoLogin, id);
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        this.systemHistoryService.insertExecuteForceRemoveLog(currentUser.getName(), userList.size(), excludeNoLogin);
        log.warn("[{}] users were removed successfully in target group[{}].", (Object)userList.size(), (Object)targetGroup);
        return userList;
    }

    public List<String> removeUsersBySchedule() throws Exception {
        LicenseEntity entity = this.getLicense();
        return this.removeUsersByLastLogin(entity.getLastLogin(), true);
    }

    public Map<Integer, Map<String, Integer>> getReport(Integer year, Integer startWeek, Integer endWeek) {
        Date startDate = this.getStartDate(year, startWeek);
        Date endDate = this.getEndDate(year, endWeek);
        log.info("getReport() from " + startDate + " to " + endDate);
        Map<Integer, Map<String, Integer>> result = this.initReportResult(year, startWeek, endWeek);
        ReportEntity[] reports = (ReportEntity[])this.activeObjects.find(ReportEntity.class, Query.select().where("CHECK_DATE >= ? and CHECK_DATE <= ?", new Object[]{startDate, endDate}));
        String oldDate = null;
        int sameDateCount = 0;
        int daySum = 0;
        for (int i = 0; i < reports.length; ++i) {
            int week;
            String newDate = DATE_FORMAT.format(reports[i].getCheckDate());
            if (oldDate == null) {
                oldDate = newDate;
            }
            if (newDate.equals(oldDate)) {
                ++sameDateCount;
                daySum += reports[i].getCount();
            } else {
                week = this.getWeekOfYear(reports[i - 1].getCheckDate());
                result.get(week).put(oldDate, daySum / sameDateCount);
                sameDateCount = 1;
                daySum = reports[i].getCount();
                oldDate = newDate;
            }
            if (i != reports.length - 1) continue;
            week = this.getWeekOfYear(reports[i].getCheckDate());
            result.get(week).put(oldDate, daySum / sameDateCount);
        }
        for (int i = startWeek.intValue(); i <= endWeek; ++i) {
            Map<String, Integer> subResult = result.get(i);
            int zeroCount = 0;
            int sum = 0;
            for (Integer value : subResult.values()) {
                if (value == 0) {
                    ++zeroCount;
                }
                sum += value.intValue();
            }
            int average = zeroCount == 7 ? 0 : sum / (7 - zeroCount);
            subResult.put("Average", average);
        }
        return result;
    }

    private LicenseEntity initLicense() {
        LicenseEntity entity;
        try {
            entity = (LicenseEntity)this.activeObjects.get(LicenseEntity.class, (Object)1);
            this.activeObjects.delete(new RawEntity[]{entity});
            this.activeObjects.flushAll();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        entity = (LicenseEntity)this.activeObjects.create(LicenseEntity.class, new DBParam[]{new DBParam("ID", (Object)1)});
        entity.setUserLimit(9999);
        entity.setNotiLimit(0);
        entity.setLastLogin(0);
        entity.setDeactiveScheduleHour(1);
        entity.setDeactiveScheduleInterval(1);
        entity.setDeactiveEnabled(false);
        entity.setReportingScheduleHour(1);
        entity.setSourceGroup("N");
        entity.setTargetGroup("N");
        entity.setIsAutoLogin(true);
        entity.setIsKeepingLicense(false);
        entity.setLicenseKeepingInterval(0);
        entity.setLicenseKeepingTimeUnit(0);
        entity.save();
        return entity;
    }

    private Date getStartDate(Integer year, Integer startWeek) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(1, year);
        cal.set(3, startWeek);
        cal.set(7, 1);
        return cal.getTime();
    }

    private Date getEndDate(Integer year, Integer endWeek) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(1, year);
        cal.set(3, endWeek);
        cal.set(7, 7);
        return cal.getTime();
    }

    private int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    private Map<Integer, Map<String, Integer>> initReportResult(Integer year, Integer startWeek, Integer endWeek) {
        TreeMap<Integer, Map<String, Integer>> result = new TreeMap<Integer, Map<String, Integer>>();
        for (int i = startWeek.intValue(); i <= endWeek; ++i) {
            TreeMap<String, Integer> subResult = new TreeMap<String, Integer>();
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(1, year);
            cal.set(3, i);
            cal.set(7, 1);
            subResult.put(DATE_FORMAT.format(cal.getTime()), 0);
            for (int j = 1; j < 7; ++j) {
                cal.add(5, 1);
                subResult.put(DATE_FORMAT.format(cal.getTime()), 0);
            }
            result.put(i, subResult);
        }
        return result;
    }

    public void afterPropertiesSet() {
        this.startTime = System.currentTimeMillis();
    }

    public int setTargetGroupUsersCountBySchedule() throws EntityException {
        LicenseEntity entity = this.getLicense();
        int result = 0;
        try {
            List userList = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(entity.getTargetGroup()));
            ReportEntity reportEntity = (ReportEntity)this.activeObjects.create(ReportEntity.class, new DBParam[0]);
            reportEntity.setCheckDate(new Date(System.currentTimeMillis()));
            reportEntity.setCount(userList.size());
            reportEntity.save();
            result = userList.size();
        }
        catch (Exception e) {
            log.error("sec.log.error" + e.getMessage());
        }
        Iterator iter = this.userAccessor.getMembers(this.groupManager.getGroup(entity.getNotiGroup())).iterator();
        ArrayList<String> user = new ArrayList<String>();
        while (iter.hasNext()) {
            user.add(((ConfluenceUser)iter.next()).getEmail());
        }
        log.warn("send to " + StringUtils.join(user, (String)","));
        Email email = new Email(StringUtils.join(user, (String)","));
        email.setSubject("[Report] Confluence User Count");
        email.setMimeType("text/html");
        email.setBody("Canuse Group Count " + result);
        email.setEncoding("UTF-8");
        SingleMailQueueItem mailQueueItem = new SingleMailQueueItem(email);
        this.mailService.sendEmail((MailQueueItem)mailQueueItem);
        return result;
    }

    public ArrayList<Boolean> getUserGroup(String userName) {
        LicenseEntity entity = this.getLicense();
        GroupListEntity[] groupListEntities = this.getGroupList();
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        try {
            Boolean isSource = false;
            for (GroupListEntity groupListEntity : groupListEntities) {
                String sourceGroup = groupListEntity.getUserGroupName();
                isSource = this.crowdService.isUserMemberOfGroup(this.crowdService.getUser(userName), this.crowdService.getGroup(sourceGroup));
                if (isSource.booleanValue()) break;
            }
            Boolean isTarget = this.crowdService.isUserMemberOfGroup(this.crowdService.getUser(userName), this.crowdService.getGroup(entity.getTargetGroup()));
            result.add(isSource);
            result.add(isTarget);
        }
        catch (Exception e) {
            result.add(false);
        }
        return result;
    }

    public Active saveActiveEntity(Active entity) {
        ActiveEntity activeEntity = (ActiveEntity)this.activeObjects.get(ActiveEntity.class, (Object)1);
        if (activeEntity == null) {
            activeEntity = (ActiveEntity)this.activeObjects.create(ActiveEntity.class, new DBParam[0]);
        }
        activeEntity.setActiveUserCnt(entity.getActiveUserCnt());
        activeEntity.setActiveUserTerm(entity.getActiveUserTerm());
        activeEntity.setActiveTerm(entity.getActiveTerm());
        activeEntity.save();
        return entity;
    }

    public ActiveEntity getActiveEntity() {
        ActiveEntity activeEntity = (ActiveEntity)this.activeObjects.get(ActiveEntity.class, (Object)1);
        return activeEntity;
    }

    public boolean checkAddGroupList(String groupName) {
        boolean rst = false;
        GroupListEntity[] groupListEntities = this.getGroupList();
        rst = groupListEntities.length == 0 ? true : !this.checkGroupListByName(groupName);
        return rst;
    }

    public GroupListEntity getGroupListByName(String groupName) {
        GroupListEntity[] entityList = (GroupListEntity[])this.activeObjects.find(GroupListEntity.class, Query.select().where("USER_GROUP_NAME LIKE ?", new Object[]{"%" + groupName}));
        if (entityList != null) {
            for (GroupListEntity entity : entityList) {
                if (!entity.getUserGroupName().equals(groupName)) continue;
                return entity;
            }
        }
        return null;
    }

    public void delGroupList(String groupName) {
        GroupListEntity entity = this.getGroupListByName(groupName);
        if (entity != null && !Objects.equals(entity.getUserGroupName(), "N")) {
            this.activeObjects.delete(new RawEntity[]{entity});
        }
    }

    public boolean checkGroupListByName(String groupName) {
        GroupListEntity[] entityList = (GroupListEntity[])this.activeObjects.find(GroupListEntity.class, Query.select().where("USER_GROUP_NAME LIKE ?", new Object[]{"%" + groupName}));
        boolean rst = false;
        if (entityList != null) {
            for (GroupListEntity entity : entityList) {
                if (!entity.getUserGroupName().equals(groupName)) continue;
                rst = true;
                break;
            }
        }
        return rst;
    }

    public void setGroupListUserGroupName(String groupName) {
        GroupListEntity entity = this.initGroupList();
        entity.setUserGroupName(groupName);
        entity.setInUse(true);
        entity.save();
    }

    private GroupListEntity initGroupList() {
        Date today = new Date();
        GroupListEntity entity = (GroupListEntity)this.activeObjects.create(GroupListEntity.class, new DBParam[0]);
        entity.setUserGroupName("N");
        entity.setPriority(1);
        entity.setInUse(false);
        entity.setCreatedAt(today);
        entity.setUpdatedAt(today);
        entity.save();
        return entity;
    }

    public ExcludeEntity initExcludeEntity() {
        ExcludeEntity entity = (ExcludeEntity)this.activeObjects.create(ExcludeEntity.class, new DBParam[0]);
        entity.setExcludeTarget("no target");
        entity.setExcludeTargetType(0);
        return entity;
    }

    public ExcludeEntity setExcludeEntity(Exclude exclude) {
        ExcludeEntity excludeTargetEntity = this.initExcludeEntity();
        excludeTargetEntity.setExcludeTarget(exclude.getExcludeTarget());
        excludeTargetEntity.setExcludeTargetType(exclude.getExcludeTargetType());
        excludeTargetEntity.save();
        return excludeTargetEntity;
    }

    public String validateExcludeEntity(Exclude exclude) {
        ExcludeEntity[] entityList = this.getExcludeEntityList(exclude.getExcludeTargetType());
        if (entityList != null) {
            for (ExcludeEntity e : entityList) {
                if (!e.getExcludeTarget().equals(exclude.getExcludeTarget())) continue;
                return "existed";
            }
        }
        return "canAdd";
    }

    public ExcludeEntity[] removeExcludeEntity(String removeTarget) throws SQLException {
        ExcludeEntity[] entity = (ExcludeEntity[])this.activeObjects.find(ExcludeEntity.class, Query.select().where("EXCLUDE_TARGET = ?", new Object[]{removeTarget}));
        this.activeObjects.delete((RawEntity[])entity);
        return entity;
    }

    public ExcludeEntity[] getExcludeEntityList(int searchType) {
        return (ExcludeEntity[])this.activeObjects.find(ExcludeEntity.class, Query.select().where("EXCLUDE_TARGET_TYPE = ?", new Object[]{searchType}).order("ID"));
    }

    public NotiEntity[] getNotiEntity(int searchType) {
        return (NotiEntity[])this.activeObjects.find(NotiEntity.class, Query.select().where("NOTIFICATION_TYPE = ?", new Object[]{searchType}).order("ID"));
    }

    public NotiSetupEntity getNotiSetup() {
        NotiSetupEntity entity = (NotiSetupEntity)this.activeObjects.get(NotiSetupEntity.class, (Object)1);
        if (entity == null) {
            entity = this.initNotiSetupEntity();
        }
        return entity;
    }

    public String validateNoti(Noti noti) {
        NotiEntity[] entityList = this.getNotiList(noti.getNotificationType());
        if (entityList != null) {
            for (NotiEntity e : entityList) {
                if (!e.getNotificationTarget().equals(noti.getNotificationTarget())) continue;
                return "existed";
            }
        }
        return "canAdd";
    }

    public NotiEntity setNoti(Noti noti) {
        NotiEntity notiEntity = this.initNotiEntity();
        notiEntity.setNotificationTarget(noti.getNotificationTarget());
        notiEntity.setNotificationType(noti.getNotificationType());
        notiEntity.save();
        return notiEntity;
    }

    public NotiSetupEntity setNotiSetup(NotiSetup notiSetup) {
        NotiSetupEntity entity = this.getNotiSetup();
        entity.setInUse(notiSetup.getInUse());
        entity.setScheduleHour(notiSetup.getScheduleHour());
        entity.setScheduleInterval(notiSetup.getScheduleInterval());
        entity.setScheduleWeek(notiSetup.getScheduleWeek());
        entity.setScheduleDay(notiSetup.getScheduleDay());
        entity.setNotiLimit(notiSetup.getNotiLimit());
        entity.save();
        return entity;
    }

    public NotiSetupEntity updateNotiSetup(NotiSetup notiSetup) {
        NotiSetupEntity entity = this.getNotiSetup();
        entity.setInUse(notiSetup.getInUse());
        entity.save();
        return entity;
    }

    public NotiEntity[] removeNotiTarget(String removeTarget) throws SQLException {
        NotiEntity[] entity = (NotiEntity[])this.activeObjects.find(NotiEntity.class, Query.select().where("NOTIFICATION_TARGET = ?", new Object[]{removeTarget}));
        this.activeObjects.delete((RawEntity[])entity);
        return entity;
    }

    public NotiEntity[] getNotiList(int searchType) {
        NotiEntity[] entity = (NotiEntity[])this.activeObjects.find(NotiEntity.class, Query.select().where("NOTIFICATION_TYPE = ?", new Object[]{searchType}).order("ID"));
        return entity;
    }

    public NotiEntity initNotiEntity() {
        NotiEntity entity = (NotiEntity)this.activeObjects.create(NotiEntity.class, new DBParam[0]);
        entity.setNotificationTarget("no target");
        entity.setNotificationType(0);
        return entity;
    }

    public NotiEntity[] getNotiEntity() {
        NotiEntity[] entity = (NotiEntity[])this.activeObjects.find(NotiEntity.class);
        return entity;
    }

    public NotiSetupEntity initNotiSetupEntity() {
        NotiSetupEntity entity = (NotiSetupEntity)this.activeObjects.create(NotiSetupEntity.class, new DBParam[0]);
        entity.setInUse(false);
        entity.setScheduleHour(4);
        entity.setScheduleInterval(1);
        entity.setNotiLimit(0);
        return entity;
    }

    public void setUserCountControllerJob(LicenseEntity entity) throws SchedulerServiceException {
        String jobTime = "0 0 hour 1/day * ? *";
        jobTime = jobTime.replace("hour", String.valueOf(entity.getDeactiveScheduleHour()));
        jobTime = jobTime.replace("day", String.valueOf(entity.getDeactiveScheduleInterval()));
        if (this.userControllerJob == null) {
            this.userControllerJob = (UserCountController)this.context.getBean(UserCountController.class);
        }
        this.schedulerService.unscheduleJob(JobId.of((String)UserCountController.class.getName()));
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)UserCountController.class.getName()));
        JobDetails registedJob = this.schedulerService.getJobDetails(JobId.of((String)UserCountController.class.getName()));
        while (registedJob != null) {
            this.schedulerService.unscheduleJob(JobId.of((String)UserCountController.class.getName()));
            this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)UserCountController.class.getName()));
        }
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)UserCountController.class.getName()), (JobRunner)this.userControllerJob);
        log.warn("userControllerJob JOB Config " + jobTime);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)UserCountController.class.getName())).withSchedule(Schedule.forCronExpression((String)jobTime)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        this.schedulerService.scheduleJob(JobId.of((String)UserCountController.class.getName()), jobConfig);
    }

    public HashMap<String, Object> getRegisteredScheduleJobs() {
        HashMap<String, Object> registeredScheduleJobs = new HashMap<String, Object>();
        try {
            JobDetails autoRemoveJob = null;
            JobDetails notiRegisteredJob = null;
            JobDetails maintainLicenseJob = null;
            try {
                autoRemoveJob = this.schedulerService.getJobDetails(JobId.of((String)UserCountController.class.getName()));
            }
            catch (Exception e) {
                log.error("Failed to get autoRemoveJob", (Throwable)e);
            }
            try {
                notiRegisteredJob = this.schedulerService.getJobDetails(JobId.of((String)UserCountJob.class.getName()));
            }
            catch (Exception e) {
                log.error("Failed to get notiRegisteredJob", (Throwable)e);
            }
            try {
                maintainLicenseJob = this.schedulerService.getJobDetails(JobId.of((String)MaintainLicenseJob.class.getName()));
            }
            catch (Exception e) {
                log.error("Failed to get maintainLicenseJob", (Throwable)e);
            }
            registeredScheduleJobs.put("autoRemoveJob", this.buildJobResult(autoRemoveJob));
            registeredScheduleJobs.put("notiRegisteredJob", this.buildJobResult(notiRegisteredJob));
            registeredScheduleJobs.put("maintainLicenseJob", this.buildJobResult(maintainLicenseJob));
        }
        catch (Exception e) {
            log.error("getRegisteredScheduleJobs: unexpected error", (Throwable)e);
        }
        return registeredScheduleJobs;
    }

    private Map<String, Object> buildJobResult(JobDetails jobDetails) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (jobDetails == null) {
            result.put("registed", false);
        } else {
            result.put("registed", true);
            try {
                Date detailsNextRunTime = jobDetails.getNextRunTime();
                result.put("detailsNextRunTime", DateUtils.formatTimestampToDate(detailsNextRunTime));
            }
            catch (Exception e) {
                result.put("detailsNextRunTime", null);
            }
            try {
                Schedule schedule = jobDetails.getSchedule();
                Date nextRunTime = this.schedulerService.calculateNextRunTime(schedule);
                result.put("nextRunTime", DateUtils.formatTimestampToDate(nextRunTime));
            }
            catch (Exception e) {
                result.put("nextRunTime", null);
            }
        }
        return result;
    }

    public void setUserCountJob(NotiSetupEntity notiSetupEntity) throws SchedulerServiceException {
        String jobTime = this.makeCronExpression(notiSetupEntity.getScheduleInterval(), notiSetupEntity.getScheduleWeek(), notiSetupEntity.getScheduleDay(), notiSetupEntity.getScheduleHour());
        if (this.userCountJob == null) {
            this.userCountJob = (UserCountJob)this.context.getBean(UserCountJob.class);
        }
        this.schedulerService.unscheduleJob(JobId.of((String)UserCountJob.class.getName()));
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)UserCountJob.class.getName()));
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)UserCountJob.class.getName()), (JobRunner)this.userCountJob);
        log.warn("userCountJob JOB Config " + jobTime);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)UserCountJob.class.getName())).withSchedule(Schedule.forCronExpression((String)jobTime)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        this.schedulerService.scheduleJob(JobId.of((String)UserCountJob.class.getName()), jobConfig);
    }

    public void overUsersSendEmail(int notiCount) throws Exception {
        String baseurl = this.getFlexUrl();
        Locale locale = this.localeManager.getLocale((com.atlassian.user.User)AuthenticatedUserThreadLocal.get());
        String language = locale.getLanguage();
        String subject = MailTemplate.getSubjectByOverUsers(this.i18n, locale);
        log.debug("locale : {}", (Object)locale);
        log.debug("subject : {}", (Object)subject);
        String html = MailTemplate.getBodyByOverUsers(this.i18n, locale, baseurl, notiCount);
        Email email = new Email(StringUtils.join(this.getEmailList(), (String)","));
        email.setSubject(subject);
        email.setMimeType("text/html");
        email.setBody(html);
        email.setEncoding("UTF-8");
        SingleMailQueueItem item = new SingleMailQueueItem(email);
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SMTPMailServer.class.getClassLoader());
        item.send();
        Thread.currentThread().setContextClassLoader(threadClassLoader);
        this.systemHistoryService.insertExecuteNotiLog("License Exceed");
        log.warn("Added overUsersSendEmail queue");
    }

    public Set<String> getEmailList() throws EntityException {
        NotiEntity[] notiEntities;
        HashSet<String> emailList = new HashSet<String>();
        block5: for (NotiEntity notiEntity : notiEntities = this.getNotiEntity()) {
            switch (notiEntity.getNotificationType()) {
                case 1: {
                    Iterable confluenceUsers = this.userAccessor.getMembers(this.groupManager.getGroup(notiEntity.getNotificationTarget()));
                    if (confluenceUsers == null) continue block5;
                    for (ConfluenceUser confluenceUser : confluenceUsers) {
                        emailList.add(confluenceUser.getEmail());
                    }
                    continue block5;
                }
                case 2: {
                    ConfluenceUser confluenceUser = this.userAccessor.getUserByName(notiEntity.getNotificationTarget());
                    if (confluenceUser == null) continue block5;
                    emailList.add(confluenceUser.getEmail());
                    continue block5;
                }
                case 3: {
                    emailList.add(notiEntity.getNotificationTarget());
                }
            }
        }
        return emailList;
    }

    public com.atlassian.user.Group createGroup(String groupName) throws Exception {
        return this.groupManager.createGroup(groupName);
    }

    public Set<String> moveUsersGroupToGroup(List<String> sourceGroupList, String destiGroupName) throws UserNotFoundException, OperationFailedException, GroupNotFoundException, OperationNotPermittedException {
        HashSet<String> userList = new HashSet<String>();
        Boolean isCreated = false;
        for (String groupName : sourceGroupList) {
            com.atlassian.user.Group group = this.userAccessor.getGroup(groupName);
            userList.addAll(this.userAccessor.getMemberNamesAsList(group));
        }
        com.atlassian.user.Group moveGroup = this.userAccessor.getGroup(destiGroupName);
        if (!ObjectUtils.isEmpty((Object)moveGroup)) {
            for (String user : userList) {
                this.userAccessor.addMembership(destiGroupName, user);
            }
        }
        return userList;
    }

    private String makeCronExpression(int interval, int week, String day, int hour) {
        String jobTime = "0 0 hour day * week";
        String scheduleWeek = "?";
        String scheduleDay = "*";
        if (interval == 7) {
            scheduleWeek = String.valueOf(week);
            scheduleDay = "?";
        } else if (interval == 30) {
            scheduleDay = day;
        }
        jobTime = jobTime.replace("hour", String.valueOf(hour));
        jobTime = jobTime.replace("week", scheduleWeek);
        jobTime = jobTime.replace("day", scheduleDay);
        return jobTime;
    }

    public void registAutoRemoveJob(LicenseEntity entity) throws SchedulerServiceException {
        String jobTime = this.makeCronExpression(entity.getDeactiveScheduleInterval(), entity.getDeactiveScheduleWeek(), entity.getDeactiveScheduleDay(), entity.getDeactiveScheduleHour());
        if (this.userControllerJob == null) {
            this.userControllerJob = (UserCountController)this.context.getBean(UserCountController.class);
        }
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)UserCountController.class.getName()), (JobRunner)this.userControllerJob);
        log.warn("userControllerJob JOB Config " + jobTime);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)UserCountController.class.getName())).withSchedule(Schedule.forCronExpression((String)jobTime)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        this.schedulerService.scheduleJob(JobId.of((String)UserCountController.class.getName()), jobConfig);
    }

    private String makeCronForMaintainLicenseJob(int interval, int timeUnit) {
        log.warn("makeCronForMaintainLicenseJob interval : {}", (Object)interval);
        log.warn("makeCronForMaintainLicenseJob timeUnit : {}", (Object)timeUnit);
        String jobTime = "0 minute hour * * ? *";
        String scheduleMinute = "*";
        String scheduleHour = "*";
        if (timeUnit == 1) {
            scheduleMinute = String.valueOf("0/" + interval);
        } else if (timeUnit == 60) {
            scheduleMinute = "0";
            scheduleHour = String.valueOf("0/" + interval);
            if (interval == 24) {
                scheduleHour = "0";
            }
        }
        jobTime = jobTime.replace("minute", scheduleMinute);
        jobTime = jobTime.replace("hour", scheduleHour);
        return jobTime;
    }

    public void createMaintainLicenseJob(LicenseEntity entity) throws SchedulerServiceException {
        if (entity.getLicenseKeepingTimeUnit() == 0 && entity.getLicenseKeepingInterval() == 0) {
            entity.setLicenseKeepingInterval(30);
            entity.setLicenseKeepingTimeUnit(1);
            entity.save();
        }
        String jobTime = this.makeCronForMaintainLicenseJob(entity.getLicenseKeepingInterval(), entity.getLicenseKeepingTimeUnit());
        if (this.maintainLicenseJob == null) {
            this.maintainLicenseJob = (MaintainLicenseJob)this.context.getBean(MaintainLicenseJob.class);
        }
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)MaintainLicenseJob.class.getName()), (JobRunner)this.maintainLicenseJob);
        log.warn("maintainLicenseJob JOB Config " + jobTime);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)MaintainLicenseJob.class.getName())).withSchedule(Schedule.forCronExpression((String)jobTime)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        this.schedulerService.scheduleJob(JobId.of((String)MaintainLicenseJob.class.getName()), jobConfig);
    }

    public void initJob() {
        log.warn("----- initJob -----");
        try {
            this.template.execute(() -> {
                LicenseEntity entity = (LicenseEntity)this.activeObjects.get(LicenseEntity.class, (Object)1);
                NotiSetupEntity notiSetupEntity = (NotiSetupEntity)this.activeObjects.get(NotiSetupEntity.class, (Object)1);
                try {
                    if (entity != null) {
                        this.registAutoRemoveJob(entity);
                        if (entity.getIsKeepingLicense()) {
                            this.createMaintainLicenseJob(entity);
                        }
                    }
                    if (notiSetupEntity != null) {
                        this.setUserCountJob(notiSetupEntity);
                    }
                }
                catch (SchedulerServiceException se) {
                    log.error("Flexible User Licnese fail to regist scheduler while staring addon SchedulerServiceException ::: \n", (Throwable)se);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.error("Flexible User Licnese fail to regist scheduler while staring addon ::: \n", (Throwable)e);
        }
    }

    public void updateAutoLoginStatus(License license) {
        LicenseEntity entity = this.getLicense();
        entity.setIsAutoLogin(license.getIsAutoLogin());
        entity.save();
    }

    public LicenseEntity updateAutoLoginConfig(License license) {
        LicenseEntity entity = this.getLicense();
        entity.setIsReactive(license.getIsReactive());
        entity.save();
        return entity;
    }

    public void updateKeepingLicenseStatus(License license) throws SchedulerServiceException {
        LicenseEntity entity = this.getLicense();
        entity.setIsKeepingLicense(license.getIsKeepingLicense());
        entity.save();
        this.createMaintainLicenseJob(entity);
    }

    public LicenseEntity updateKeepingLicenseConfig(License license) throws SchedulerServiceException {
        LicenseEntity entity = this.getLicense();
        if (entity.getIsKeepingLicense()) {
            entity.setIsNotLoginInLicense(license.getIsNotLoginInLicense());
            entity.setLicenseKeepingCount(license.getLicenseKeepingCount());
            entity.setLicenseKeepingTimeUnit(license.getLicenseKeepingTimeUnit());
            entity.setLicenseKeepingInterval(license.getLicenseKeepingInterval());
        }
        entity.save();
        this.createMaintainLicenseJob(entity);
        return entity;
    }

    public ProgressInfoEntity createProgressInfo(ProgressInfo progressInfo) {
        ProgressInfoEntity entity = (ProgressInfoEntity)this.activeObjects.create(ProgressInfoEntity.class, new DBParam[0]);
        entity.setJobType("FORCE_REMOVE");
        entity.setCreatorKey(progressInfo.getCreatorKey());
        entity.setCreator(progressInfo.getCreator());
        entity.setJobStatus("PROCESSING");
        entity.setCreatedAt(new Date());
        entity.save();
        return entity;
    }

    public ProgressInfoEntity[] getProgressInfosByStatus(String jobStatus) {
        try {
            ProgressInfoEntity[] progressInfoEntities = (ProgressInfoEntity[])this.activeObjects.find(ProgressInfoEntity.class, Query.select().where("JOB_TYPE = ?", new Object[]{"FORCE_REMOVE"}).where("JOB_STATUS = ?", new Object[]{jobStatus}).order("CREATED_AT DESC").from(ProgressInfoEntity.class));
            if (progressInfoEntities.length > 0) {
                return progressInfoEntities;
            }
        }
        catch (Exception e) {
            log.error("getProgressInfosByStatus : ", (Throwable)e);
        }
        return null;
    }

    public ProgressInfoEntity getProgressInfoById(int id) {
        return (ProgressInfoEntity)this.activeObjects.get(ProgressInfoEntity.class, (Object)id);
    }

    public void updateProgressInfo(ProgressInfo progressInfo) {
        try {
            ProgressInfoEntity progressInfoEntity = (ProgressInfoEntity)this.activeObjects.get(ProgressInfoEntity.class, (Object)progressInfo.getID());
            if (!ObjectUtils.isEmpty((Object)progressInfo.getJobStatus())) {
                progressInfoEntity.setJobStatus(progressInfo.getJobStatus());
            }
            if (!ObjectUtils.isEmpty((Object)progressInfo.getTotal())) {
                progressInfoEntity.setTotal(progressInfo.getTotal());
            }
            if (!ObjectUtils.isEmpty((Object)progressInfo.getCompletedAt())) {
                progressInfoEntity.setCompletedAt(progressInfo.getCompletedAt());
            }
            progressInfoEntity.save();
        }
        catch (Exception e) {
            log.error("updateProgressInfo : ", (Throwable)e);
        }
    }

    public void updateProgressInfosToFail(String jobStatus) {
        this.template.execute(() -> {
            Object[] progressInfoEntities = this.getProgressInfosByStatus(jobStatus);
            if (!ObjectUtils.isEmpty((Object[])progressInfoEntities)) {
                for (Object progressInfoEntity : progressInfoEntities) {
                    progressInfoEntity.setJobStatus("FAIL");
                    progressInfoEntity.save();
                }
            }
            return null;
        });
    }

    public void setAutoLoginToOn() {
        this.template.execute(() -> {
            LicenseEntity entity = this.getLicense();
            if (ObjectUtils.isEmpty((Object)entity.getIsAutoLogin())) {
                entity.setIsAutoLogin(true);
                entity.save();
            }
            return null;
        });
    }

    public boolean isUserInSourceGroup(User cUser) {
        GroupListEntity[] groupListEntities;
        for (GroupListEntity groupListEntity : groupListEntities = this.getGroupList()) {
            String sourceGroup = groupListEntity.getUserGroupName();
            boolean isSource = this.crowdService.isUserMemberOfGroup(cUser, this.crowdService.getGroup(sourceGroup));
            if (!isSource) continue;
            return true;
        }
        return false;
    }

    public boolean isUserInTargetGroup(String userId) throws EntityException {
        String targetGroup = this.getTargetGroup();
        return this.groupManager.hasMembership(this.groupManager.getGroup(targetGroup), (com.atlassian.user.User)this.userAccessor.getUserByName(userId));
    }
}

