/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.rest;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.luffy.entity.UserHistory;
import kr.osci.luffy.services.UserHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/history")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Named(value="UserHistoryResource")
public class UserHistoryResource
implements Serializable {
    private static final long serialVersionUID = 4123275969789078194L;
    private static final Logger log = LoggerFactory.getLogger(UserHistoryResource.class);
    private static final Gson gson = new Gson();
    private final UserHistoryService userHistoryService;

    @Inject
    public UserHistoryResource(UserHistoryService userHistoryService) {
        this.userHistoryService = userHistoryService;
    }

    @GET
    @Path(value="/userhistory")
    public Response getAllUserHistory() {
        List<Object> userHistoryList = new ArrayList();
        try {
            userHistoryList = this.userHistoryService.getUsersHistoryList();
        }
        catch (Exception e) {
            log.error("getAllUserHistory", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok((Object)gson.toJson(userHistoryList)).build();
    }

    @GET
    @Path(value="/userhistory/search")
    public Response getUserHistoryBySearch(@QueryParam(value="keyword") String keyword, @QueryParam(value="actionTypes") List<String> actionTypes, @QueryParam(value="beforeDate") String beforeDate, @QueryParam(value="afterDate") String afterDate) {
        List<Object> userHistoryList = new ArrayList();
        try {
            userHistoryList = this.userHistoryService.getUsersHistoryListBySearch(keyword, actionTypes, beforeDate, afterDate);
        }
        catch (Exception e) {
            log.error("getUserHistoryBySearch", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok((Object)gson.toJson(userHistoryList)).build();
    }

    @GET
    @Path(value="/userhistory/export/csv")
    public Response exportUserHistory(@QueryParam(value="keyword") String keyword, @QueryParam(value="actionTypes") List<String> actionTypes, @QueryParam(value="beforeDate") String beforeDate, @QueryParam(value="afterDate") String afterDate) {
        try {
            List<UserHistory> userHistoryList = this.userHistoryService.getUsersHistoryListBySearch(keyword, actionTypes, beforeDate, afterDate);
            String filename = this.userHistoryService.createUserHistoryCsvFileName();
            byte[] csvBytes = this.userHistoryService.writeEntitiesToCsv(userHistoryList);
            return Response.ok((Object)csvBytes, (String)"text/plain").header("Content-Disposition", (Object)("attachment; filename=" + filename)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }
}

