/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.rest;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.luffy.entity.NtfTrgLog;
import kr.osci.luffy.entity.SysHistory;
import kr.osci.luffy.entity.SysHistoryEntity;
import kr.osci.luffy.services.SystemHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/systemHistory")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Named(value="SysHistoryResource")
public class SystemHistoryResource
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SystemHistoryResource.class);
    private static final long serialVersionUID = 4123275969789078194L;
    private static final Gson gson = new Gson();
    private SystemHistoryService systemHistoryService;

    @Inject
    public SystemHistoryResource(SystemHistoryService systemHistoryService) {
        this.systemHistoryService = systemHistoryService;
    }

    @GET
    @Path(value="")
    public Response getAllSystemHistory() {
        List<Object> systemHistoryList = new ArrayList();
        try {
            SysHistoryEntity[] systemHistoryEntities = this.systemHistoryService.getSystemsHistoryList();
            systemHistoryList = this.systemHistoryService.convertToSystemHistory(systemHistoryEntities);
            return Response.ok((Object)gson.toJson(systemHistoryList)).build();
        }
        catch (Exception e) {
            log.error("getAllSystemHistory error :: ", (Object)e.getMessage());
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/search")
    public Response getSystemHistoryBySearch(@QueryParam(value="actionTypes") List<String> actionTypes, @QueryParam(value="beforeDate") String beforeDate, @QueryParam(value="afterDate") String afterDate) {
        List<Object> systemHistoryList = new ArrayList();
        try {
            SysHistoryEntity[] systemHistoryEntities = this.systemHistoryService.getSystemHistoryListBySearch(actionTypes, beforeDate, afterDate);
            systemHistoryList = this.systemHistoryService.convertToSystemHistory(systemHistoryEntities);
        }
        catch (Exception e) {
            log.error("getSystemHistoryBySearch error :: ", (Object)e.getMessage());
            return Response.serverError().build();
        }
        return Response.ok((Object)gson.toJson(systemHistoryList)).build();
    }

    @GET
    @Path(value="/notification/target")
    public Response getNtfTrgLog(@QueryParam(value="id") int ntfTrgLogId) {
        try {
            List<NtfTrgLog> ntfTrgLogs = this.systemHistoryService.getNtfTrgLog(ntfTrgLogId);
            return Response.ok((Object)gson.toJson(ntfTrgLogs)).build();
        }
        catch (Exception e) {
            log.error("getNtfTrgLog error :: ", (Object)e.getMessage());
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/export/csv")
    public Response exportSystemHistory(@QueryParam(value="actionTypes") List<String> actionTypes, @QueryParam(value="beforeDate") String beforeDate, @QueryParam(value="afterDate") String afterDate) {
        try {
            SysHistoryEntity[] systemHistoryEntities = this.systemHistoryService.getSystemHistoryListBySearch(actionTypes, beforeDate, afterDate);
            List<SysHistory> sysHistoryList = this.systemHistoryService.convertToSystemHistoryForExport(systemHistoryEntities);
            String filename = this.systemHistoryService.createSystemHistoryCsvFileName();
            byte[] csvBytes = this.systemHistoryService.writeEntitiesToCsv(sysHistoryList);
            return Response.ok((Object)csvBytes, (String)"text/plain").header("Content-Disposition", (Object)("attachment; filename=" + filename)).build();
        }
        catch (Exception e) {
            log.error("exportSystemHistory error :: ", (Object)e.getMessage());
            return Response.serverError().build();
        }
    }
}

