/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.entity.Noti;
import kr.osci.luffy.entity.NotiEntity;
import kr.osci.luffy.entity.NotiSetup;
import kr.osci.luffy.entity.NotiSetupEntity;
import kr.osci.luffy.services.ActivateObjectsService;
import kr.osci.luffy.services.SystemHistoryService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notification")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Named(value="NotificationResource")
public class NotificationResource {
    private static final Logger log = LoggerFactory.getLogger(NotificationResource.class);
    private static final Gson gson = new Gson();
    private final ActivateObjectsService activateObjectsService;
    private final SystemHistoryService systemHistoryService;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Inject
    public NotificationResource(ActivateObjectsService activateObjectsService, SystemHistoryService systemHistoryService, UserAccessor userAccessor) {
        this.activateObjectsService = activateObjectsService;
        this.systemHistoryService = systemHistoryService;
        this.userAccessor = userAccessor;
    }

    @POST
    @Path(value="/save/noti")
    public Response saveNoti(Noti noti) throws Exception {
        String validationCheck = this.activateObjectsService.validateNoti(noti);
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ArrayList<String> result = new ArrayList<String>();
        if (validationCheck.equals("canAdd")) {
            this.activateObjectsService.setNoti(noti);
            this.systemHistoryService.insertNotiTargetChangeLog(currentUser.getName(), "add", noti.getNotificationType(), noti.getNotificationTarget());
        } else if (validationCheck.equals("existed")) {
            result.add("existed");
        }
        return Response.ok(result).build();
    }

    @POST
    @Path(value="/save/notiSetup")
    public Response saveNotiSetup(NotiSetup notiSetup) throws Exception {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        NotiSetupEntity prevEntity = this.activateObjectsService.getNotiSetup();
        NotiSetupEntity entity = this.activateObjectsService.setNotiSetup(notiSetup);
        if (entity.getInUse()) {
            this.activateObjectsService.setUserCountJob(entity);
        }
        this.systemHistoryService.insertNotiScheduleChangeLog(currentUser.getName(), prevEntity, entity);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/save/notiSetup")
    public Response updateNotiSetup(NotiSetup notiSetup) throws Exception {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        NotiSetupEntity entity = this.activateObjectsService.updateNotiSetup(notiSetup);
        if (entity.getInUse()) {
            this.activateObjectsService.setUserCountJob(entity);
        }
        this.systemHistoryService.insertNotiSetupChangeLog(confluenceUser.getName(), entity.getInUse());
        return Response.ok().build();
    }

    @GET
    @Path(value="/run/job")
    public Response runJobNow() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        log.warn("sec.log Notification run job for test");
        try {
            NotiSetupEntity notiSetupEntity = this.activateObjectsService.getNotiSetup();
            NotiEntity[] notiEntities = this.activateObjectsService.getNotiEntity();
            int cntLicense = this.userAccessor.countLicenseConsumingUsers();
            try {
                if (notiSetupEntity.getInUse() && notiEntities.length > 0 && cntLicense >= notiSetupEntity.getNotiLimit()) {
                    this.activateObjectsService.overUsersSendEmail(notiSetupEntity.getNotiLimit());
                    result.put("result", true);
                    result.put("message", cntLicense);
                    return Response.ok(result).build();
                }
            }
            catch (Exception e) {
                log.warn("Notification runJob log\n" + e.getMessage());
            }
            result.put("result", false);
            result.put("message", cntLicense);
        }
        catch (Exception e) {
            result.put("result", false);
            result.put("message", e);
        }
        return Response.ok(result).build();
    }

    @POST
    @Path(value="/remove/noti")
    public Response removeNoti(Noti noti) throws Exception {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        NotiEntity[] entity = this.activateObjectsService.removeNotiTarget(noti.getNotificationTarget());
        ArrayList<String> result = new ArrayList<String>();
        if (entity.length == 0) {
            result.add("failed");
        } else {
            result.add("success");
            this.systemHistoryService.insertNotiTargetChangeLog(currentUser.getName(), "remove", noti.getNotificationType(), noti.getNotificationTarget());
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/get/list")
    public Response getNotificationList(@QueryParam(value="searchType") int searchType) throws Exception {
        NotiEntity[] entity = this.activateObjectsService.getNotiEntity(searchType);
        ArrayList<Noti> notiList = new ArrayList<Noti>();
        if (entity != null) {
            for (NotiEntity entities : entity) {
                notiList.add(NotiEntity.convert(entities));
            }
        }
        return Response.ok((Object)gson.toJson(notiList)).build();
    }

    @GET
    @Path(value="/get/notification")
    public Response getNotification() throws Exception {
        NotiEntity[] entity = this.activateObjectsService.getNotiEntity();
        ArrayList<Noti> notiList = new ArrayList<Noti>();
        if (entity != null) {
            for (NotiEntity entities : entity) {
                notiList.add(NotiEntity.convert(entities));
            }
        }
        boolean notiIsEmpty = notiList.isEmpty();
        return Response.ok((Object)gson.toJson(notiIsEmpty)).build();
    }

    @GET
    @Path(value="/get/notiSetup")
    public Response getNotiSetupAPI() {
        NotiSetupEntity entity = this.activateObjectsService.getNotiSetup();
        return Response.ok((Object)gson.toJson(NotiSetup.convert(entity))).build();
    }

    @POST
    @Path(value="/save/notification")
    public Response saveNotification(NotiSetup notiSetup) throws Exception {
        NotiSetupEntity entity = this.activateObjectsService.setNotiSetup(notiSetup);
        return Response.ok().build();
    }

    @GET
    @Path(value="/get/notificationSettings")
    public Response getNotificationSettings() {
        NotiSetupEntity nEntity = this.activateObjectsService.getNotiSetup();
        LicenseEntity lEntity = this.activateObjectsService.getLicense();
        ArrayList<Integer> trigger = new ArrayList<Integer>();
        trigger.add(nEntity.getNotiLimit());
        trigger.add(lEntity.getLastLogin());
        return Response.ok((Object)gson.toJson(trigger)).build();
    }

    @GET
    @Path(value="/search/email")
    public Response validateEmail(@QueryParam(value="email") String email) {
        email = email == null ? "" : email;
        ArrayList<String> result = new ArrayList<String>();
        NotiEntity[] entity = this.activateObjectsService.getNotiList(3);
        ArrayList<String> emailList = new ArrayList<String>();
        if (entity != null) {
            for (NotiEntity entities : entity) {
                emailList.add(entities.getNotificationTarget());
            }
        }
        for (String eList : emailList) {
            if (!Objects.equals(eList, email) && StringUtils.isWhitespace((String)email)) continue;
            result.add(eList);
        }
        if (result.isEmpty()) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/email/autocomplete")
    public Response emailAutocomplete(@QueryParam(value="email") String email) {
        email = email == null ? "" : email;
        ArrayList<String> result = new ArrayList<String>();
        NotiEntity[] entity = this.activateObjectsService.getNotiList(3);
        ArrayList<String> emailList = new ArrayList<String>();
        if (entity != null) {
            for (NotiEntity entities : entity) {
                emailList.add(entities.getNotificationTarget());
            }
        }
        for (String eList : emailList) {
            if ("".equals(email) || !eList.contains(email)) continue;
            result.add(eList);
        }
        if (result.isEmpty()) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/search/user")
    public Response validateUser(@QueryParam(value="userName") String userName) {
        userName = userName == null ? "" : userName;
        List users = this.userAccessor.getUserNamesWithConfluenceAccess();
        ArrayList<String> result = new ArrayList<String>();
        for (String user : users) {
            if (!"".equals(userName)) {
                if (!user.contains(userName)) continue;
                result.add(user);
                continue;
            }
            result.add("No Matches");
        }
        if (result.isEmpty()) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/UserCheck")
    public Response userCheck(@QueryParam(value="userName") String userName) throws Exception {
        userName = userName == null ? "" : userName;
        List users = this.userAccessor.getUserNamesWithConfluenceAccess();
        ArrayList<String> result = new ArrayList<String>();
        for (String user : users) {
            if (!"".equals(userName)) {
                if (!user.contains(userName)) continue;
                result.add(user);
                continue;
            }
            result.add("No Matches");
        }
        if (result.isEmpty()) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/username")
    public Response getUserName(@QueryParam(value="username") String userName) throws Exception {
        userName = userName == null ? "" : userName;
        Pager users = this.userAccessor.getUsers();
        ArrayList<String> result = new ArrayList<String>();
        for (User user : users) {
            if (!user.getName().contains(userName)) continue;
            result.add(user.getName());
        }
        if (result.isEmpty()) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }
}

