/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.rest;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.luffy.db.CommonDbAccessService;
import kr.osci.luffy.entity.Active;
import kr.osci.luffy.entity.ActiveEntity;
import kr.osci.luffy.entity.Exclude;
import kr.osci.luffy.entity.ExcludeEntity;
import kr.osci.luffy.entity.License;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.entity.ProgressInfo;
import kr.osci.luffy.entity.ProgressInfoEntity;
import kr.osci.luffy.entity.RestSSODto;
import kr.osci.luffy.entity.UserHistoryType;
import kr.osci.luffy.services.ActivateObjectsService;
import kr.osci.luffy.services.ProgressInfoService;
import kr.osci.luffy.services.SystemHistoryService;
import kr.osci.luffy.services.UserHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Path(value="/license")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Scanned
public class LicenseResource
implements Serializable {
    private static final long serialVersionUID = 6298959381285109923L;
    private static final Logger log = LoggerFactory.getLogger(LicenseResource.class);
    private static final Gson gson = new Gson();
    private final ActivateObjectsService activateObjectsService;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final SchedulerService schedulerService;
    @ComponentImport
    private final LocaleManager localeManager;
    @ComponentImport
    private final TransactionTemplate template;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final CommonDbAccessService commonDbAccessService;
    private final UserHistoryService userHistoryService;
    private final SystemHistoryService systemHistoryService;
    private final ProgressInfoService progressInfoService;
    @ComponentImport
    private final LicenseService licenseService;

    @Inject
    public LicenseResource(ActivateObjectsService activateObjectsService, UserAccessor userAccessor, BandanaManager bandanaManager, GroupManager groupManager, CrowdService crowdService, SchedulerService schedulerService, LocaleManager localeManager, TransactionTemplate template, PermissionManager permissionManager, CommonDbAccessService commonDbAccessService, UserHistoryService userHistoryService, SystemHistoryService systemHistoryService, ProgressInfoService progressInfoService, LicenseService licenseService) {
        this.activateObjectsService = activateObjectsService;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.bandanaManager = bandanaManager;
        this.crowdService = crowdService;
        this.schedulerService = schedulerService;
        this.localeManager = localeManager;
        this.template = template;
        this.permissionManager = permissionManager;
        this.commonDbAccessService = commonDbAccessService;
        this.userHistoryService = userHistoryService;
        this.systemHistoryService = systemHistoryService;
        this.progressInfoService = progressInfoService;
        this.licenseService = licenseService;
    }

    @GET
    public Response getLicense() throws EntityException {
        LicenseEntity entity = this.activateObjectsService.getLicense();
        return Response.ok((Object)gson.toJson(License.convert(entity))).build();
    }

    @PUT
    @Path(value="/control")
    public Response updateControl(final License license) throws Exception {
        LicenseEntity entity = (LicenseEntity)this.template.execute((TransactionCallback)new TransactionCallback<LicenseEntity>(){

            public LicenseEntity doInTransaction() {
                LicenseEntity entity = null;
                ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                try {
                    LicenseEntity prevEntity = LicenseResource.this.activateObjectsService.getLicense();
                    entity = LicenseResource.this.activateObjectsService.updateControl(license);
                    LicenseResource.this.systemHistoryService.createLicenseEntityLog(currentUser.getName(), prevEntity, entity);
                }
                catch (Exception e) {
                    return (LicenseEntity)Response.ok((Object)e.getMessage()).build();
                }
                return entity;
            }
        });
        return Response.ok((Object)gson.toJson(License.convert(entity))).build();
    }

    @GET
    @Path(value="/scheduler/check")
    public Response getAllScheduler() throws RuntimeException {
        HashMap<String, Object> allRegisteredJobs = this.activateObjectsService.getRegisteredScheduleJobs();
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        result.add(allRegisteredJobs);
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/test/days")
    public Response getRemoveUsersByLastLoginDays(@QueryParam(value="days") int days, @QueryParam(value="withuser") boolean withuser, @QueryParam(value="excludeNoLoginUsers") boolean excludeNoLoginUsers) throws Exception {
        String canuseGroup = this.activateObjectsService.getLicense().getTargetGroup();
        List<String> removeUserListInfo = this.commonDbAccessService.getRemoveUserListInfo(canuseGroup, days, excludeNoLoginUsers);
        int count = removeUserListInfo.size();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("count", count);
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/test/remove")
    public Response getRemoveUsersByCount(@QueryParam(value="count") int count, @QueryParam(value="withuser") boolean withuser) throws Exception {
        Stack<String> removeUserList = this.activateObjectsService.getRemoveUsersByCount(count, true);
        long now = System.currentTimeMillis();
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (removeUserList.size() == 0) {
            result.put("count", Integer.valueOf(0));
            result.put("earliest", Integer.valueOf(0));
            result.put("latest", Integer.valueOf(0));
        } else {
            long earliest = now - Long.valueOf(removeUserList.pop());
            long latest = now - Long.valueOf(removeUserList.pop());
            result.put("count", Integer.valueOf(removeUserList.size() - 2));
            result.put("earliest", Integer.valueOf((int)(earliest / 86400000L)));
            result.put("latest", Integer.valueOf((int)(latest / 86400000L)));
        }
        if (withuser) {
            result.put("users", removeUserList);
        }
        log.debug("/test/remove?count={} : [{}]", (Object)count, result);
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/test/reduce")
    public Response getRedeuceUsersByCount(@QueryParam(value="count") int count, @QueryParam(value="withuser") boolean withuser) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (count == 0) {
            result.put("count", 0);
            result.put("earliest", 0);
            result.put("latest", 0);
            return Response.ok(result).build();
        }
        long now = System.currentTimeMillis();
        Stack<String> userList = this.activateObjectsService.getRemoveUsersByCount(count, true);
        long earliest = now - Long.valueOf(userList.pop());
        long latest = now - Long.valueOf(userList.pop());
        String cnt = userList.pop();
        result.put("count", cnt);
        result.put("earliest", (int)(earliest / 86400000L));
        result.put("latest", (int)(latest / 86400000L));
        log.debug("/test/remove?count={} : [{}]", (Object)count, result);
        return Response.ok(result).build();
    }

    @DELETE
    @Path(value="/remove/days")
    public Response removeUsersByLastLoginDays(@QueryParam(value="days") int days) throws Exception {
        List<String> removeUserList = this.activateObjectsService.removeUsersByLastLogin(days, false);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("count", removeUserList.size());
        result.put("users", removeUserList);
        log.debug("/remove/days?days={} : [{}]", (Object)days, result);
        return Response.ok(result).build();
    }

    @DELETE
    @Path(value="/remove/count")
    public Response removeUsersByCount(@QueryParam(value="count") int count) throws Exception {
        Stack<String> removeUserList = this.activateObjectsService.getRemoveUsersByCount(count, false);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("count", Integer.valueOf(removeUserList.size()));
        result.put("users", removeUserList);
        log.debug("/remove/count?count={} : [{}]", (Object)count, result);
        return Response.ok(result).build();
    }

    @DELETE
    @Path(value="/reduce/count")
    public Response reduceUsersByCount(@QueryParam(value="count") double count) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        LicenseEntity entity = this.activateObjectsService.getLicense();
        String canuseGroup = entity.getTargetGroup();
        List canuseUsers = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(canuseGroup));
        if ((double)canuseUsers.size() < count) {
            result.put("resultCode", "99");
            result.put("resultMsg", "exceed");
            return Response.ok(result).build();
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ProgressInfo progressInfo = new ProgressInfo();
        progressInfo.setCreatorKey(String.valueOf(currentUser.getKey()));
        progressInfo.setCreator(currentUser.getName());
        ProgressInfoEntity progressInfoEntity = this.activateObjectsService.createProgressInfo(progressInfo);
        progressInfo.setID(progressInfoEntity.getID());
        return Response.ok((Object)gson.toJson(progressInfo)).build();
    }

    @DELETE
    @Path(value="/reduce/count/run")
    public Response reduceUsers(@QueryParam(value="count") double count, @QueryParam(value="exclude") boolean exclude, @QueryParam(value="id") int id) throws Exception {
        this.activateObjectsService.reduceUsersByCountModify(count, exclude, id);
        return Response.ok((Object)gson.toJson("progress...")).build();
    }

    @GET
    @Path(value="/reduce/count/check")
    public Response reduceUsersCountCheck(@QueryParam(value="count") double count) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        LicenseEntity entity = this.activateObjectsService.getLicense();
        String canuseGroup = entity.getTargetGroup();
        List canuseUsers = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(canuseGroup));
        if ((double)canuseUsers.size() < count) {
            result.put("resultCode", "99");
            result.put("resultMsg", "exceed");
            return Response.ok(result).build();
        }
        result.put("resultCode", "00");
        result.put("resultMsg", "success");
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/sys/date")
    public Response getSysDate() throws Exception {
        Date date = new Date();
        return Response.ok((Object)date.toString()).build();
    }

    @GET
    @Path(value="/run/job")
    public Response runJobNow() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        log.warn("sec.log removeUsersBySchedule");
        try {
            List<String> removeUserList = this.activateObjectsService.removeUsersBySchedule();
            result.put("result", true);
            result.put("message", removeUserList.size() + " user(s) removed in target group.");
        }
        catch (Exception e) {
            result.put("result", false);
            result.put("message", e);
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/user/group")
    public Response getUserGroup(@QueryParam(value="username") String userName) {
        if (userName == null || userName == "") {
            return Response.ok((Object)"userName is null").build();
        }
        ArrayList<Boolean> result = this.activateObjectsService.getUserGroup(userName);
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        result.add((Boolean)((Object)user.getFullName()));
        result.add((Boolean)((Object)user.getName()));
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/target/group")
    public Response getTargetGroup() {
        String group = this.activateObjectsService.getTargetGroup();
        return Response.ok((Object)gson.toJson(group)).build();
    }

    @GET
    @Path(value="/user/login/test")
    public String userLoginTest(@QueryParam(value="username") String userName, @QueryParam(value="actionType") String actionType) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        String strGroup = this.activateObjectsService.getTargetGroup();
        Group targetGroup = null;
        try {
            targetGroup = this.groupManager.getGroup(strGroup);
        }
        catch (EntityException e1) {
            return e1.getMessage();
        }
        com.atlassian.crowd.embedded.api.User cUser = this.crowdService.getUser(userName);
        boolean isTarget = this.crowdService.isUserMemberOfGroup(cUser, this.crowdService.getGroup(strGroup));
        String msg = null;
        if (actionType.equals("out")) {
            if (isTarget) {
                try {
                    this.crowdService.removeUserFromGroup(cUser, this.crowdService.getGroup(strGroup));
                    this.groupManager.removeMembership(targetGroup, (User)this.userAccessor.getUserByName(userName));
                    this.activateObjectsService.refreshLicenseCnt();
                    this.userHistoryService.insertUserHistory(userName, UserHistoryType.REMOVE.getValue(), currentUser.getName());
                    return "remove user from canuse group";
                }
                catch (Exception e) {
                    log.error("userLoginTest error : ", (Throwable)e);
                    msg = "\uc77d\uae30/\uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                    return msg;
                }
            }
            return "remove user from canuse group";
        }
        if (actionType.equals("add")) {
            try {
                this.groupManager.addMembership(targetGroup, (User)this.userAccessor.getUserByName(userName));
                this.activateObjectsService.refreshLicenseCnt();
                this.userHistoryService.insertUserHistory(userName, UserHistoryType.ADD.getValue(), currentUser.getName());
                return "add user to canuse group";
            }
            catch (Exception e) {
                log.error("userLoginTest error : ", (Throwable)e);
                msg = "\uc77d\uae30/\uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                return msg;
            }
        }
        return "";
    }

    @POST
    @Path(value="/save/active-term")
    public Response saveActiveTerm(Active active) {
        this.activateObjectsService.saveActiveEntity(active);
        return Response.ok((Object)"ok").build();
    }

    @POST
    @Path(value="/save/excludeTarget")
    public Response saveExcludeTarget(Exclude exclude) throws Exception {
        String validationCheck = this.activateObjectsService.validateExcludeEntity(exclude);
        ArrayList<String> result = new ArrayList<String>();
        if (validationCheck.equals("canAdd")) {
            this.activateObjectsService.setExcludeEntity(exclude);
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            this.systemHistoryService.insertExcludeTargetChangeLog(currentUser.getName(), "add", exclude.getExcludeTargetType(), exclude.getExcludeTarget());
        } else if (validationCheck.equals("existed")) {
            result.add("existed");
        }
        return Response.ok(result).build();
    }

    @POST
    @Path(value="/remove/excludeTarget")
    public Response removeExcludeTargte(Exclude exclude) throws Exception {
        ExcludeEntity[] entity = this.activateObjectsService.removeExcludeEntity(exclude.getExcludeTarget());
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ArrayList<String> result = new ArrayList<String>();
        if (entity.length == 0) {
            result.add("failed");
        } else {
            result.add("success");
            this.systemHistoryService.insertExcludeTargetChangeLog(currentUser.getName(), "remove", exclude.getExcludeTargetType(), exclude.getExcludeTarget());
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/get/excludeTarget/list")
    public Response getExcludeTargetList(@QueryParam(value="searchType") int searchType) throws Exception {
        ExcludeEntity[] entity = this.activateObjectsService.getExcludeEntityList(searchType);
        ArrayList<Exclude> excludeList = new ArrayList<Exclude>();
        if (entity != null) {
            for (ExcludeEntity entities : entity) {
                excludeList.add(ExcludeEntity.convert(entities));
            }
        }
        return Response.ok((Object)gson.toJson(excludeList)).build();
    }

    @GET
    @Path(value="/get/active-term")
    public Response getActiveTerm() {
        ActiveEntity entity = this.activateObjectsService.getActiveEntity();
        Active active = new Active();
        if (entity != null) {
            active.setActiveUserTerm(this.nullToString(entity.getActiveUserTerm()));
            active.setActiveUserCnt(this.nullToString(entity.getActiveUserCnt()));
            active.setActiveTerm(entity.getActiveTerm() == null ? false : entity.getActiveTerm());
        }
        return Response.ok((Object)gson.toJson(active)).build();
    }

    @GET
    @Path(value="/get/getLanguage")
    public Response getLanguage() throws Exception {
        Locale locale = this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        String language = locale.getLanguage();
        return Response.ok((Object)language.toString()).build();
    }

    @GET
    @Path(value="/GroupCheck")
    public Response GroupCheck(@QueryParam(value="groupName") String groupName) throws Exception {
        groupName = groupName == null ? "" : groupName;
        ArrayList<String> result = new ArrayList<String>();
        Pager groups = this.groupManager.getGroups();
        for (Group group : groups) {
            String gName = group.getName();
            if (!"".equals(groupName)) {
                if (!gName.matches(groupName)) continue;
                result.add(gName);
                continue;
            }
            result.add("No Matches");
        }
        if (result.size() == 0) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }

    public String nullToString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    @GET
    @Path(value="/reduce/progress")
    public Response getProgress() throws Exception {
        ProgressInfo progressInfo = this.progressInfoService.getProgressInfoByStatus("PROCESSING");
        if (ObjectUtils.isEmpty((Object)progressInfo)) {
            progressInfo = this.progressInfoService.getProgressInfoByStatus("COMPLETE");
        }
        return Response.ok((Object)gson.toJson(progressInfo)).build();
    }

    @GET
    @Path(value="/reduce/progress/{id}")
    public Response getProgressById(@PathParam(value="id") int id) throws Exception {
        ProgressInfo progressInfo = this.progressInfoService.getProgressInfoById(id);
        return Response.ok((Object)gson.toJson(progressInfo)).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="/healthCheck")
    public Response addonHealthCheck() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", 200);
        result.put("description", "Flexible User License is Running");
        return Response.ok(result).build();
    }

    @POST
    @AnonymousAllowed
    @Path(value="/assign")
    public Response addUserToLicenseGroup(@QueryParam(value="userId") String userId) {
        log.debug("=== assign : {}", (Object)userId);
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            ConfluenceUser appUser = this.userAccessor.getUserByName(userId);
            com.atlassian.crowd.embedded.api.User cUser = this.crowdService.getUser(userId);
            if (appUser == null) {
                result.put("description", "Not Found User");
                result.put("name", userId);
                return Response.status((int)404).entity(result).build();
            }
            if (!this.activateObjectsService.isUserInSourceGroup(cUser)) {
                result.put("description", "Not Permission User");
                result.put("name", userId);
                return Response.status((int)400).entity(result).build();
            }
            if (this.activateObjectsService.isUserInTargetGroup(userId)) {
                result.put("description", "This User Already in License Group");
                result.put("name", userId);
                return Response.ok(result).build();
            }
            Group targetGroup = this.groupManager.getGroup(this.activateObjectsService.getTargetGroup());
            this.groupManager.addMembership(targetGroup, (User)this.userAccessor.getUserByName(userId));
            this.userHistoryService.insertUserHistory(cUser.getName(), UserHistoryType.AUTO_ADD.getValue(), "SYSTEM");
            this.keepingLicense(targetGroup.getName(), userId);
            log.debug("=== assign end === ");
            result.put("description", "Success Add to Group");
            result.put("name", userId);
            return Response.ok(result).build();
        }
        catch (Exception e) {
            log.info("\n sec.log.error -> " + e.getMessage() + "\n");
            return Response.status((int)500).build();
        }
    }

    @POST
    @AnonymousAllowed
    @Path(value="/assign-reactivate")
    public Response addUserToLicenseGroupAndReactivate(RestSSODto restSSODto) throws Exception {
        log.debug("=== assign-reactivate");
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (StringUtils.isEmpty((Object)restSSODto.getUserId())) {
                result.put("description", "User Id is a required");
                return Response.status((int)400).entity(result).build();
            }
            String userId = restSSODto.getUserId();
            boolean isReactive = restSSODto.getReactivate();
            log.debug("=== assign-reactivate userId : {}", (Object)userId);
            ConfluenceUser appUser = this.userAccessor.getUserByName(userId);
            com.atlassian.crowd.embedded.api.User cUser = this.crowdService.getUser(userId);
            if (appUser == null) {
                result.put("description", "Not Found User");
                result.put("name", userId);
                return Response.status((int)404).entity(result).build();
            }
            log.debug("=== assign-reactivate appUser null \uccb4\ud06c ");
            if (!this.activateObjectsService.isUserInSourceGroup(cUser)) {
                result.put("description", "Not Permission User");
                result.put("name", userId);
                return Response.status((int)400).entity(result).build();
            }
            log.debug("=== assign-reactivate user group \uccb4\ud06c ");
            if (isReactive) {
                if (StringUtils.isEmpty((Object)restSSODto.getAdminId())) {
                    result.put("description", "Admin Id is a required when reactivate user");
                    return Response.status((int)400).entity(result).build();
                }
                ConfluenceUser adminAppUser = this.userAccessor.getUserByName(restSSODto.getAdminId());
                if (!this.permissionManager.isConfluenceAdministrator((User)adminAppUser)) {
                    result.put("description", "There is no administrator permission.");
                    result.put("name", restSSODto.getAdminId());
                    return Response.status((int)401).entity(result).build();
                }
                log.debug("=== assign-reactivate \uad00\ub9ac\uc790 \uad8c\ud55c \uccb4\ud06c ");
                AuthenticatedUserThreadLocal.set((ConfluenceUser)adminAppUser);
                this.userAccessor.reactivateUser((User)appUser);
                AuthenticatedUserThreadLocal.reset();
            }
            log.debug("=== assign-reactivate reactive \uccb4\ud06c ");
            if (this.activateObjectsService.isUserInTargetGroup(userId)) {
                result.put("description", "This User Already in License Group");
                result.put("name", userId);
                return Response.ok(result).build();
            }
            log.debug("=== assign-reactivate \ub77c\uc774\uc120\uc2a4 \uadf8\ub8f9 \uccb4\ud06c ");
            Group targetGroup = this.groupManager.getGroup(this.activateObjectsService.getTargetGroup());
            this.groupManager.addMembership(targetGroup, (User)this.userAccessor.getUserByName(userId));
            this.userHistoryService.insertUserHistory(cUser.getName(), UserHistoryType.AUTO_ADD.getValue(), "SYSTEM");
            this.keepingLicense(targetGroup.getName(), userId);
            log.debug("=== assign-reactivate end === ");
            result.put("description", "Success Add to Group");
            result.put("name", userId);
            return Response.ok(result).build();
        }
        catch (Exception e) {
            log.error("\n sec.log.error -> " + e.getMessage() + "\n");
            return Response.status((int)500).build();
        }
    }

    private void keepingLicense(String licenseGroupName, String loginUser) {
        log.debug("keepingLicense by api call : {}", (Object)loginUser);
        LicenseEntity licenseEntity = (LicenseEntity)this.template.execute(this.activateObjectsService::getLicense);
        String licenseGroup = licenseEntity.getTargetGroup();
        log.debug("api call groupName : {}", (Object)licenseGroupName);
        if (licenseGroupName.equals(licenseGroup)) {
            log.debug("api call getIsKeepingLicense : {}", (Object)licenseEntity.getIsKeepingLicense());
            log.warn("api call getLicenseKeepingCount : {}", (Object)licenseEntity.getLicenseKeepingCount());
            if (licenseEntity.getIsKeepingLicense()) {
                ConfluenceLicense cl = this.licenseService.retrieve();
                int licenseTier = cl.getMaximumNumberOfUsers();
                int cntLicense = this.userAccessor.countLicenseConsumingUsers();
                int limit = 0;
                log.warn("api call cntLicense : {}", (Object)cntLicense);
                if (licenseEntity.getLicenseKeepingCount() > 0) {
                    if (cntLicense >= licenseEntity.getLicenseKeepingCount()) {
                        limit = cntLicense - licenseEntity.getLicenseKeepingCount() + 1;
                        log.warn("api call set number exceed : {}", (Object)limit);
                        this.removeLicenseGroupUser(licenseGroup, limit, licenseEntity, loginUser);
                    } else if (cntLicense >= licenseTier && licenseTier > 0) {
                        limit = cntLicense - licenseTier + 1;
                        log.warn("api call tier exceed : {}", (Object)limit);
                        this.removeLicenseGroupUser(licenseGroup, limit, licenseEntity, loginUser);
                    }
                } else if (licenseEntity.getLicenseKeepingCount() == 0 && licenseTier > 0) {
                    limit = cntLicense - licenseTier + 1;
                    log.warn("api call default tier exceed : {}", (Object)limit);
                    if (limit > 0) {
                        this.removeLicenseGroupUser(licenseGroup, limit, licenseEntity, loginUser);
                    }
                }
            }
            this.activateObjectsService.refreshLicenseCnt();
        }
    }

    private void removeLicenseGroupUser(String licenseGroup, int limit, LicenseEntity licenseEntity, String loginUser) {
        List<Map<String, Object>> results = this.commonDbAccessService.getLastLoginInfoList(licenseEntity.getIsNotLoginInLicense(), licenseGroup);
        Stack<String> removeUserList = new Stack<String>();
        ArrayList<String> canuseUsers = new ArrayList<String>();
        for (Map<String, Object> row : results) {
            Object userName;
            if (!row.containsKey("user_name") || !((userName = row.get("user_name")) instanceof String) || userName.equals(loginUser)) continue;
            canuseUsers.add((String)userName);
        }
        List<String> filteredCanUseUsers = this.activateObjectsService.filterRemoveUsersByExcludeEntity(canuseUsers);
        removeUserList.addAll(filteredCanUseUsers.subList(0, Math.min(limit, filteredCanUseUsers.size())));
        try {
            this.activateObjectsService.removeUserFromGroup(removeUserList, licenseGroup);
            this.systemHistoryService.insertExecuteMaintainLicenseCountsLog(removeUserList.size());
            log.warn("api call removeUserList.size() : {}", (Object)removeUserList.size());
        }
        catch (Exception e) {
            log.error("AutoLoginService.removeLicenseGroupUser : ", (Throwable)e);
        }
    }
}

