/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.rest;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.Credential;
import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.luffy.db.CommonDbAccessService;
import kr.osci.luffy.entity.GroupList;
import kr.osci.luffy.entity.License;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.entity.MoveGroup;
import kr.osci.luffy.services.ActivateObjectsService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/groups")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Named(value="GroupResource")
public class GroupResource
implements Serializable {
    private static final long serialVersionUID = 4123275969789078194L;
    private static final Logger log = LoggerFactory.getLogger(GroupResource.class);
    private static final Gson gson = new Gson();
    private final ActivateObjectsService activateObjectsService;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final I18nResolver i18n;
    private final CommonDbAccessService commonDbAccessService;

    @Inject
    public GroupResource(ActivateObjectsService activateObjectsService, GroupManager groupManager, UserAccessor userAccessor, BandanaManager bandanaManager, I18nResolver i18n, CommonDbAccessService commonDbAccessService) {
        this.activateObjectsService = activateObjectsService;
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
        this.bandanaManager = bandanaManager;
        this.i18n = i18n;
        this.commonDbAccessService = commonDbAccessService;
    }

    @GET
    @Path(value="/search")
    public Response getGroupList(@QueryParam(value="search") String search) throws Exception {
        search = search == null ? "" : search;
        ArrayList<String> result = new ArrayList<String>();
        Pager groups = this.groupManager.getGroups();
        for (Group group : groups) {
            String groupName = group.getName();
            if (!"".equals(search)) {
                if (!groupName.contains(search)) continue;
                result.add(groupName);
                continue;
            }
            result.add(groupName);
        }
        if (result.size() == 0) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/search/username")
    public Response validateUser(@QueryParam(value="username") String username) throws Exception {
        username = username == null ? "" : username;
        ArrayList<String> result = new ArrayList<String>();
        LicenseEntity entity = this.activateObjectsService.getLicense();
        String sourceGroup = entity.getSourceGroup();
        String tagetGroup = entity.getTargetGroup();
        List userList = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(sourceGroup));
        List tagetList = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(tagetGroup));
        userList.addAll(tagetList);
        for (String user : userList) {
            if (!"".equals(username)) {
                if (!user.matches(username + "(.*)")) continue;
                result.add(user);
                continue;
            }
            result.add(user);
        }
        if (result.size() == 0) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/stat/source")
    public Response getSourceStat() {
        log.debug("count::::::::::::::: Start :::::::::::::::::");
        LicenseEntity entity = this.activateObjectsService.getLicense();
        String sourceGroup = entity.getSourceGroup();
        int sourceCnt = 0;
        long start = System.currentTimeMillis();
        sourceCnt = this.getSourceCnt(sourceGroup);
        long end = System.currentTimeMillis();
        log.info("## Run time(/stat/source) : " + (double)(end - start) / 1000.0);
        String day = new SimpleDateFormat("yyyy.MM.dd HH:mm").format(new Date());
        entity.setCountSourceGroup(sourceCnt);
        entity.setCountSourceDate(day);
        entity.save();
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        sourceMap.put("name", sourceGroup);
        sourceMap.put("count", sourceCnt);
        sourceMap.put("day", day);
        return Response.ok(sourceMap).build();
    }

    private int getSourceCnt(String sourceGroup) {
        log.warn("getSourceCnt::::::::::::::: call  :::::::::::::::::");
        log.warn("sourceGroup::::::::::::::: call  :::::::::::::::::" + sourceGroup);
        int sourceCnt = 0;
        if (sourceGroup != null && !"".equals(sourceGroup)) {
            try {
                sourceCnt = this.commonDbAccessService.getGroupUserCount(sourceGroup);
            }
            catch (Exception e) {
                log.warn("getSourceCnt::::::::::::::: call  :::::::::::::::::");
                e.getMessage();
            }
        }
        log.warn("sucess ::::::::;");
        log.warn("sourceCnt ::::::::" + sourceCnt);
        return sourceCnt;
    }

    @GET
    @Path(value="/stat/canuse")
    public Response getCanuseStat() {
        log.debug("getCanuseStat start ::::::::::::::::::::");
        LicenseEntity entity = this.activateObjectsService.getLicense();
        log.debug("entity ::::::::::::::::::::" + entity);
        String targetGroup = entity.getTargetGroup();
        long start = System.currentTimeMillis();
        int targetCnt = this.getSourceCnt(targetGroup);
        long end = System.currentTimeMillis();
        log.info("## Run time(/stat/canuse) : " + (double)(end - start) / 1000.0);
        String day = new SimpleDateFormat("yyyy.MM.dd HH:mm").format(new Date());
        entity.setCountCanuseGroup(targetCnt);
        entity.setCountCanuseDate(day);
        entity.save();
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        sourceMap.put("name", targetGroup);
        sourceMap.put("count", targetCnt);
        sourceMap.put("day", day);
        return Response.ok(sourceMap).build();
    }

    @POST
    @Path(value="/target")
    public Response setTargetGroup(String group) {
        if (StringUtils.isEmpty((String)group)) {
            throw new IllegalArgumentException("group must not be null.");
        }
        this.activateObjectsService.setTargetGroup(group);
        return Response.ok((Object)group).build();
    }

    @POST
    @Path(value="/source")
    public Response setSourceGroup(String group) {
        if (StringUtils.isEmpty((String)group)) {
            throw new IllegalArgumentException("group must not be null.");
        }
        this.activateObjectsService.setSourceGroup(group);
        return Response.ok((Object)group).build();
    }

    @GET
    @Path(value="/make/sample")
    public String MakeSample() {
        for (int i = 0; i < 32000; ++i) {
            try {
                String s = String.format("%03d", i);
                String name = "user" + s;
                ConfluenceUserImpl u = new ConfluenceUserImpl(name, name, name + "@test.com");
                this.userAccessor.createUser((User)u, Credential.unencrypted((String)"1234"));
                log.warn("\n " + name);
                Thread.sleep(400L);
                continue;
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
        }
        return null;
    }

    @GET
    @Path(value="/move/sample")
    public String removeUsers() throws InterruptedException {
        for (int i = 0; i < 32000; ++i) {
            String s = String.format("%03d", i);
            String name = "user" + s;
            try {
                Thread.sleep(100L);
                this.groupManager.addMembership(this.groupManager.getGroup("active"), (User)this.userAccessor.getUserByName(name));
                if (i % 50 != 0) continue;
                log.warn("count user move " + i + " name");
                continue;
            }
            catch (EntityException | IllegalArgumentException e) {
                log.error(e.getMessage());
            }
        }
        return null;
    }

    @GET
    @Path(value="/move/user")
    public String moveUser(@QueryParam(value="userName") String userName) {
        try {
            this.groupManager.addMembership(this.groupManager.getGroup("active"), (User)this.userAccessor.getUserByName(userName));
        }
        catch (EntityException e) {
            return e.getMessage();
        }
        return "Done";
    }

    @PUT
    @Path(value="/setGroupMapping")
    public Response setGroupMapping(License license) throws Exception {
        Object entity = null;
        if (StringUtils.isEmpty((String)String.valueOf(license))) {
            throw new IllegalArgumentException("group must not be null.");
        }
        ConfluenceUser adminUser = AuthenticatedUserThreadLocal.get();
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "kr.osci.luffy.entity.admin.user", (Object)adminUser.getName());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (!license.getSourceGroup().equals("")) {
                ArrayList resultSource = new ArrayList();
                Response resSource = this.groupMatchCheck(license.getSourceGroup());
                resultSource = (ArrayList)resSource.getEntity();
                if (!((String)resultSource.get(0)).equals("No Matches")) {
                    this.activateObjectsService.setSourceGroup(license.getSourceGroup());
                    map.put("souceGroup", "00");
                } else {
                    map.put("souceGroup", "99");
                }
            }
            if (!license.getTargetGroup().equals("")) {
                ArrayList resultTarget = new ArrayList();
                Response resTarget = this.groupMatchCheck(license.getTargetGroup());
                resultTarget = (ArrayList)resTarget.getEntity();
                if (!((String)resultTarget.get(0)).equals("No Matches")) {
                    this.activateObjectsService.setTargetGroup(license.getTargetGroup());
                    map.put("targetGroup", "00");
                } else {
                    map.put("targetGroup", "99");
                }
            }
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred whild update setGroupMapping.", (Throwable)e);
            throw e;
        }
        return Response.ok(map).build();
    }

    @GET
    @Path(value="/checkGroupMatch")
    public Response groupMatchCheck(@QueryParam(value="search") String search) throws Exception {
        search = search == null ? "" : search;
        ArrayList<String> result = new ArrayList<String>();
        Pager groups = this.groupManager.getGroups();
        for (Group group : groups) {
            String groupName = group.getName();
            if (!Objects.equals(groupName, search)) continue;
            result.add(groupName);
            break;
        }
        if (result.size() == 0) {
            result.add("No Matches");
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/source")
    public Response getUserGroupSource() throws Exception {
        List<Map<String, Object>> results = this.commonDbAccessService.getGroupMappingList();
        return Response.ok(results).build();
    }

    @POST
    @Path(value="/save")
    public Response setUserGroups(GroupList groupList) throws Exception {
        if (StringUtils.isEmpty((String)String.valueOf(groupList))) {
            throw new IllegalArgumentException("group must not be null.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (!groupList.getUserGroupName().equals("")) {
                ArrayList resultSource = new ArrayList();
                Response resSource = this.groupMatchCheck(groupList.getUserGroupName());
                resultSource = (ArrayList)resSource.getEntity();
                if (!((String)resultSource.get(0)).equals("No Matches")) {
                    boolean rst = this.activateObjectsService.checkAddGroupList(groupList.getUserGroupName());
                    if (rst) {
                        this.activateObjectsService.setGroupListUserGroupName(groupList.getUserGroupName());
                        map.put("souceGroup", "00");
                    } else {
                        map.put("souceGroup", "99");
                    }
                } else {
                    map.put("souceGroup", "99");
                }
            }
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred whild update save user groups.", (Throwable)e);
            throw e;
        }
        return Response.ok(map).build();
    }

    @POST
    @Path(value="/del")
    public Response delUserGroup(GroupList groupList) throws Exception {
        if (StringUtils.isEmpty((String)String.valueOf(groupList))) {
            throw new IllegalArgumentException("group must not be null.");
        }
        try {
            ConfluenceUser adminUser = AuthenticatedUserThreadLocal.get();
            this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "kr.osci.luffy.entity.admin.user", (Object)adminUser.getName());
            if (!groupList.getUserGroupName().equals("")) {
                this.activateObjectsService.delGroupList(groupList.getUserGroupName());
            }
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred whild update save user groups.", (Throwable)e);
            throw e;
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/group")
    public Response createGroup(String groupName) {
        try {
            if (groupName == null || groupName == "") {
                return Response.ok((Object)"groupName is null").build();
            }
            Group createdGroup = this.activateObjectsService.createGroup(groupName);
            return Response.ok((Object)gson.toJson(createdGroup)).build();
        }
        catch (Exception e) {
            return Response.status((int)400).build();
        }
    }

    @GET
    @Path(value="/group/member/count")
    public Response getGroupMemberCount(@QueryParam(value="groupName") String groupNameParam) {
        try {
            ArrayList result = new ArrayList();
            String groupName = URLDecoder.decode(groupNameParam, "UTF-8");
            int groupSize = 0;
            Group searchGroup = this.userAccessor.getGroup(groupName);
            if (ObjectUtils.isEmpty((Object)searchGroup)) {
                return Response.status((int)400).build();
            }
            List groupMemberNames = this.userAccessor.getMemberNamesAsList(searchGroup);
            groupSize = groupMemberNames.size();
            HashMap<String, String> group = new HashMap<String, String>();
            group.put("group", groupName);
            group.put("size", String.valueOf(groupSize));
            result.add(group);
            return Response.ok(result).build();
        }
        catch (Exception e) {
            return Response.status((int)400).build();
        }
    }

    @POST
    @Path(value="/move/group")
    public Response moveGroupToGroup(MoveGroup moveGroup) {
        try {
            List<String> sourceGroupList = moveGroup.getSourceGroup();
            String destiGroupName = moveGroup.getDestiGroup();
            if (sourceGroupList.size() == 0 || destiGroupName == null || destiGroupName == "") {
                return Response.status((int)400).build();
            }
            Set<String> result = this.activateObjectsService.moveUsersGroupToGroup(sourceGroupList, destiGroupName);
            return Response.ok(result).build();
        }
        catch (Exception e) {
            log.debug("Flexible User License Move Group API Exception", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

