/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.rest;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.GroupManager;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kr.osci.luffy.db.CommonDbAccessService;
import kr.osci.luffy.entity.FlexResult;
import kr.osci.luffy.entity.License;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.entity.NotiEntity;
import kr.osci.luffy.entity.NotiSetupEntity;
import kr.osci.luffy.rest.GroupResource;
import kr.osci.luffy.services.ActivateObjectsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/dashboard")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Scanned
public class DashBoardResource
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DashBoardResource.class);
    private static final long serialVersionUID = 2L;
    private static final Gson gson = new Gson();
    @ComponentImport
    private final LicenseService licenseService;
    @ComponentImport
    private final UserChecker userChecker;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final GroupManager groupManager;
    private final ActivateObjectsService activateObjectsService;
    private final GroupResource groupResource;
    private final CommonDbAccessService commonDbAccessService;

    @Inject
    public DashBoardResource(LicenseService licenseService, UserChecker userChecker, UserAccessor userAccessor, GroupManager groupManager, ActivateObjectsService activateObjectsService, GroupResource groupResource, CommonDbAccessService commonDbAccessService) {
        this.licenseService = licenseService;
        this.userChecker = userChecker;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.activateObjectsService = activateObjectsService;
        this.groupResource = groupResource;
        this.commonDbAccessService = commonDbAccessService;
    }

    @GET
    @Path(value="/get/licenseLimit")
    public Response getLicenseLimitInfo() {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        FlexResult result = new FlexResult();
        try {
            ConfluenceLicense cl = this.licenseService.retrieve();
            int limit = cl.getMaximumNumberOfUsers();
            int cntLicense = this.userAccessor.countLicenseConsumingUsers();
            hm.put("countLicense", cntLicense);
            hm.put("maximumNumberOfUsers", limit);
            result.setResultData(hm);
            result.setResultMsg("SUCESS");
        }
        catch (Exception e) {
            log.warn("getLicenseLimit error");
            e.getMessage();
            result.setResultCode(400);
            result.setResultMsg(e.getMessage());
        }
        return Response.ok((Object)gson.toJson(result)).build();
    }

    @GET
    @Path(value="/get/registeredUsers")
    public Response getRegisteredUsersInfo() {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        FlexResult result = new FlexResult();
        try {
            int cntLicense = this.userAccessor.countLicenseConsumingUsers();
            int registeUsers = this.commonDbAccessService.getTotalUserCount();
            hm.put("countLicense", cntLicense);
            hm.put("countRegisterUsers", registeUsers);
            result.setResultData(hm);
            result.setResultMsg("SUCESS");
        }
        catch (Exception e) {
            log.warn("getRegisteredUsersInfo error");
            e.getMessage();
            result.setResultCode(400);
            result.setResultMsg(e.getMessage());
        }
        return Response.ok((Object)gson.toJson(result)).build();
    }

    @GET
    @Path(value="/get/groupMapping")
    public Response getViewGroupMappingInfo() {
        LicenseEntity entity = this.activateObjectsService.getLicense();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        FlexResult result = new FlexResult();
        try {
            Response userGroup = this.groupResource.getSourceStat();
            Response LicenseGroup = this.groupResource.getCanuseStat();
            Map<String, Object> userGroupsMap = this.commonDbAccessService.getUserGroupsInfo();
            hm.put("userGroup", userGroup.getEntity());
            hm.put("userGroupsNames", userGroupsMap.get("userGroupsNames"));
            hm.put("userGroupsCount", userGroupsMap.get("userGroupsCount"));
            hm.put("licenseGroup", LicenseGroup.getEntity());
            hm.put("boardEntity", License.convert(entity));
            result.setResultData(hm);
            result.setResultMsg("SUCESS");
        }
        catch (Exception e) {
            log.warn("getGroupMappingInfo error");
            e.getMessage();
            result.setResultCode(400);
            result.setResultMsg(e.getMessage());
        }
        return Response.ok((Object)gson.toJson(result)).build();
    }

    @GET
    @Path(value="/get/scheduleSettings")
    public Response getViewRemoveLicensedGroupInfo() {
        LicenseEntity entity = this.activateObjectsService.getLicense();
        NotiSetupEntity notiSetupEntity = this.activateObjectsService.getNotiSetup();
        NotiEntity[] notiEntity = this.activateObjectsService.getNotiEntity();
        ArrayList<String> groupTarget = new ArrayList<String>();
        ArrayList<String> userTarget = new ArrayList<String>();
        ArrayList<String> otherEmailTarget = new ArrayList<String>();
        String notiGroupInfo = "";
        String notiUserInfo = "";
        String notiOtherEmailInfo = "";
        for (NotiEntity ne : notiEntity) {
            if (ne.getNotificationType() == 1) {
                groupTarget.add(ne.getNotificationTarget());
                continue;
            }
            if (ne.getNotificationType() == 2) {
                userTarget.add(ne.getNotificationTarget());
                continue;
            }
            if (ne.getNotificationType() != 3) continue;
            otherEmailTarget.add(ne.getNotificationTarget());
        }
        if (groupTarget.size() > 0) {
            notiGroupInfo = (String)groupTarget.get(0) + "_" + (groupTarget.size() - 1);
        }
        if (userTarget.size() > 0) {
            notiUserInfo = (String)userTarget.get(0) + "_" + (userTarget.size() - 1);
        }
        if (otherEmailTarget.size() > 0) {
            notiOtherEmailInfo = (String)otherEmailTarget.get(0) + "_" + (otherEmailTarget.size() - 1);
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        FlexResult result = new FlexResult();
        String canuseGroup = this.activateObjectsService.getLicense().getTargetGroup();
        try {
            List<String> removeUserListInfo = this.commonDbAccessService.getRemoveUserListInfo(canuseGroup, entity.getLastLogin(), entity.getIsNotLogin());
            int removeUsersCount = removeUserListInfo.size();
            Response LicenseGroup = this.groupResource.getCanuseStat();
            hm.put("boardEntity", License.convert(entity));
            hm.put("removeUsersCount", removeUsersCount);
            hm.put("licenseGroup", LicenseGroup.getEntity());
            hm.put("emailInuse", notiSetupEntity.getInUse());
            hm.put("emailScheduleHour", notiSetupEntity.getScheduleHour());
            hm.put("emailScheduleInterval", notiSetupEntity.getScheduleInterval());
            hm.put("emailNotiLimit", notiSetupEntity.getNotiLimit());
            hm.put("notiGroupInfo", notiGroupInfo);
            hm.put("notiUserInfo", notiUserInfo);
            hm.put("notiOtherEmailInfo", notiOtherEmailInfo);
            result.setResultData(hm);
            result.setResultMsg("SUCESS");
        }
        catch (Exception e) {
            log.warn("getScheduleSettingsInfo error");
            e.getMessage();
            result.setResultCode(400);
            result.setResultMsg(e.getMessage());
        }
        return Response.ok((Object)gson.toJson(result)).build();
    }
}

