/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.rest;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.HashMap;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kr.osci.luffy.entity.License;
import kr.osci.luffy.services.AutoLoginService;
import kr.osci.luffy.services.SystemHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/auto-login")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Named(value="AutoLoginResource")
public class AutoLoginResource
implements Serializable {
    private static final long serialVersionUID = 4123275969789078194L;
    private static final Logger log = LoggerFactory.getLogger(AutoLoginResource.class);
    private static final Gson gson = new Gson();
    @ComponentImport
    private final LicenseService licenseService;
    private final AutoLoginService autoLoginService;
    private final SystemHistoryService systemHistoryService;

    public AutoLoginResource(AutoLoginService autoLoginService, LicenseService licenseService, SystemHistoryService systemHistoryService) {
        this.autoLoginService = autoLoginService;
        this.licenseService = licenseService;
        this.systemHistoryService = systemHistoryService;
    }

    @PUT
    @Path(value="/")
    public Response updateAutoLoginStatus(License license) {
        try {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            this.autoLoginService.updateAutoLoginStatus(license);
            this.systemHistoryService.insertAutoLoginSetupInuseChangeLog(currentUser.getName(), license.getIsAutoLogin());
        }
        catch (Exception e) {
            log.error("updateAutoLoginStatus", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/keeping-license")
    public Response updateKeepingLicenseStatus(License license) {
        try {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            this.autoLoginService.updateKeepingLicenseStatus(license);
            this.systemHistoryService.insertMaintainSetupInuseChangeLog(currentUser.getName(), license.getIsKeepingLicense());
        }
        catch (Exception e) {
            log.error("updateKeepingLicenseStatus", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/config")
    public Response updateAutoLoginConfig(License license) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            this.autoLoginService.updateAutoLoginConfig(license);
            resultMap.put("resultCode", "00");
            resultMap.put("resultMsg", "success");
        }
        catch (Exception e) {
            log.error("updateAutoLoginConfig : {}", (Object)e.getMessage());
            resultMap.put("resultCode", "99");
            resultMap.put("resultMsg", e.getMessage());
        }
        return Response.ok((Object)gson.toJson(resultMap)).build();
    }

    @GET
    @Path(value="/license-count")
    public Response getMaximumNumberOfUsers() {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        try {
            ConfluenceLicense cl = this.licenseService.retrieve();
            int limit = cl.getMaximumNumberOfUsers();
            resultMap.put("limit", limit);
        }
        catch (Exception e) {
            log.error("getMaximumNumberOfUsers", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok(resultMap).build();
    }

    @PUT
    @Path(value="/keeping-license/config")
    public Response updateKeepingLicenseConfig(License license) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            this.autoLoginService.updateKeepingLicenseConfig(license);
            resultMap.put("resultCode", "00");
            resultMap.put("resultMsg", "success");
        }
        catch (Exception e) {
            log.error("updateAutoLoginConfig : {}", (Object)e.getMessage());
            resultMap.put("resultCode", "99");
            resultMap.put("resultMsg", e.getMessage());
        }
        return Response.ok((Object)gson.toJson(resultMap)).build();
    }
}

