/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.listeners;

import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.entity.GroupListEntity;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.entity.UserHistoryType;
import kr.osci.luffy.services.ActivateObjectsService;
import kr.osci.luffy.services.AutoLoginService;
import kr.osci.luffy.services.UserHistoryService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class AuthenticationEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationEventListener.class);
    private final ActivateObjectsService activateObjectsService;
    @ConfluenceImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final TransactionTemplate template;
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserAccessor userAcc;
    private final UserHistoryService userHistoryService;
    private final AutoLoginService autoLoginService;

    @Inject
    public AuthenticationEventListener(EventPublisher eventPublisher, ActivateObjectsService activateObjectsService, TransactionTemplate template, CrowdService crowdService, GroupManager groupManager, UserAccessor userAcc, UserHistoryService userHistoryService, AutoLoginService autoLoginService) {
        this.eventPublisher = eventPublisher;
        this.activateObjectsService = activateObjectsService;
        this.template = template;
        this.crowdService = crowdService;
        this.groupManager = groupManager;
        this.userAcc = userAcc;
        this.userHistoryService = userHistoryService;
        this.autoLoginService = autoLoginService;
    }

    @EventListener
    public void loginEventListener(LoginEvent event) {
        block9: {
            log.debug("===== loginEventListener start ===== {} ", (Object)event.getLoginSource());
            try {
                ConfluenceUser user = null;
                boolean isSource = false;
                User cUser = null;
                if (!StringUtils.isEmpty((CharSequence)event.getUsername())) {
                    log.debug("===== loginEventListener username ===== : {} ", (Object)event.getUsername());
                    cUser = this.crowdService.getUser(event.getUsername());
                    user = this.userAcc.getUserByName(event.getUsername());
                }
                LicenseEntity licenseEntity = (LicenseEntity)this.template.execute(this.activateObjectsService::getLicense);
                if (!licenseEntity.getIsAutoLogin().booleanValue()) {
                    return;
                }
                boolean isAdmin = this.crowdService.isUserMemberOfGroup(cUser, this.crowdService.getGroup("confluence-administrators"));
                log.debug("loginEventListener adminCheck : {} : {}", (Object)isAdmin, (Object)event.getUsername());
                GroupListEntity[] groupListEntities = (GroupListEntity[])this.template.execute(this.activateObjectsService::getGroupList);
                try {
                    GroupListEntity groupListEntity;
                    String sourceGroup;
                    boolean isTarget = this.crowdService.isUserMemberOfGroup(cUser, this.crowdService.getGroup(licenseEntity.getTargetGroup()));
                    if (isTarget) break block9;
                    GroupListEntity[] groupListEntityArray = groupListEntities;
                    int n = groupListEntityArray.length;
                    for (int i = 0; i < n && !(isSource = this.crowdService.isUserMemberOfGroup(cUser, this.crowdService.getGroup(sourceGroup = (groupListEntity = groupListEntityArray[i]).getUserGroupName()))); ++i) {
                    }
                    if (!isSource) break block9;
                    try {
                        this.groupManager.addMembership(this.groupManager.getGroup(licenseEntity.getTargetGroup()), (com.atlassian.user.User)user);
                        this.userHistoryService.insertUserHistory(cUser.getName(), UserHistoryType.AUTO_ADD.getValue(), "SYSTEM");
                    }
                    catch (OperationNotPermittedException | GroupNotFoundException | OperationFailedException | UserNotFoundException | EntityException | IllegalArgumentException e) {
                        log.error("AuthenticationEventListener crowdService.addUserToGroup Exception", e);
                    }
                }
                catch (Exception e) {
                    log.error("AuthenticationEventListener flex add group Exception", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("AuthenticationEventListener : ", (Throwable)e);
            }
        }
    }

    public boolean reactivateLoginUser(ConfluenceUser confluenceUser) {
        log.debug("===== loginEventListener reactivateLoginUser ===== : {} ", (Object)confluenceUser.getName());
        GroupListEntity[] groupListEntities = this.activateObjectsService.getGroupList();
        boolean isSource = false;
        for (GroupListEntity groupListEntity : groupListEntities) {
            String sourceGroup = groupListEntity.getUserGroupName();
            User crowdUser = this.crowdService.getUser(confluenceUser.getName());
            isSource = this.crowdService.isUserMemberOfGroup(crowdUser, this.crowdService.getGroup(sourceGroup));
            if (isSource) break;
        }
        try {
            if (this.userAcc.isDeactivated((com.atlassian.user.User)confluenceUser) && isSource) {
                String adminUsername = this.activateObjectsService.getAdminUser();
                ConfluenceUser adminAppUser = this.userAcc.getUserByName(adminUsername);
                AuthenticatedUserThreadLocal.set((ConfluenceUser)adminAppUser);
                this.userAcc.reactivateUser((com.atlassian.user.User)confluenceUser);
                return true;
            }
        }
        catch (Exception e) {
            AuthenticatedUserThreadLocal.reset();
            log.error("AuthenticationEventListener Auto Login reactivateLoginUser ::::::::::: ", (Throwable)e);
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

