/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.jobs;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.entity.NotiEntity;
import kr.osci.luffy.entity.NotiSetupEntity;
import kr.osci.luffy.services.ActivateObjectsService;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named
public class UserCountJob
implements JobRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UserCountJob.class);
    @ComponentImport
    private final SchedulerService schedulerService;
    private final ActivateObjectsService activateObjectsService;
    @ComponentImport
    private final TransactionTemplate template;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Inject
    public UserCountJob(SchedulerService schedulerService, ActivateObjectsService activateObjectsService, TransactionTemplate template, UserAccessor userAccessor) {
        this.schedulerService = schedulerService;
        this.activateObjectsService = activateObjectsService;
        this.template = template;
        this.userAccessor = userAccessor;
    }

    @JsonIgnore
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        log.warn("UserCountJob runJob start");
        String result = (String)this.template.execute(() -> {
            String tmp = "";
            NotiSetupEntity notiSetupEntity = this.activateObjectsService.getNotiSetup();
            NotiEntity[] notiEntities = this.activateObjectsService.getNotiEntity();
            int cntLicense = this.userAccessor.countLicenseConsumingUsers();
            try {
                if (notiSetupEntity.getInUse() && notiEntities.length > 0 && cntLicense >= notiSetupEntity.getNotiLimit()) {
                    this.activateObjectsService.overUsersSendEmail(notiSetupEntity.getNotiLimit());
                }
            }
            catch (Exception e) {
                log.warn("UserCountJob runJob log\n" + e.getMessage());
            }
            return tmp;
        });
        return JobRunnerResponse.success((String)result);
    }

    public void destroy() {
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)UserCountJob.class.getName()));
        this.schedulerService.unscheduleJob(JobId.of((String)UserCountJob.class.getName()));
        log.warn("UserCountJob destroyed..");
    }
}

