/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.jobs;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.services.ActivateObjectsService;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named
public class UserCountController
implements JobRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UserCountController.class);
    @ComponentImport
    private final SchedulerService schedulerService;
    private final ActivateObjectsService activateObjectsService;
    @ComponentImport
    private final TransactionTemplate template;

    @Inject
    public UserCountController(SchedulerService schedulerService, ActivateObjectsService activateObjectsService, TransactionTemplate template) {
        this.schedulerService = schedulerService;
        this.activateObjectsService = activateObjectsService;
        this.template = template;
    }

    @JsonIgnore
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        log.warn("UserCountController runJob start");
        log.warn("jobRunnerRequest.getJobConfig().getRunMode() : {} ", (Object)jobRunnerRequest.getJobConfig().getRunMode());
        String result = (String)this.template.execute(() -> {
            LicenseEntity entity = this.activateObjectsService.getLicense();
            String tmp = "";
            try {
                if (entity.isDeactiveEnabled()) {
                    int day = entity.getLastLogin();
                    log.warn(":+:+ Last Login Day %s", (Object)day);
                    this.activateObjectsService.removeUsersByLastLogin(day, true);
                }
            }
            catch (Exception e) {
                log.warn("luffy log\n" + e.getMessage());
            }
            return tmp;
        });
        return JobRunnerResponse.success((String)result);
    }

    public void destroy() {
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)UserCountController.class.getName()));
        this.schedulerService.unscheduleJob(JobId.of((String)UserCountController.class.getName()));
        log.warn("UserCountController job destroyed..");
    }
}

