/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.jobs;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.services.AutoLoginService;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named
public class MaintainLicenseJob
implements JobRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MaintainLicenseJob.class);
    @ComponentImport
    private final SchedulerService schedulerService;
    @ComponentImport
    private final TransactionTemplate template;
    private final AutoLoginService autoLoginService;

    @Inject
    public MaintainLicenseJob(SchedulerService schedulerService, TransactionTemplate template, AutoLoginService autoLoginService) {
        this.schedulerService = schedulerService;
        this.template = template;
        this.autoLoginService = autoLoginService;
    }

    @JsonIgnore
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        JobId jobId = request.getJobId();
        log.warn("INFO fulMaintainLicenseJob id: {} - start ", (Object)jobId);
        String result = (String)this.template.execute(() -> {
            String tmp = "";
            try {
                this.autoLoginService.keepingLicense(jobId);
            }
            catch (Exception e) {
                log.error("MaintainLicenseJob runJob : ", (Throwable)e);
            }
            return tmp;
        });
        return JobRunnerResponse.success((String)result);
    }

    public void destroy() throws Exception {
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)MaintainLicenseJob.class.getName()));
        this.schedulerService.unscheduleJob(JobId.of((String)MaintainLicenseJob.class.getName()));
        log.warn("MaintainLicenseJob destroyed..");
    }
}

