/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.filter;

import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.security.login.LoginResult;
import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kr.osci.luffy.entity.GroupListEntity;
import kr.osci.luffy.entity.LicenseEntity;
import kr.osci.luffy.entity.UserHistoryType;
import kr.osci.luffy.services.ActivateObjectsService;
import kr.osci.luffy.services.AutoLoginService;
import kr.osci.luffy.services.UserHistoryService;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Named
public class SecAuthFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 6707884441225656271L;
    private static final Logger log = LoggerFactory.getLogger(SecAuthFilter.class);
    private final ActivateObjectsService activateObjectsService;
    @ComponentImport
    private final UserAccessor userAcc;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final TransactionTemplate template;
    @ComponentImport
    private final LoginManager loginManager;
    @ComponentImport
    private final GroupManager groupManager;
    private final UserHistoryService userHistoryService;
    private final AutoLoginService autoLoginService;

    @Autowired
    public SecAuthFilter(UserAccessor userAcc, ActivateObjectsService activateObjectsService, TemplateRenderer renderer, CrowdService crowdService, TransactionTemplate templat, LoginManager loginManager, GroupManager groupManager, UserHistoryService userHistoryService, AutoLoginService autoLoginService) {
        this.userAcc = userAcc;
        this.activateObjectsService = activateObjectsService;
        this.renderer = renderer;
        this.crowdService = crowdService;
        this.template = templat;
        this.loginManager = loginManager;
        this.groupManager = groupManager;
        this.userHistoryService = userHistoryService;
        this.autoLoginService = autoLoginService;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        com.atlassian.crowd.embedded.api.User cUser;
        LicenseEntity entity;
        Boolean isSource;
        boolean reactiveResult;
        ConfluenceUser user;
        HttpServletResponse httpResponse;
        HttpServletRequest httpRequest;
        block34: {
            log.info("flex Start :::::: ");
            httpRequest = (HttpServletRequest)request;
            httpResponse = (HttpServletResponse)response;
            String baseUrl = httpRequest.getRequestURL().toString();
            if (baseUrl.matches(".*(css|jpg|png|gif|js|dev-toolbar|svg|woff|eot)")) {
                chain.doFilter((ServletRequest)httpRequest, response);
                return;
            }
            String url = httpRequest.getRequestURI();
            List<String> excludePatterns = Arrays.asList("logout.action", "/json/startheartbeatactivity.action", "/plugins/pagetree/naturalchildren.action", "/plugins/servlet/notifications-miniview");
            boolean excluded = excludePatterns.stream().anyMatch(url::contains);
            if (excluded) {
                chain.doFilter((ServletRequest)httpRequest, response);
                return;
            }
            user = null;
            com.atlassian.crowd.model.user.User ssoUser = null;
            ConfluenceUserPrincipal cup = null;
            reactiveResult = false;
            try {
                ssoUser = this.getSsoLoginUser(httpRequest);
            }
            catch (Exception e) {
                log.info("getSsoLoginUser Exception" + e.getMessage());
            }
            try {
                if (httpRequest.getSession().getAttribute("seraph_defaultauthenticator_user") != null) {
                    if (httpRequest.getSession().getAttribute("seraph_defaultauthenticator_user") instanceof ConfluenceUserPrincipal) {
                        cup = (ConfluenceUserPrincipal)httpRequest.getSession().getAttribute("seraph_defaultauthenticator_user");
                        user = this.userAcc.getUserByName(cup.getName());
                    } else if (httpRequest.getSession().getAttribute("seraph_defaultauthenticator_user") instanceof ConfluenceUser) {
                        user = (ConfluenceUser)httpRequest.getSession().getAttribute("seraph_defaultauthenticator_user");
                        user = this.userAcc.getUserByName(user.getName());
                    } else {
                        cup = (ConfluenceUserPrincipal)httpRequest.getSession().getAttribute("seraph_defaultauthenticator_user");
                        user = this.userAcc.getUserByName(cup.getName());
                    }
                }
            }
            catch (Exception e) {
                log.info("seraph_defaultauthenticator_user Exception" + e.getMessage());
                chain.doFilter((ServletRequest)httpRequest, response);
                return;
            }
            if (httpRequest.getParameter("os_username") != null) {
                String userName = httpRequest.getParameter("os_username");
                ConfluenceUser confluenceUser = this.userAcc.getUserByName(userName);
                if (httpRequest.getParameter("os_password") != null && !ObjectUtils.isEmpty((Object)confluenceUser)) {
                    String password = httpRequest.getParameter("os_password");
                    if (!Objects.equals(password, "")) {
                        LoginResult loginResult = this.loginManager.authenticate(userName, password);
                        if (!this.validLoginResult(loginResult)) {
                            LicenseEntity licenseEntity = (LicenseEntity)this.template.execute(this.activateObjectsService::getLicense);
                            boolean isReactive = licenseEntity.getIsReactive();
                            if (isReactive) {
                                reactiveResult = this.reactivateLoginUser(confluenceUser, password);
                            }
                            if (!reactiveResult) {
                                log.info("\ud328\uc2a4\uc6cc\ub4dc \uc2e4\ud328");
                                this.loginManager.resetFailedLoginCount((User)confluenceUser);
                                chain.doFilter(request, response);
                                return;
                            }
                        }
                    } else {
                        log.info("\ud328\uc2a4\uc6cc\ub4dc \ud655\uc778 \uc2e4\ud328");
                    }
                }
            }
            isSource = false;
            entity = (LicenseEntity)this.template.execute((TransactionCallback)new TransactionCallback<LicenseEntity>(){

                public LicenseEntity doInTransaction() {
                    return SecAuthFilter.this.activateObjectsService.getLicense();
                }
            });
            cUser = null;
            try {
                if (user != null) {
                    cUser = this.crowdService.getUser(user.getName());
                    log.debug("user not null : {}", (Object)cUser.getName());
                    break block34;
                }
                if (ssoUser != null) {
                    cUser = this.crowdService.getUser(ssoUser.getName());
                    log.debug("ssoUser not null : {}", (Object)cUser.getName());
                    break block34;
                }
                if (httpRequest.getParameter("os_username") != null) {
                    String userName = httpRequest.getParameter("os_username");
                    cUser = this.crowdService.getUser(userName);
                    user = this.userAcc.getUserByName(userName);
                    log.debug("os_username not null : {}", (Object)cUser.getName());
                    break block34;
                }
                chain.doFilter((ServletRequest)httpRequest, response);
                return;
            }
            catch (Exception e) {
                log.info("crowdService.getUser Exception" + e.getMessage());
                chain.doFilter((ServletRequest)httpRequest, response);
                return;
            }
        }
        try {
            if (!entity.getIsAutoLogin().booleanValue()) {
                chain.doFilter((ServletRequest)httpRequest, response);
                return;
            }
            Boolean isAdmin = this.crowdService.isUserMemberOfGroup(cUser, this.crowdService.getGroup("confluence-administrators"));
            log.debug("fulFilter adminCheck : {} : {}", (Object)isAdmin, (Object)cUser.getName());
        }
        catch (Exception e) {
            chain.doFilter((ServletRequest)httpRequest, response);
            return;
        }
        GroupListEntity[] groupListEntities = (GroupListEntity[])this.template.execute(this.activateObjectsService::getGroupList);
        try {
            Boolean isTarget = this.crowdService.isUserMemberOfGroup(cUser, this.crowdService.getGroup(entity.getTargetGroup()));
            if (!isTarget.booleanValue()) {
                GroupListEntity groupListEntity;
                String sourceGroup;
                GroupListEntity[] isReactive = groupListEntities;
                int n = isReactive.length;
                for (int i = 0; i < n && !(isSource = Boolean.valueOf(this.crowdService.isUserMemberOfGroup(cUser, this.crowdService.getGroup(sourceGroup = (groupListEntity = isReactive[i]).getUserGroupName())))).booleanValue(); ++i) {
                }
                if (isSource.booleanValue()) {
                    try {
                        this.groupManager.addMembership(this.groupManager.getGroup(entity.getTargetGroup()), (User)user);
                        this.userHistoryService.insertUserHistory(cUser.getName(), UserHistoryType.AUTO_ADD.getValue(), "SYSTEM");
                        this.renderer.render("ui/tryLogin.vm", (Writer)httpResponse.getWriter());
                        return;
                    }
                    catch (OperationNotPermittedException | GroupNotFoundException | OperationFailedException | UserNotFoundException | EntityException | IllegalArgumentException e) {
                        log.info("crowdService.addUserToGroup Exception" + e.getMessage());
                        chain.doFilter((ServletRequest)httpRequest, response);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("flex add group Exception" + e.getMessage());
        }
        if (reactiveResult) {
            this.renderer.render("ui/tryLogin.vm", (Writer)httpResponse.getWriter());
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public boolean validLoginResult(LoginResult loginResult) {
        String loginResultText = loginResult.toString();
        return loginResultText.equals("OK") || loginResultText.equals("OK_WITH_ELEVATED_SECURITY_CHECK_REQUIRED");
    }

    public boolean reactivateLoginUser(ConfluenceUser confluenceUser, String password) {
        GroupListEntity[] groupListEntities = this.activateObjectsService.getGroupList();
        boolean isSource = false;
        for (GroupListEntity groupListEntity : groupListEntities) {
            String sourceGroup = groupListEntity.getUserGroupName();
            com.atlassian.crowd.embedded.api.User crowdUser = this.crowdService.getUser(confluenceUser.getName());
            isSource = this.crowdService.isUserMemberOfGroup(crowdUser, this.crowdService.getGroup(sourceGroup));
            if (isSource) break;
        }
        try {
            if (this.userAcc.isDeactivated((User)confluenceUser) && isSource) {
                String adminUsername = this.activateObjectsService.getAdminUser();
                ConfluenceUser adminAppUser = this.userAcc.getUserByName(adminUsername);
                AuthenticatedUserThreadLocal.set((ConfluenceUser)adminAppUser);
                this.userAcc.reactivateUser((User)confluenceUser);
                LoginResult loginResult = this.loginManager.authenticate(confluenceUser.getName(), password);
                if (!this.validLoginResult(loginResult)) {
                    this.userAcc.deactivateUser((User)confluenceUser);
                    AuthenticatedUserThreadLocal.reset();
                    return false;
                }
                AuthenticatedUserThreadLocal.reset();
                return true;
            }
        }
        catch (Exception e) {
            AuthenticatedUserThreadLocal.reset();
            log.error("Auto Login reactivateLoginUser ::::::::::: ", (Throwable)e);
        }
        return false;
    }

    public com.atlassian.crowd.model.user.User getSsoLoginUser(HttpServletRequest httpRequest) throws IOException {
        com.atlassian.crowd.model.user.User user = null;
        InputStream iStream = ClassLoaderUtils.getResourceAsStream((String)"crowd.properties", this.getClass());
        Properties props = new Properties();
        props.load(iStream);
        String crowdUrl = props.getProperty("crowd.base.url");
        String applicationName = props.getProperty("application.name");
        String applicationPass = props.getProperty("application.password");
        CrowdClient client = new RestCrowdClientFactory().newInstance(crowdUrl, applicationName, applicationPass);
        Cookie[] cookies = httpRequest.getCookies();
        String ssoToken = null;
        String cookieName = "crowd.token_key";
        try {
            CookieConfiguration crowdInfo = client.getCookieConfiguration();
            if (crowdInfo.getName() != null) {
                cookieName = crowdInfo.getName();
            }
            log.info("findUserFromSSOToken:::::::::: TokenName : " + cookieName);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            log.info("findUserFromSSOToken:::::::::: crowdInfo OperationFailedException");
        }
        catch (InvalidAuthenticationException e) {
            log.info("findUserFromSSOToken:::::::::: crowdInfo InvalidAuthenticationException");
        }
        catch (ApplicationPermissionException e) {
            log.info("findUserFromSSOToken:::::::::: crowdInfo ApplicationPermissionException");
        }
        try {
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookieName.equals(cookie.getName())) continue;
                    ssoToken = cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (ssoToken != null) {
                user = client.findUserFromSSOToken(ssoToken);
            }
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            log.warn("findUserFromSSOToken:::::::::: SSO is not OperationFailedException");
        }
        catch (InvalidAuthenticationException e) {
            log.warn("findUserFromSSOToken:::::::::: SSO is not InvalidAuthenticationException");
        }
        catch (ApplicationPermissionException e) {
            log.warn("findUserFromSSOToken:::::::::: SSO is not ApplicationPermissionException");
        }
        catch (InvalidTokenException e) {
            log.warn("findUserFromSSOToken:::::::::: SSO is not InvalidTokenException");
        }
        return user;
    }

    private String getSamlUserName(HttpServletRequest httpServletRequest) {
        String userName = "";
        String samlResponse = httpServletRequest.getParameter("SAMLResponse");
        try {
            samlResponse = samlResponse.replace('-', '+').replace('_', '/');
            byte[] payloadBytes = Base64.getDecoder().decode(samlResponse);
            String samlResponseXml = new String(payloadBytes, StandardCharsets.UTF_8);
            log.debug("samlResponseXml : " + samlResponseXml);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(samlResponseXml)));
            NodeList nodeList = document.getElementsByTagName("*");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String tagName;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(tagName = node.getNodeName()).contains("NameID")) continue;
                userName = node.getTextContent();
                break;
            }
            log.debug("nameIDValue : " + userName);
        }
        catch (Exception e) {
            log.error("getSamlUserName", (Throwable)e);
        }
        return userName;
    }
}

