/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.db;

public class QueryLoader {
    public static String getTotalUserCount() {
        return "SELECT COUNT(1) USER_COUNT FROM cwd_user WHERE active = 'T' ";
    }

    public static String getGroupUserCount() {
        return "SELECT cwd_group.group_name, COUNT(DISTINCT CASE WHEN cwd_user.active = 'T' THEN cwd_user.user_name END) AS active_users, COUNT(DISTINCT CASE WHEN cwd_user.active = 'F' THEN cwd_user.user_name END) AS inactive_users, COUNT(DISTINCT cwd_user.user_name) AS TOTAL_USERS FROM cwd_group INNER JOIN cwd_membership ON cwd_membership.parent_id = cwd_group.id INNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id WHERE cwd_group.group_name = ? GROUP BY cwd_group.group_name ORDER BY TOTAL_USERS DESC ";
    }

    public static String getTotalUserCountByGroups() {
        return "SELECT COUNT(DISTINCT cwd_user.user_name) AS USER_COUNT FROM cwd_group INNER JOIN cwd_membership ON cwd_membership.parent_id = cwd_group.id INNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id WHERE cwd_group.group_name IN ({IN_VALUES}) AND cwd_user.active = 'T' ";
    }

    public static String getUserCountsByGroups() {
        return "SELECT COALESCE(COUNT(DISTINCT cwd_user.user_name), 0) AS USER_COUNT, cwd_group.group_name FROM cwd_group LEFT JOIN cwd_membership ON cwd_membership.parent_id = cwd_group.id LEFT JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id AND cwd_user.active = 'T' WHERE cwd_group.group_name IN ({IN_VALUES}) GROUP BY cwd_group.group_name ORDER BY COUNT(cwd_user.user_name) DESC ";
    }

    public static String getRemoveUserCount(String dbName) {
        String query = " WITH UserLoginStatus AS (     SELECT         CU.user_name,         CU.active,         MAX(LI.SUCCESSDATE) AS LastLoginDate     FROM         cwd_user CU         LEFT JOIN user_mapping UM ON UM.lower_username  = LOWER(CU.user_name)         LEFT JOIN logininfo LI ON UM.user_key = LI.USERNAME     WHERE CU.active = 'T'     AND user_name IN (SELECT cwd_user.user_name                       FROM cwd_user                       JOIN cwd_membership ON cwd_membership.child_user_id =  cwd_user.id                       JOIN cwd_group ON cwd_group.id = cwd_membership.parent_id                       WHERE cwd_group.group_name = ?                       GROUP BY cwd_user.user_name     )     GROUP BY CU.user_name, CU.active  )  SELECT     COUNT(DISTINCT CASE WHEN active = 'T' AND LastLoginDate <= CAST( ? AS DATETIME) THEN user_name END) AS activeusersover,     COUNT(DISTINCT CASE WHEN active = 'T' AND LastLoginDate > CAST( ? AS DATETIME) THEN user_name END) AS activeusersunder,     COUNT(DISTINCT CASE WHEN active = 'F' AND LastLoginDate <= CAST( ? AS DATETIME) THEN user_name END) AS inactiveusersover,     COUNT(DISTINCT CASE WHEN active = 'F' AND LastLoginDate > CAST( ? AS DATETIME) THEN user_name END) AS inactiveusersunder,     COUNT(DISTINCT CASE WHEN LastLoginDate IS NULL THEN user_name END) AS userswithoutloginrecord  FROM UserLoginStatus ";
        if (dbName.contains("h2") || dbName.contains("oracle") || dbName.contains("postgres")) {
            query = " WITH UserLoginStatus AS (     SELECT         CU.user_name,         CU.active,         MAX(LI.SUCCESSDATE) AS LastLoginDate     FROM         cwd_user CU         LEFT JOIN user_mapping UM ON UM.lower_username  = LOWER(CU.user_name)         LEFT JOIN logininfo LI ON UM.user_key = LI.USERNAME     WHERE CU.active = 'T'     AND user_name IN (SELECT cwd_user.user_name                       FROM cwd_user                       JOIN cwd_membership ON cwd_membership.child_user_id =  cwd_user.id                       JOIN cwd_group ON cwd_group.id = cwd_membership.parent_id                       WHERE cwd_group.group_name = ?                       GROUP BY cwd_user.user_name     )     GROUP BY CU.user_name, CU.active ) SELECT     COUNT(DISTINCT CASE WHEN active = 'T' AND LastLoginDate <= CAST( ? AS TIMESTAMP) THEN user_name END) AS activeusersover,     COUNT(DISTINCT CASE WHEN active = 'T' AND LastLoginDate > CAST( ? AS TIMESTAMP) THEN user_name END) AS activeusersunder,     COUNT(DISTINCT CASE WHEN active = 'F' AND LastLoginDate <= CAST( ? AS TIMESTAMP) THEN user_name END) AS inactiveusersover,     COUNT(DISTINCT CASE WHEN active = 'F' AND LastLoginDate > CAST( ? AS TIMESTAMP) THEN user_name END) AS inactiveusersunder,     COUNT(DISTINCT CASE WHEN LastLoginDate IS NULL THEN user_name END) AS userswithoutloginrecord FROM UserLoginStatus ";
        }
        return query;
    }

    public static String getRemoveUserList(String dbName, boolean excludeNoLoginUsers) {
        String query = "SELECT CU.user_name, CU.active,       MAX(LI.SUCCESSDATE) AS LastLoginDate FROM      cwd_user CU      LEFT JOIN user_mapping UM ON UM.lower_username  = LOWER(CU.user_name)      LEFT JOIN logininfo LI ON UM.user_key = LI.USERNAME WHERE    CU.user_name IN (         SELECT cwd_user.user_name         FROM cwd_user         JOIN cwd_membership ON cwd_membership.child_user_id = cwd_user.id         JOIN cwd_group ON cwd_group.id = cwd_membership.parent_id         WHERE cwd_group.group_name = ?         GROUP BY cwd_user.user_name     ) GROUP BY CU.user_name, CU.active HAVING MAX(LI.SUCCESSDATE) <= CAST( ? AS DATETIME) ";
        if (dbName.contains("h2") || dbName.contains("oracle") || dbName.contains("postgres")) {
            query = "SELECT CU.user_name, CU.active,       MAX(LI.SUCCESSDATE) AS LastLoginDate FROM      cwd_user CU      LEFT JOIN user_mapping UM ON UM.lower_username  = LOWER(CU.user_name)      LEFT JOIN logininfo LI ON UM.user_key = LI.USERNAME WHERE    CU.user_name IN (         SELECT cwd_user.user_name         FROM cwd_user         JOIN cwd_membership ON cwd_membership.child_user_id = cwd_user.id         JOIN cwd_group ON cwd_group.id = cwd_membership.parent_id         WHERE cwd_group.group_name = ?         GROUP BY cwd_user.user_name     ) GROUP BY CU.user_name, CU.active HAVING MAX(LI.SUCCESSDATE) <= CAST( ? AS TIMESTAMP) ";
        }
        if (!excludeNoLoginUsers) {
            query = query + " OR MAX(LI.SUCCESSDATE) IS NULL";
        }
        return query;
    }

    public static String getLastLoginInfoList(boolean excludeNotLogin) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" SELECT ").append("   CU.user_name, ").append("   CU.active, ").append("   MAX(LI.SUCCESSDATE) AS LastLoginDate ").append(" FROM cwd_user CU ").append(" JOIN cwd_membership CM ON CM.child_user_id = CU.id ").append(" JOIN cwd_group CG ON CG.id = CM.parent_id ").append(" LEFT JOIN user_mapping UM ON UM.lower_username = LOWER(CU.user_name) ").append(" LEFT JOIN logininfo LI ON UM.user_key = LI.USERNAME ").append(" WHERE CU.active = 'T' ").append(" AND CG.group_name = ? ").append(" GROUP BY CU.user_name, CU.active ");
        if (excludeNotLogin) {
            queryBuilder.append(" HAVING MAX(LI.SUCCESSDATE) IS NOT NULL ");
        }
        queryBuilder.append(" ORDER BY MAX(LI.SUCCESSDATE), CU.user_name ");
        return queryBuilder.toString();
    }
}

