/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.db;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.osci.luffy.constants.DBConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(QueryExecutor.class);
    private final TransactionalExecutor transactionalExecutor;

    public QueryExecutor() {
        this.transactionalExecutor = ((TransactionalExecutorFactory)ComponentLocator.getComponent(TransactionalExecutorFactory.class)).createExecutor(true, true).readOnly().newTransaction();
    }

    public QueryExecutor(boolean readOnly, boolean requiresNew) {
        this.transactionalExecutor = ((TransactionalExecutorFactory)ComponentLocator.getComponent(TransactionalExecutorFactory.class)).createExecutor(readOnly, requiresNew).readOnly().newTransaction();
    }

    public String getDatabaseName() {
        return (String)this.transactionalExecutor.execute(connection -> {
            try {
                return connection.getMetaData().getDatabaseProductName();
            }
            catch (SQLException e) {
                log.error("getDatabaseName error : " + e);
                throw new RuntimeException();
            }
        });
    }

    public boolean isSupportDatabase() {
        String dbName = this.getDatabaseName().toLowerCase().trim();
        for (String supportedDb : DBConstants.DATABASES) {
            if (!dbName.contains(supportedDb)) continue;
            return true;
        }
        return false;
    }

    public List<Map<String, Object>> executeQuery(String query, List<Object> params) {
        log.debug("query : ............" + query);
        return (List)this.transactionalExecutor.execute(connection -> {
            ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
            try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
                for (int i = 0; i < params.size(); ++i) {
                    log.debug("params : " + params.get(i));
                    preparedStatement.setObject(i + 1, params.get(i));
                }
                log.debug("resultset : " + preparedStatement.toString());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    int columnCount = metaData.getColumnCount();
                    while (resultSet.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        for (int i = 1; i <= columnCount; ++i) {
                            String columnName = metaData.getColumnName(i);
                            Object value = resultSet.getObject(i);
                            row.put(columnName, value);
                        }
                        results.add(row);
                    }
                }
            }
            catch (Exception e) {
                log.error("executeQuery : " + e);
            }
            List<Map<String, Object>> modifiedResults = this.modifyResultsLowerCaseKeys(results);
            return modifiedResults;
        });
    }

    private List<Map<String, Object>> modifyResultsLowerCaseKeys(List<Map<String, Object>> results) {
        ArrayList<Map<String, Object>> modifiedResults = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : results) {
            HashMap<String, Object> modifiedMap = new HashMap<String, Object>();
            for (String key : map.keySet()) {
                modifiedMap.put(key.toLowerCase(), map.get(key));
            }
            modifiedResults.add(modifiedMap);
        }
        return modifiedResults;
    }
}

