/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.luffy.db.QueryExecutor;
import kr.osci.luffy.db.QueryLoader;
import kr.osci.luffy.entity.GroupListEntity;
import kr.osci.luffy.services.ActivateObjectsService;
import kr.osci.luffy.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class CommonDbAccessService {
    private static final Logger log = LoggerFactory.getLogger(CommonDbAccessService.class);
    private final ActivateObjectsService activateObjectsService;

    @Inject
    public CommonDbAccessService(ActivateObjectsService activateObjectsService) {
        this.activateObjectsService = activateObjectsService;
    }

    public int getTotalUserCount() {
        String query = QueryLoader.getTotalUserCount();
        QueryExecutor queryExecutor = new QueryExecutor();
        List<Map<String, Object>> results = queryExecutor.executeQuery(query, new ArrayList<Object>());
        Object obj = results.get(0).get("user_count");
        return Integer.parseInt(obj.toString());
    }

    public Map<String, Object> getUserGroupsInfo() {
        List<String> groupNames = this.getParamGroupNames();
        String inClause = groupNames.stream().map(s -> "?").collect(Collectors.joining(", "));
        String query = QueryLoader.getTotalUserCountByGroups().replace("{IN_VALUES}", inClause);
        ArrayList<Object> params = new ArrayList<Object>(groupNames);
        QueryExecutor queryExecutor = new QueryExecutor();
        List<Map<String, Object>> results = queryExecutor.executeQuery(query, params);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (results.size() > 0) {
            Object obj = results.get(0).get("user_count");
            resultMap.put("userGroupsNames", String.join((CharSequence)", ", groupNames));
            resultMap.put("userGroupsCount", Integer.parseInt(obj.toString()));
        }
        return resultMap;
    }

    public int getGroupUserCount(String targetGroup) {
        String query = QueryLoader.getGroupUserCount();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(targetGroup);
        QueryExecutor queryExecutor = new QueryExecutor();
        List<Map<String, Object>> results = queryExecutor.executeQuery(query, params);
        int count = 0;
        if (results.size() > 0) {
            Object totalUsersCount = results.get(0).get("total_users");
            count = Integer.parseInt(totalUsersCount.toString());
        }
        return count;
    }

    public int getRemoveUserInfo(String canuseGroup, int days, boolean excludeNoLoginUsers) throws Exception {
        int totalCount = this.getGroupUserCount(canuseGroup);
        ArrayList<Object> params = new ArrayList<Object>();
        int removeCount = 0;
        try {
            params.add(canuseGroup);
            String daysAgoDate = DateUtils.calcDateByLastLoginDays(days);
            for (int i = 0; i < 4; ++i) {
                params.add(daysAgoDate);
            }
            QueryExecutor queryExecutor = new QueryExecutor();
            String query = QueryLoader.getRemoveUserCount(queryExecutor.getDatabaseName().toLowerCase().trim());
            List<Map<String, Object>> results = queryExecutor.executeQuery(query, params);
            if (results.size() > 0) {
                Object activeUserOver = results.get(0).get("activeusersover");
                Object activeUserUnder = results.get(0).get("activeusersunder");
                int activeUserOverCnt = Integer.parseInt(activeUserOver.toString());
                int activeUserUnderCnt = Integer.parseInt(activeUserUnder.toString());
                removeCount = excludeNoLoginUsers ? activeUserOverCnt : totalCount - activeUserUnderCnt;
            }
        }
        catch (Exception e) {
            log.error("getRemoveUserInfo error", (Throwable)e);
        }
        return removeCount;
    }

    public List<String> getRemoveUserListInfo(String canuseGroup, int days, boolean excludeNoLoginUsers) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> removeUserList = new ArrayList<String>();
        List<String> filteredRemoveUserList = new ArrayList<String>();
        try {
            String daysAgoDate = DateUtils.calcDateByLastLoginDays(days);
            params.add(canuseGroup);
            params.add(daysAgoDate);
            QueryExecutor queryExecutor = new QueryExecutor();
            String query = QueryLoader.getRemoveUserList(queryExecutor.getDatabaseName().toLowerCase().trim(), excludeNoLoginUsers);
            List<Map<String, Object>> results = queryExecutor.executeQuery(query, params);
            results.forEach(result -> {
                Object username = result.get("user_name");
                removeUserList.add(username.toString());
            });
            filteredRemoveUserList = this.activateObjectsService.filterRemoveUsersByExcludeEntity(removeUserList);
        }
        catch (Exception e) {
            log.error("getRemoveUserListInfo error", (Throwable)e);
        }
        return filteredRemoveUserList;
    }

    public List<Map<String, Object>> getGroupMappingList() {
        List<String> groupNames = this.getParamGroupNames();
        String inClause = groupNames.stream().map(s -> "?").collect(Collectors.joining(", "));
        String query = QueryLoader.getUserCountsByGroups().replace("{IN_VALUES}", inClause);
        ArrayList<Object> params = new ArrayList<Object>(groupNames);
        QueryExecutor queryExecutor = new QueryExecutor();
        return queryExecutor.executeQuery(query, params);
    }

    private List<String> getParamGroupNames() {
        GroupListEntity[] entities = this.activateObjectsService.getGroupList();
        ArrayList<String> groupNames = new ArrayList<String>();
        if (entities != null) {
            for (GroupListEntity entity : entities) {
                if (Objects.equals(entity.getUserGroupName(), "N")) continue;
                log.debug("groupname :" + entity.getUserGroupName());
                groupNames.add(entity.getUserGroupName());
            }
        }
        return groupNames;
    }

    public List<Map<String, Object>> getLastLoginInfoList(boolean excludeNotLogin, String licenseGroup) {
        String query = QueryLoader.getLastLoginInfoList(excludeNotLogin);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(licenseGroup);
        QueryExecutor queryExecutor = new QueryExecutor();
        return queryExecutor.executeQuery(query, params);
    }
}

