/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('sharedlinks/sharedlinks', ['jquery', 'cmis/cmisconfluence', 'cmis/confluence-error-handler'], function($, cmisConfluence, errorHandler) { 'use strict';


  /**
   * 共有済の際に表示されるInlineDialogを表示
   * @param doc
   * @param $el
   * @param invoker
   */
  function showSharedDialog(doc, $el, invoker) {

    $("aui-inline-dialog.sharedlinks-shared-dialog").remove();

    var dialogId = "sharedlinks-shared-" + doc.id,
      shared = doc.shared;

    var param = {
      dialogId: dialogId,
      sharedBy: shared.sharedBy,
      //expiryDate: shared.sharedExpiryDate ? (new Date(shared.sharedExpiryDate)).print(cmisConfluence.getDateTimePickerJsFormat()) : undefined,
      expiryDate: shared.sharedExpiryDate ? moment(new Date(shared.sharedExpiryDate)).format("YYYY/MM/DD") : undefined,
      sharedLinkUrl: cmisConfluence.getSharedLinkUrl(shared),
      mailtoUrl: getMailtoUrl(doc),
      facebookUrl: getFacebookUrl(doc),
      twitterUrl: getTwitterUrl(doc),
      googleUrl: getGoogleUrl(doc)
    };
    var template = $(Connector.Templates.sharedlinks.sharedDialog(param));

    $('body').append(template);

    // inputフォーカス時に全選択
    template.find("input[type=text]").focus(function(){
      $(this).select();
    });

    // クリップボードにコピー
    template.find("a.copy-to-clipboard").click(function() {

      var $input = template.find("input[type=text]");

      // リンクが全選択されていなければ全選択しなおす
      if ($input.val() != window.getSelection().toString()) {
        $input.select();
      }

      document.execCommand('copy');
    });

    // Jiraコメント入力
    template.find(".sharewith-jira").click(function(){

      // コメント入力欄を開く
      JIRA.Issue.invokeCommentTrigger();

      // 現在の入力ちを取得
      var val = JIRA.Issue.CommentForm.getField().val();
      if (val.length > 0) {
        val += "\n";
      }

      // 共有リンクを追記
      JIRA.Issue.CommentForm.getField().val(val+"["+doc.name+"|"+cmisConfluence.getSharedLinkUrl(shared)+"]");
    });

    template.find("a.unshare").click(function(){
      cmisConfluence.unshareLink(shared.sharedId).done(function() {

        doc.shared = undefined;

        $el.find("a.sharedlinks.share").removeClass("hidden");
        $el.find("a.sharedlinks.shared").addClass("hidden");

        closeDialog(dialogId);

      }).fail(function(error) {
        showError($(".messages", template), error);
      });
    });

    // ツールチップ
    try { AJS.$("a.copy-to-clipboard, a.sharewith", template).tooltip(); } catch (e) {}


    openDialog(dialogId);

    // 共有リンクのURLを選択状態にする
    template.find("input[type=text]").select();
  }

  /**
   * 未共有の際に表示されるInlineDialogを表示
   * @param doc
   * @param $el
   * @param invoker
   */
  function showShareDialog(doc, $el, invoker) {

    $("aui-inline-dialog.sharedlinks-share-dialog").remove();

    var dialogId = "sharedlinks-share-" + doc.id;

    var param = {
      dialogId: dialogId
    };
    var template = $(Connector.Templates.sharedlinks.shareDialog(param));

    $('body').append(template);


    template.find("input.share").click(function() {

      var formattedExpire = undefined;
      var expire = template.find("input.expireDatetime").val().trim();

      if (expire.length > 0) {
        /*var d = Date.parseDate(expire, cmisConfluence.getDateTimePickerJsFormat());
        if (d.toString() === "Invalid Date") {
          // フォーマットがおかしい

          return ;
        }*/

        var now = moment();
        var after24hours = moment().add(1, 'days');
        //var expireDatetime = moment(d);
        var expireDatetime = moment(expire);

        if (expireDatetime.isBefore(now)) {
          // 期限が過去
          template.find("div.error")
            .removeClass("hidden")
            .empty()
            .text(AJS.I18n.getText('alfresco.for.confluence.sharedlinks.share.error.pastDate'));
          return ;
        }

        // 期限が24時間以上後になっているかチェック
        if (expireDatetime.isBefore(after24hours)) {
          // 24時間以内
          template.find("div.error")
            .removeClass("hidden")
            .empty()
            .text(AJS.I18n.getText('alfresco.for.confluence.sharedlinks.share.error.within24hours'));
          return ;
        }

        formattedExpire = expireDatetime.format("YYYY-MM-DDTHH:mm:ss.SSSZZ");
      }

      //
      cmisConfluence.shareLink(doc, formattedExpire).done(function () {

        doc.cmisSession.getShared(doc.versionSeriesId).done(function (shared) {

          doc.shared = shared;

          // Inline Dialogを閉じる
          closeDialog(dialogId);

          $el.find("a.sharedlinks.shared").removeClass("hidden");
          $el.find("a.sharedlinks.share").addClass("hidden");

          // Inline Dialogを開く
          $el.find(".shared").click();

        }).fail(function (error) {
          showError($(".messages", template), error);
        });
      }).fail(function (error) {
        showError($(".messages", template), error);
      });
    });
/*
    var $fieldInput = template.find("input.expireDatetime");
    $fieldInput.attr('placeholder', AJS.Meta.get("date-complete"));
    $fieldInput.attr('autocomplete', 'off');

    // カレンダーをセットアップ
    Calendar.setup({
      context: template,
      inputField: $fieldInput.attr("id"),
      button: $fieldInput.attr("id") + "-trigger",
      align: "Br",
      firstDay: "0",
      singleClick: true,
      showsTime: true,
      timeFormat: "12",
      ifFormat: "YYYY/MM/DD",
      onClose: function(cal) {
        // カレンダーのクローズと同時にInlineDialogが閉じないよう制御
        if (el) {
          setTimeout(function() {
            el.persistent = false;
          }, 0);
        }
        cal.hide();
      },
      useIOS8601WeekNumbers: false // とりあえず
    });
*/
    var el = openDialog(dialogId);
/*
    $("#" + $fieldInput.attr("id") + "-trigger").click(function() {
      if ($("body > div.calendar.active").length > 0) {
        el.persistent = true;
      }
    });
 */

  }

  /**
   * Inline Dialogを開く
   * @param id
   */
  function openDialog(id) {
    var inlineDialog = document.getElementById(id);
    inlineDialog.open = true;
    inlineDialog.setAttribute('open', '');  // Equivalent to line above.

    return inlineDialog;
  }

  /**
   * Inline Dialogを閉じる
   * @param id
   */
  function closeDialog(id) {
    var inlineDialog = document.getElementById(id);
    inlineDialog.open = false;
    inlineDialog.removeAttribute('open');  // Equivalent to line above.

    return inlineDialog;
  }

  function getMailtoUrl(doc) {
    return AJS.I18n.getText('alfresco.for.jira.sharedlinks.shared.mailto.link', encodeURIComponent(doc.name), encodeURIComponent(cmisConfluence.getSharedLinkUrl(doc.shared)));
  }

  function getFacebookUrl(doc) {
    return AJS.I18n.getText('alfresco.for.jira.sharedlinks.shared.facebook.link', encodeURIComponent(doc.name), encodeURIComponent(cmisConfluence.getSharedLinkUrl(doc.shared)));
  }

  function getTwitterUrl(doc) {
    return AJS.I18n.getText('alfresco.for.jira.sharedlinks.shared.twitter.link', encodeURIComponent(doc.name), encodeURIComponent(cmisConfluence.getSharedLinkUrl(doc.shared)));
  }

  function getGoogleUrl(doc) {
    return AJS.I18n.getText('alfresco.for.jira.sharedlinks.shared.googlePlus.link', encodeURIComponent(cmisConfluence.getSharedLinkUrl(doc.shared)));
  }

  function showError(context, obj) {
    var res = {};
    try {
      res = $.parseJSON(obj.responseText);
    } catch (e) {
    }

    if (res.error && res.error.briefSummary) {
      errorHandler.showError(context, {
        body: res.error.briefSummary,
        error: res
      });
    }
  }

  return {
    showSharedDialog: showSharedDialog,
    showShareDialog: showShareDialog
  }

});
