/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
AJS.toInit(function () {
  require(['jquery', 'confluence-ui-components/js/user-group-select2', 'cmis/cmisconfluence', 'cmis/confluence-error-handler'], function ($, UserGroupSelect2, cmisConfluence, errorHandler) {

    console.log("people-init.js")

    var CONTAINER_CLASS = 'configuration-container';
    var HEADER_CLASS = 'configuration-header';
    var BODY_CLASS = 'configuration-body';
    var MESSAGE_CLASS = 'configuration-message';
    var LOADING_CLASS = "loading-documents";
    var HIDDEN_CLASS = 'hidden';
    var dummy = {
      isFederatable: function () {
        return true;
      },
      isAdmin: function () {
        return true;
      }
    };

    var spaceKey = $("meta[name=ajs-space-key]").attr("content");

    var DIALOG_ID = 'permission-dialog';
    var DIALOG_SECTION = '<section role="dialog" id="' + DIALOG_ID + '" class="aui-layer aui-dialog2 aui-dialog2-medium loadingInProgress" aria-hidden="true""></section>';
    var ajsDlg;

    var CUSTOM_REST_BASE_URL = contextPath + "/rest/alfresco/1.0";

    var userAvatars = {};
    var roles;

    initSession().done(function () {

      if (spaceKey) {
        rendarUsage();
      }

      rendarTable($("#feature-permission"));

      $("#feature-permission").removeClass(HIDDEN_CLASS);

    }).fail(function () {

      $("#feature-permission").empty();

    });


    function rendarUsage() {
      $.ajax({
        url: CUSTOM_REST_BASE_URL + "/usage/permission?spaceKey=" + spaceKey,
        success: function (response) {
          $("#permission-message-bar").empty();
          if (response.enable) {
            AJS.messages.success($("#permission-message-bar"), {
              title: AJS.I18n.getText('alfresco.for.confluence.admin.permission.activate.title'),
              body: AJS.I18n.getText('alfresco.for.confluence.admin.permission.activate.description')
            });
            $(".aui-buttons", $(".permission-panel")).empty().append($("<button class='aui-button'>" + AJS.I18n.getText('alfresco.for.confluence.admin.permission.deactivate') + "</button>").click(function () {
              $.ajax({
                url: CUSTOM_REST_BASE_URL + "/usage/permission",
                type: 'POST',
                data: JSON.stringify({enable: false, spaceKey: spaceKey}),
                contentType: 'application/json',
                dataType: "json",
                complete: function () {
                  rendarUsage();
                }
              });
            }));
          } else {
            AJS.messages.warning($("#permission-message-bar"), {
              title: AJS.I18n.getText('alfresco.for.confluence.admin.permission.deactivate.title'),
              body: AJS.I18n.getText('alfresco.for.confluence.admin.permission.deactivate.description')
            });
            $(".aui-buttons", $(".permission-panel")).empty().append($("<button class='aui-button'>" + AJS.I18n.getText('alfresco.for.confluence.admin.permission.activate') + "</button>").click(function () {
              $.ajax({
                url: CUSTOM_REST_BASE_URL + "/usage/permission",
                type: 'POST',
                data: JSON.stringify({enable: true, spaceKey: spaceKey}),
                contentType: 'application/json',
                dataType: "json",
                complete: function (xhr, status, response) {
                  rendarUsage();
                }
              });
            }));
          }
        }
      });
    }

    function rendarTable() {
      var roleTable = $("#permission-panel-people").empty().append(Confluence.Templates.People.table());
      $.ajax({
        url: (function () {
          if (spaceKey) {
            return CUSTOM_REST_BASE_URL + '/permission?spaceKey=' + spaceKey;
          } else {
            return CUSTOM_REST_BASE_URL + '/default/permission';
          }
        })(),
        success: function (response) {
          $.each(response, function (i, data) {
            $(roleTable).find("tbody").append($(Confluence.Templates.People.row({
              data: data
            })));
            $(roleTable).find('tr[data-id=' + data.id + ']').find('a.edit').click(function () {
              if (!ajsDlg) {
                $('body').append(DIALOG_SECTION);
                ajsDlg = AJS.dialog2("#" + DIALOG_ID).on("hide", function () {
                  rendarTable();
                });
              }
              renderDialog($("#" + DIALOG_ID), data);
              ajsDlg.show();
            });
          });
        }
      });
    }


    function renderDialog(context, data) {
      var dialogMethod = cmisConfluence.isGreaterThanOrEqualTo(AJS.version, "9.0") ? 'permissionDialog2' : 'permissionDialog';
      context.empty().append($(Confluence.Templates.People[dialogMethod]({
        title: data.title
      })));

      UserGroupSelect2.bind("#permission-people-table");

      var roleTable = $("#permission-people-table", context);

      function getRole() {
        var projectRoles = [];
        $.ajax({
          async: false,
          url: (function () {
            if (spaceKey) {
              return CUSTOM_REST_BASE_URL + "/permission/" + data.id + "?spaceKey=" + spaceKey;
            } else {
              return CUSTOM_REST_BASE_URL + "/default/permission/" + data.id
            }
          })(),
          success: function (response) {
            var categorisedActors = {};
            $.each(response.actors, function (index, elt) {
              if (!(elt.actorType in categorisedActors)) {
                categorisedActors[elt.actorType] = [];
              }
              categorisedActors[elt.actorType].push(elt.name);

              if (elt.actorType == "user") {
                putAvatar(elt.name, elt.avatarUrl);
              }
            });
            response.categorisedActors = categorisedActors;
            projectRoles.push(response);
          },
          error: function () {
            roleTable.trigger("serverError", [Confluence.SmartAjax.buildSimpleErrorContent(response)]); // TODO
          }
        });

        return projectRoles;
      }


      roles = getRole();

      renderEditTable();

      $("#permission-add-button").click(function () {
        var $picker = $("#s2id_permission-dialog-auto-picker");
        var userGroupData = $picker.select2("data");

        if (userGroupData.length > 0) {
          $.each(userGroupData, function (idx, data) {
            addEntity(data.entity);
          });
        }

        renderEditTable();

        $picker.select2("val", "");

        $("#permission-apply-button").prop("disabled", false);
      });

      $("#permission-apply-button").click(function () {

        var role = roles[0];
        var submitData = {
          id: role.id,
          categorisedActors: role.categorisedActors
        };
        if (spaceKey) {
          submitData["spaceKey"] = spaceKey;
        }
        $.ajax({
          async: false,
          type: 'PUT',
          url: (function () {
            if (spaceKey) {
              return CUSTOM_REST_BASE_URL + "/permission/" + data.id;
            } else {
              return CUSTOM_REST_BASE_URL + "/default/permission/" + data.id;
            }
          })(),
          dataType: 'json',
          contentType: 'application/json',
          data: JSON.stringify(submitData),
          success: function (response) {
            ajsDlg.hide();
          },
          error: function () {
            roleTable.trigger("serverError", [Confluence.SmartAjax.buildSimpleErrorContent(response)]); // TODO
          }
        });
      });

      roleTable.closest("form").addClass("ajs-dirty-warning-exempt"); // Stop dirty form warnings from firing on table

    }

    function renderEditTable() {

      $table = $("#permission-people-table");

      $(".entity", $table).remove();

      var role = roles[0];

      $.each(["user", "group"], function (idx, type) {
        if (role.categorisedActors[type]) {
          $.each(role.categorisedActors[type], function (idx, entity) {
            var avatarUrl = type == "user" ? getAvatar(entity) : "";
            $("tbody", $table).append(Confluence.Templates.People.entity({
              type: type,
              name: entity,
              avatarUrl: avatarUrl
            }));
          });
        }
      });


      $(".remove", $table).click(function () {
        $el = $(this);
        delEntity($el.attr("actor-type"), $el.attr("actor-name"));
        renderEditTable();
        $("#permission-apply-button").prop("disabled", false);
      });
    }

    function addEntity(entity) {

      var role = roles[0];

      role.categorisedActors.user = role.categorisedActors.user || [];
      role.categorisedActors.group = role.categorisedActors.group || [];

      if (entity.type == "user") {

        if ($.inArray(entity.username, role.categorisedActors.user) == -1) {
          role.categorisedActors.user.push(entity.username);
        }

        putAvatar(entity.username, entity.thumbnailLink.href);

      } else if (entity.type == "group") {

        if ($.inArray(entity.name, role.categorisedActors.group) == -1) {
          role.categorisedActors.group.push(entity.name);
        }

      }
    }

    function delEntity(type, name) {

      var role = roles[0];

      role.categorisedActors.user = role.categorisedActors.user || [];
      role.categorisedActors.group = role.categorisedActors.group || [];

      if (type == "user") {

        role.categorisedActors.user = $.grep(role.categorisedActors.user, function (val) {
          return val != name;
        });


      } else if (type == "group") {

        role.categorisedActors.group = $.grep(role.categorisedActors.group, function (val) {
          return val != name;
        });

      }
    }

    function putAvatar(username, avatar) {
      userAvatars[username] = avatar;
    }

    function getAvatar(username) {
      if (userAvatars[username]) {
        return userAvatars[username];
      } else {
        return "";
      }
    }

    /**
     * Global error for forbidden. Show a dialog that lets them log in if logged out.
     */
    $(document).ajaxError(function (e, xhr, ajaxOptions) {
      if (ajaxOptions.url && ajaxOptions.url.indexOf(Confluence.CUSTOM_REST_BASE_URL) !== -1 && xhr.status === 401) {
        if (Confluence.Ajax.isWebSudoFailure(xhr)) {
          Confluence.SmartAjax.handleWebSudoError(ajaxOptions);
        } else {
          Confluence.ErrorDialog.openErrorDialogForXHR(xhr);
        }
      }
    });

    function initSession() {

      var d = new AJS.$.Deferred;

      $("." + MESSAGE_CLASS, "." + CONTAINER_CLASS).empty();

      cmisConfluence.initCmisSession(dummy).done(function () {
        // 最大ログイン試行回数を超えた場合はユーザーにログイン確認とリセットを促す
        if (cmisConfluence.isLimitMaximumLoginAttemptAllowed() && cmisConfluence.isOverMaximumLoginAttemptAllowed()) {
          // 認証エラー
          errorHandler.showError($("." + MESSAGE_CLASS, "." + CONTAINER_CLASS), {
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.reset-failed-login-count', cmisConfluence.getAdminCredentialUrl())
          });
          d.reject();
        } else {
          d.resolve(cmisConfluence.getCmisSession());
        }
      }).fail(function (error) {
        errorHandler.showError($("." + MESSAGE_CLASS, "." + CONTAINER_CLASS), {
          body: AJS.I18n.getText('alfresco.for.jira.ajax.error.session'),
          error: error
        });
        d.reject();
      });

      return d.promise();

    }

  });
});


