/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
jQuery(document).ready(function($) {
  AJS.$("#spaceIds").auiSelect2();
});

AJS.toInit(function() {
  require(['jquery', 'cmis/cmisconfluence', 'cmis/cmisbrowser', 'cmis/confluence-error-handler'], function($, cmisConfluence, treeview, errorHandler) {

    var CONTAINER_CLASS = 'configuration-container';
    var HEADER_CLASS = 'configuration-header';
    var BODY_CLASS = 'configuration-body';
    var MESSAGE_CLASS = 'configuration-message';
    var LOADING_CLASS = "loading-documents";
    var HIDDEN_CLASS = 'hidden';
    var dummy = {
      isFederatable: function () {
        return true;
      },
      isAdmin: function () {
        return true;
      }
    };

    /**
     * 表示画面
     */
    if ($("#mapping-folder").length > 0) {
     
      initSession().pipe(function() {
        
        rendarFolderPath($("#mapping-folder"));

        $("#mapping-folder").removeClass(HIDDEN_CLASS);

      }).fail(function () {

        $("#mapping-folder").empty();

      });
      
    }
    
    /**
     * 削除画面
     */
    if ($("#mapping-folder-remove").length > 0) {
      
      initSession().pipe(function() {

        rendarFolderPath($("#mapping-folder-remove"));

        $("#mapping-folder-remove").removeClass(HIDDEN_CLASS);

      }).fail(function () {

        $("#mapping-folder-remove").empty();

      });
      
    }
    
    /**
     * 編集画面
     */
    if ($("#mapping-folder-edit").length > 0) {
    
      initSession().pipe(function() {

        $("#mapping-folder-edit").removeClass(HIDDEN_CLASS);

        return rendarTree($(".cmis-treebrowser"));
                
      }).pipe(function(expTreeView) {
        
        var folerId = AJS.$('#cmisFolderId').val();
        
        if (folerId) {
          cmisConfluence.getCmisSession().getObject(folerId).done(function(folder) {
            AJS.$('#cmisFolderPath').val(folder.path);
          }).fail(function(error) {
            errorHandler.showError($('.ajax-message', $("#mapping-folder-edit")), { body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.folder') + folerId, error: error });
          });
        }
        
        expTreeView.bind('tree.select', function(e) {
          if (e.node && e.node.cmisdata) {
            var folder = e.node.cmisdata;
            AJS.$('#cmisFolderId').val(folder.id);
            AJS.$('#cmisFolderPath').val(folder.path);
          }
        });

        $("#cmisFolderPath").change(function() {
          // 直接Alfrescoフォルダを編集した場合は cmisFolderId を空にしておく
          AJS.$('#cmisFolderId').val("");
        });

        $("#mapping-folder-edit").submit(function(){

          var cmisFolderId = AJS.$('#cmisFolderId').val();
          var cmisFolderPath = AJS.$('#cmisFolderPath').val();

          if (cmisFolderId && cmisFolderId.length > 0) {
            return true;
          }

          if (cmisFolderPath && cmisFolderPath.length > 0) {

            $("div.error[data-field=path]").addClass("hidden");

            var validFolderPath = false;
            cmisConfluence.getCmisSession().getObjectByPath(cmisFolderPath, null, {async:false}).done(function(object) {

              if (!object.isFolder()) {
                $(".invalid-folder-path").removeClass("hidden");
                return ;
              }

              AJS.$('#cmisFolderId').val(object.id);

              validFolderPath = true;
            }).fail(function(error) {
              $(".invalid-folder-path").removeClass("hidden");
            });

            return validFolderPath;
          }

          return true;
        });

      }).fail(function () {

        $("#mapping-folder-edit").empty();

      });
    
    }

    function rendarFolderPath(container) {

      var folderIds = []
      $('[folder-id]', container).each(function() {
        var folderIdElement = $(this);
        var folderId = folderIdElement.attr('folder-id');
        if (folderId) {
          cmisConfluence.getCmisSession().getObject(folderId).done(function(folder) {
            folderIdElement.html(folder.path);
          }).fail(function(error) {
            errorHandler.showError(folderIdElement.empty(), { body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.folder') + folderId, error: error });
          });
        }
      });

    };

    function rendarTree(container) {

      var d = new AJS.$.Deferred;

      (function() {

        var d = new AJS.$.Deferred;

        cmisConfluence.getCmisSession().getObjectByPath("/").done(function(folder) {
          folder.formatter = function(obj) {
            return {label:AJS.I18n.getText('alfresco.for.confluence.admin.mapping-folder.repository'), id:obj.id, cmisdata:obj};
          };
          d.resolve(folder);
        }).fail(function(error) {
          errorHandler.showError(container, { body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.folder'), error: error });
          d.reject();
        });

        return d.promise();

      })().pipe(function(folder) {

        var expTreeView = treeview.setup({
          cmis_session:cmisConfluence.getCmisSession(),
          el:container,
          rootFolder: [ folder ],
          folderOnly: true,
          allowFolderSelect: true,
          tooltip: false,
          collapsed: false,
          resizable: false
        }).setWidth('100%');

        d.resolve(expTreeView);

      });

      return d.promise();

    };
    
    function initSession() {
      
      var d = new AJS.$.Deferred;

      $("." + MESSAGE_CLASS, "." + CONTAINER_CLASS).empty();

      cmisConfluence.initCmisSession(dummy).done(function() {
        // 最大ログイン試行回数を超えた場合はユーザーにログイン確認とリセットを促す
        if (cmisConfluence.isLimitMaximumLoginAttemptAllowed() && cmisConfluence.isOverMaximumLoginAttemptAllowed()) {
          // 認証エラー
          errorHandler.showError($("." + MESSAGE_CLASS, "." + CONTAINER_CLASS), {
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.reset-failed-login-count', cmisConfluence.getAdminCredentialUrl())
          });
          d.reject();
        } else {
          d.resolve(cmisConfluence.getCmisSession());
        }
      }).fail(function(error) {
        errorHandler.showError($("." + MESSAGE_CLASS, "." + CONTAINER_CLASS), {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.session'),
          error: error
        });
        d.reject();
      });
      
      return d.promise();
      
    }

  });
});
