/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/cmislistview', ['jquery', 'misc/Size', 'misc/BlobUtil', 'cmis/cmissearchfilter', 'cmis/cmisuploader', 'cmis/cmispreview', 'cmis/cmisversion', 'cmis/cmiscreate', 'cmis/cmisremove', 'cmis/cmisproperty', 'cmis/cmischeckout', 'cmis/cmischeckin', 'cmis/cmislink', 'cmis/cmisconfluence', 'sharedlinks/sharedlinks', 'cmis/confluence-error-handler', 'attachments/attachment-permission'],
    function($, miscSize, blobUtil, searchfilter, uploader, preview, version, create, remove, property, checkout, checkin, link, cmisConfluence, sharedlinks, errorHandler, attachmentPermission) {
  
  var PLUGIN_KEY = 'jp.ricksoft.plugins.alfresco-for-confluence';
  var RESOURCE_KEY = 'cmislistview-resources';
  var LISTVIEW_FRAME_CLASS = 'cmis-listview-frame';
  var LISTVIEW_CLASS = 'cmis-listview';
  var LISTOUTER_CLASS = 'list-outer';
  var FOLDERINFO_CLASS = 'folder-info'
  var LOADING_CLASS = 'loading-documents';
  var NODOCUMENTS_CLASS = 'no-documents';
  var DRAGZONE_CLASS = 'drag-zone';
  var HIDDEN_CLASS = 'hidden';
  var DRAGINFO_CLASS = 'dragover-info';
  var PAGINATION_CLASS = 'cmis-pagination';
  var TOOLTIP_INFO_CLASS = '.folder-browseup';
  var TOOLTIP_LIST_CLASS = '.detail-link, .addfavorite, .delfavorite, .sharedlinks';
  var MAX_ITEM_PER_PAGE = 10;

  var RANDOM_ARRAY = [0,1,2,3,4,5,6,7,8,9];
  var RANDOM_NUM = 10;



  function CmisListViewHelper() {  
  }
  CmisListViewHelper.prototype.link = function(documents){};
  CmisListViewHelper.prototype.unlink = function(docunents){};
  
  // TODO 適切な場所へ移動...
  $.extend({
    sequence: function() {
      var tasks = Array.prototype.slice.call(arguments),
          d = $.Deferred(),
          p = d.promise();
      $.each(tasks, function(i, task) {
        p = p.pipe(task);
      });
      d.resolve();
      return p;
    }
  });

  /**
   * 乱数生成
   * @param array
   * @param num
   * @returns {Array}
   */
  // TODO 他の場所でも使用するようならmisc配下へ...
  function random(array, num) {
    var a = array;
    var t = {};
    var r = [];
    var l = a.length;
    var n = num < l ? num : l;
    while (n-- > 0) {
      var i = Math.random() * l | 0;
      r[n] = t[i] || a[i];
      --l;
      t[i] = t[l] || a[l];
    }
    return r;
  }

  function getRandom() {
    return random(RANDOM_ARRAY, RANDOM_NUM).join('');
  }

  
  /**
   * コンストラクタ
   */
  function CmisListView(options) {
    var self = this;
    this.cmis_session = options.cmis_session;
    this.el = options.el;
    this.style_ = options.style || 'list'; // 表示スタイル(list,icon)
    this.rootFolder = options.rootFolder;
    this.currentFolder_ = options.rootFolder;
    this.searchKeyword_ = options.searchKeyword || "";
    this.sortColumn_ = options.sortColumn || "cmis:creationDate";
    this.sortOrder_ = options.sortOrder || "DESC";
    this.helper_ = options.helper || new CmisListViewHelper();
    this.permissions = options.permissions
    this.displays = options.displays || { thumbnail: true, wide: true };
    this.linkObject_ = options.links || [];
    this.alfrescoUrl = options.alfrescoUrl;
    this.linkOnlyMode = options.linkOnlyMode;
    this.autoReloadMode_ = options.autoReloadMode;
    this.selectable_ = options.selectable || false; // ドキュメントの選択可否
    this.dateformat_ = options.dateformat;
    
    var nullFunction = function(){};
    
    this.onLink_ = options.onLink || nullFunction;
    this.onUnlink_ = options.onUnlink || nullFunction;
    this.onRemove_ = options.onRemove || nullFunction;
    this.onPreUpload_ = options.onPreUpload || nullFunction;  // アップロード前イベント
    this.onUpload_ = options.onUpload || nullFunction;
    this.onQuickSearch_ = options.onQuickSearch || nullFunction;
    this.onRenderList_ = options.onRenderList || nullFunction;
    this.onRenderItem_ = options.onRenderItem || nullFunction;
    this.onFolderCreate_ = options.onFolderCreate || nullFunction;
    this.onFolderRemove_ = options.onFolderRemove || nullFunction;
    this.onFolderSelected_ = options.onFolderSelected || nullFunction;
    this.onSelect_ = options.onSelect || nullFunction;
    this.onDeselect_ = options.onDeselect || nullFunction;
    
    // ページング用
    this.pageNum_ = 0;
    this.numItems_ = 0;
    
    this.stalkerDefaultPosition_ = $('#stalker').length > 0 ? Math.ceil($('#stalker').offset().top) : 0;

    // 検索フィルターの初期化
    this.searchFilterModule = searchfilter.setup(function(e, searchKeyword, pattern) {
      e.data = self.getCurrentFolder();
      $.proxy(self._doQuickSearch, self)(e);
      return false;
    });

    this._init();
  }

  CmisListView.prototype.EVENT_RENDERED_DOCUMENT = "connector.rendered.document";
  
  /**
   * 現在表示中のフォルダ
   */
  CmisListView.prototype.currentFolder_ = undefined;
  
  /**
   * リンク済みドキュメントID一覧
   */
  CmisListView.prototype.linkedIds_ = [];

  /**
   * 選択中のドキュメントID一覧
   */
  CmisListView.prototype.selectedDocuments_ = [];
  
  /**
   * 初期化処理
   */
  CmisListView.prototype._init = function() {
    var template = JIRA.Templates.cmislistview.frame({style:this.style_,selectable:this.selectable_});
    if (this.el.find('.' + LISTVIEW_FRAME_CLASS).length == 0) {
      this.el.append(template);
    }
  }
  
  /**
   * アップロードの初期化処理
   */
  CmisListView.prototype.initUpload = function() {
    var innerFlag = false,
        frameEl = this.el.find('.'+LISTOUTER_CLASS),
        self = this;

    var onUpload = function (files) {

      (function () {

        var d = new AJS.$.Deferred;

        uploader.upload({
          cmis_session: self.cmis_session,
          uploadFolder: self.getCurrentFolder(),
          uploadFiles: files
        }).done(function (docs) {
          d.resolve(docs);
        });

        return d.promise();

      })().pipe(function (docs) {

        var d = new AJS.$.Deferred;

        // 課題キーがなければリンクを追加しない(プロジェクトビュー)
        if (!cmisConfluence.getPageId()) {
          d.resolve(docs);
          return d.promise();
        }

        // リンクを追加
        cmisConfluence.addLinksByPage(docs, cmisConfluence.getPageId()).done(function (data) {

          $.each(docs, function (doc) {

            var objectId = doc.versionSeriesId;

            var links = self.formatLinks(data.links);

            // リンク済みリストを更新
            self.putLinkObject(objectId, links[objectId]);

          });

          d.resolve(docs, data.links);

        });

        return d.promise();

      }).pipe(function (docs, links) {

        //再描画
        if (self.autoReloadMode_) {
          self.reload();
        }

        // イベントを飛ばす
        self.onUpload_.apply(null, [docs, self]);

      });

    }
    
    frameEl.find('.folder-info-center').removeClass(HIDDEN_CLASS);
    frameEl.removeClass('droppable');
    frameEl.removeClass(DRAGZONE_CLASS);
    
    var folder = self.getCurrentFolder();
    var obj = $.extend(true, {}, 
      {id:folder.id, label:folder.name, cmisdata:folder, actions:cmisConfluence.getItemActions(folder)}, 
      (folder.formatter && typeof folder.formatter === 'function') ? folder.formatter(folder) : {}
    );

    attachmentPermission.setToolOperations(obj, folder, self.permissions).done(function (actions) {

      if (!actions.operations.document_upload) {
        return;
      }

      // ドラッグオーバーメッセージ追加
      self.setDragoverMessage(obj);

      frameEl.addClass('droppable');
      frameEl.addClass(DRAGZONE_CLASS);

      frameEl.unbind();
      frameEl.bind('drop', function (e) {
        e.preventDefault();
        if (!$(e.currentTarget).hasClass(DRAGZONE_CLASS)) {
          return false;
        }
        var files = e.originalEvent.dataTransfer.files;
        onUpload(files);
        frameEl.removeClass('dragover');
        e.originalEvent.dataTransfer.dropEffect = "";
        return false;
      }).bind('dragenter', function (e) {
        innerFlag = true;
        return false;
      }).bind('dragleave', function (e) {
        if (innerFlag) {
          innerFlag = false;
        } else {
          frameEl.removeClass('dragover');
          if (e.originalEvent !== undefined) {
            e.originalEvent.dataTransfer.dropEffect = "";
          }
        }
        return false;
      }).bind('dragover', function (e) {
        e.preventDefault();
        if (!frameEl.hasClass(DRAGZONE_CLASS)) {
          return true;
        }
        //フラグを上書きする
        innerFlag = false;
        //クラスをセット
        frameEl.addClass('dragover');
        e.originalEvent.dataTransfer.dropEffect = "copy";
        return false;
      }).on('change', '.selectFiles', function () {
        onUpload(this.files);
      });

      frameEl.mousetip({el: $('.dragover-info', frameEl)});

    });
    
  }
  
  $.fn.mousetip = function(options) {
    
    var $this = $(this);
    var $defaults = $.extend({
      x: null,
      y: null,
      el: null,
      title: null,
      css: {
        'position': 'absolute',
        'z-index': '1',
        'display': 'none',
        'background': 'white',
        'border': '3px solid #f79232',
        'border-radius': '5px',
        'padding': '10px 10px 10px 10px',
        'text-align': 'center',
        'right': '40%',
        'left': '40%',
        'top': '10px',
        'color': '#333333'
      }
    }, options);
    var $tip = $('#alfresco-attachments-panel .list-outer.droppable.drag-zone');
    
    if ($defaults.title) {
      $tip.html($defaults.title);
    }
    
    $this.bind('dragover', function(e) {
      //$tip.removeClass('hidden').show();
    }).bind('dragleave', function(e) {
      //$tip.addClass('hidden').hide();
    }).bind('drop', function(e) {
      //$tip.addClass('hidden').hide();
    });
    
    return $tip;
    
  };

  CmisListView.prototype.formatLinks = function (linkObject) {
    var self = this;
    var transformed = {};
    for (var objectId in linkObject) {
      var links = linkObject[objectId];
      transformed[objectId] = $.map(links, function (link, index) {
        return $.extend(link, {
          'created': self.dateformat_ ? moment(new Date(link.created)).format(self.dateformat_) : new Date(link.created),
        });
      });
    }
    return transformed;
  }

  CmisListView.prototype.getLinkObject = function () {
    return this.linkObject_;
  }

  CmisListView.prototype.setLinkObject = function (links) {
    this.linkObject_ = this.formatLinks(links);
  }

  CmisListView.prototype.putLinkObject = function (objectId, links) {
    this.linkObject_[objectId] = links;
  }

  CmisListView.prototype.getLinkObjectKeys = function () {
    return $.map(this.linkObject_, function (links, objectId) {
      return objectId;
    });
  }

  CmisListView.prototype.getLinkObjectValues = function (objectId) {
    var links = this.linkObject_[objectId];
    if (!links) {
      return [];
    }
    return links;
  }

  CmisListView.prototype.getLinkObjectPageId = function (objectId) {
    return $.map(this.getLinkObjectValues(objectId), function (linkObjectValue) {
      return linkObjectValue.pageId;
    });
  }

  /**
   * エクスプローラモードか否か
   */
  CmisListView.prototype.isExplorerMode = function() {
    return this.explorerMode == true;
  }
  
  CmisListView.prototype.setLinkedIds = function(ids) {
    this.linkedIds_ = ids;
  }
  
  CmisListView.prototype.getLinkedIds = function() {
    return this.linkedIds_;
  }
  
  CmisListView.prototype.getCurrentFolder = function() {
    return this.currentFolder_;
  }
  
  CmisListView.prototype.setCurrentFolder = function(currentFolder) {
    this.currentFolder_ = currentFolder;
  }
  
  CmisListView.prototype.getFrameElement = function() {
    return this.el.find('.'+LISTVIEW_FRAME_CLASS);
  }
  
  CmisListView.prototype.getListElement = function() {
    return this.el.find('.'+LISTVIEW_CLASS);
  }
  
  CmisListView.prototype.getLoadingElement = function() {
    return this.el.find('.'+LOADING_CLASS);
  }

  CmisListView.prototype.setPermissions = function(permissions) {
    this.permissions = permissions;
  }
  
  CmisListView.prototype.selectDocument = function(id) {
    var self = this,
        contents = this.el.find('.attachement-content');
    for (var i = 0; i < contents.length; i++) {
      var dom = contents.get(i);
      var doc = $.data(dom, 'cmis-doc');
      if (doc && doc.id == id) {
        self.selectDocument_($(dom), doc);
      }
    }
  }
  
  CmisListView.prototype.setPageNum = function(pageNum) {
    this.pageNum_ = pageNum;
  }

  /**
   * ドキュメントを非選択状態にする
   * @param $el
   * @param doc
   * @private
   */
  CmisListView.prototype.deselectDocument_ = function($el, doc) {
    var self = this;

    $el.removeClass('selected');

    if ($.inArray(doc.id, self.selectedDocuments_) == -1) {
      return ;
    }

    self.selectedDocuments_ = $.grep(self.selectedDocuments_, function(id) {
      return id !== doc.id;
    });

    // 選択解除イベントを飛ばす
    self.onDeselect_.apply(null, [doc, self]);
  }

  /**
   * ドキュメントを選択状態にする
   * @param $el
   * @param doc
   * @private
   */
  CmisListView.prototype.selectDocument_ = function($el, doc) {
    var self = this;
    
    $el.addClass('selected');

    if ($.inArray(doc.id, self.selectedDocuments_) >= 0) {
      return ;
    }

    self.selectedDocuments_.push(doc.id);

    // 選択イベントを飛ばす
    self.onSelect_.apply(null, [doc, self]);
  }
  
  /**
   * 選択されているドキュメント一覧を取得します
   */
  CmisListView.prototype.getSelectedDocuments = function() {
    // var $selectedList = this.el.find('.attachement-content.selected'),
    //     result = [],
    //     doc;
    // for (var i = 0; i < $selectedList.length; i++) {
    //   doc = $($selectedList[i]).data('cmis-doc');
    //   if (doc) {
    //     result.push(doc);
    //   }
    // }
    // return result;
    return this.selectedDocuments_;
  }

  CmisListView.prototype.setPageNum = function (pageNum) {
    this.pageNum_ = pageNum;
  }

  CmisListView.prototype.getSearchKeyword = function () {
    return this.searchFilterModule.lastSearch;
  }

  CmisListView.prototype.getSortColumn = function () {
    return this.sortColumn_;
  }

  CmisListView.prototype.getSortOrder = function () {
    return this.sortOrder_;
  }

  /**
   * CmisFolderからファイル一覧の読み込み
   */
  CmisListView.prototype.loadByFolder = function(cmisFolder) {
    var d = new $.Deferred;
    var self = this;
    
    // 一覧をクリア
    self.clear();
    
    self.getLoadingElement().removeClass(HIDDEN_CLASS);

    var orderby_column = self.sortColumn_;
    var orderby_order = self.sortOrder_;
    var orderby = (orderby_column && orderby_order) ? orderby_column + " " + orderby_order : 'cmis:baseTypeId DESC, cmis:name ASC';
    var options = {
        'orderBy': orderby,
        'maxItems': MAX_ITEM_PER_PAGE, 
        'skipCount': self.pageNum_ * MAX_ITEM_PER_PAGE,
        'includeAllowableActions': true
    };
    cmisFolder.getChildren(options).then(function(items, hasMoreItems, numItems) {
      self.numItems_ = numItems ? numItems : items.length;
      self.loadByArray(items);
      d.resolve();
    }, function(error) {
      errorHandler.showError($(".messages", self.el), {
        body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.listview.render'),
        error: error
      });
      d.reject();
    }).always(function() {
      self.getLoadingElement().addClass(HIDDEN_CLASS);
    });

    return d.promise();
  }
  
  /**
   * CmisDocumentの一覧から読み込み
   */
  CmisListView.prototype.loadByArray = function(cmisObjects) {
    var d = new $.Deferred;
    var self = this;

    (function () {

      var d = new AJS.$.Deferred;

      // ツールチップを破棄
      try { AJS.$(TOOLTIP_LIST_CLASS, self.getListElement()).tooltip('destroy'); } catch(e) {};

      // 一覧をクリア
      self.clear();

      // メッセージの表示
      if (cmisObjects.length > 0) {
        self.el.find("." + LISTVIEW_CLASS).removeClass(HIDDEN_CLASS);
        self.el.find('.no-documents-message').addClass(HIDDEN_CLASS);
      } else {
        self.getLoadingElement().addClass(HIDDEN_CLASS);
        self.el.find('.no-documents-message').removeClass(HIDDEN_CLASS);
      }

      // ページングの表示
      self.reloadPagination(self);

      var docs = $.grep(cmisObjects, function (cmisObject) {
        return cmisObject.isDocument() || cmisObject.isDocumentLink();
      });

      if (!docs || docs.length == 0) {
        d.resolve([]);
        return d.promise();
      }

      var links = cmisConfluence.getLinkByDocuments(docs).done(function (data) {
        self.setLinkObject(data.links);
        d.resolve(data.links);
      }).fail(function (error) {
        errorHandler.showError($(".messages", self.el), {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.listview.render'),
          error: error
        });
        d.reject();
      });

      return d.promise();

    })().pipe(function () {

      var d = new AJS.$.Deferred,
        versionSeriesIds = [];

      if (!self.permissions.document_sharedlinks) {
        return d.resolve([]).promise();
      }

      $.each(cmisObjects, function (i, cmisObject) {
        if (cmisObject.baseTypeId != 'cmis:document') {
          return ;
        }
        versionSeriesIds.push(cmisObject.versionSeriesId);
      });

      if (versionSeriesIds.length <= 0) {
        return d.resolve([]).promise();
      }

      self.cmis_session.getShareds(versionSeriesIds).done(function (shareds) {

        d.resolve(shareds);

      }).fail(function (error) {
        errorHandler.showError($(".messages", self.el), {
          body: AJS.I18n.getText('alfresco.for.jira.ajax.error.listview.getsharedlinks'),
          error: error
        });
        d.reject();
      });

      return d.promise();

    }).pipe(function (shareds) {

      // Defferredの影響など遅延処理から一覧で描画される順序を守るために予め行の要素を追加しておく
      var listElement = self.getListElement();
      $.each(cmisObjects, function (i, cmisObject) {
        var renderId = !cmisObject.isLink() ? cmisObject.id : cmisObject.destination;
        if (listElement.find("tr[id = '" + renderId + "']").length == 0) {
          listElement.append("<tr id = '" + renderId + "'/ >");
        }
      });


      //
      $.each(cmisObjects, function (i, cmisObject) {
        $.each(shareds, function (j, shared) {
          if (cmisObject.id == shared.id) {
            cmisObject.shared = shared;
          }
        });
      });

      // ドキュメント、フォルダごとに描画処理のDeferredを生成(描画される情報の順序を守るため)
      var deferreds = [];
      $.each(cmisObjects, function (i, cmisObject) {
        if (cmisObject.baseTypeId == 'cmis:document') {
          // ドキュメントの情報を描画
          deferreds.push($.proxy(self._renderDocument, self, cmisObject));
        }
        if (cmisObject.baseTypeId == 'cmis:folder') {
          // フォルダの情報を描画
          deferreds.push($.proxy(self._renderFolder, self, cmisObject));
        }
        if (cmisObject.isLink()) {
          // リンクの情報を描画
          deferreds.push($.proxy(self._renderLink, self, cmisObject));
        }
      });

      // ドキュメント、フォルダの情報を描画
      $.sequence.apply($, deferreds).done(function () {
        d.resolve();
      }).fail(function (error) {
        errorHandler.showError($(".messages", self.el), {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.listview.render'),
          error: error
        });
        d.reject();
      });

    }).always(function () {

      // ツールチップを設定
      AJS.$(TOOLTIP_LIST_CLASS, self.getListElement()).tooltip({gravity: 'sw'});

      // イベントを飛ばす
      self.onRenderList_.apply(null, [self]);

      self.getLoadingElement().addClass(HIDDEN_CLASS);

    });

    return d.promise();
  }
  
  CmisListView.prototype.reloadPagination = function(self) {
    self.el.find('.'+PAGINATION_CLASS).empty();
    if (!self.numItems_ || self.numItems_ === 0) {
      return;
    }
    var start = self.pageNum_ - 4 >= 0 ? self.pageNum_ - 4 : 0;
    var totalPage = Math.ceil(self.numItems_/MAX_ITEM_PER_PAGE);
    var end = totalPage >= self.pageNum_ + 5 ? self.pageNum_ + 5 : totalPage;
    var enableNext = self.pageNum_ + 1 < totalPage;
    var startNum = self.numItems_ === 0 ? 0 : self.pageNum_ * MAX_ITEM_PER_PAGE + 1;
    var endNum = enableNext ? startNum + MAX_ITEM_PER_PAGE - 1: self.numItems_;
    
    var template = JIRA.Templates.cmislistview.pagination({
        'startPage': start,
        'endPage': end,
        'currentPage': self.pageNum_,
        'enablePrev': self.pageNum_ > 0,
        'enableNext': enableNext,
        'totalNum': Number(self.numItems_).toLocaleString(),
        'startNum': startNum,
        'endNum': endNum
    });
    self.el.find('.'+PAGINATION_CLASS).html($(template));
    
    self.el.find('.'+PAGINATION_CLASS).find('a').on('click', function(e) {
      e.preventDefault();
      self.pageNum_ = Number($(this).attr('data-page'));
      self.reload();
    });
  }

  CmisListView.prototype.getDocumentByPage = function () {
    var self = this;
    var d = new AJS.$.Deferred;
    var options = {
      'maxItems': MAX_ITEM_PER_PAGE,
      'skipCount': self.pageNum_ * MAX_ITEM_PER_PAGE
    };
    cmisConfluence.getObjectIdByPage(cmisConfluence.getPageId(), options).pipe(function(data) {
      var d = new AJS.$.Deferred;
      var objectIds = data.results;
      cmisConfluence.getDocumentByIds(objectIds).done(function(docs) {
        d.resolve(objectIds, docs, data.hasMoreItems, data.size);
      }).fail(function(error) {
        d.reject(error);
      });
      return d.promise();
    }).done(function(objectIds, docs, hasMoreItems, size) {
      // APIで取得したリンク作成日の順序に並べ替えして返す
      d.resolve($.map(objectIds, function(objectId) {
        return $.grep(docs, function(doc) {
          return objectId === doc.versionSeriesId;
        });
      }), hasMoreItems, size);
    }).fail(function(error) {
      d.reject(error);
    });
    return d.promise();
  }

  /**
   * クイック検索
   */
  CmisListView.prototype.quickSearch = function (cmisFolders, keyword, orderby_column, orderby_order) {
    var self = this;
    var orderby = (orderby_order && orderby_column) ? orderby_column + " " + orderby_order : 'cmis:baseTypeId DESC, cmis:name ASC';
    var options = {
      'orderBy': orderby,
      'maxItems': MAX_ITEM_PER_PAGE,
      'skipCount': self.pageNum_ * MAX_ITEM_PER_PAGE,
      'includeAllowableActions': true
    };
    return self.cmis_session.queryInTrees(cmisFolders, keyword, options);
  }

  /**
   * 編集中検索
   */
  CmisListView.prototype.editingSearch = function (cmisFolders, keyword, orderby_column, orderby_order) {
    var self = this;
    var orderby = (orderby_order && orderby_column) ? orderby_column + " " + orderby_order : 'cmis:baseTypeId DESC, cmis:name ASC';
    var options = {
      'orderBy': orderby,
      'maxItems': MAX_ITEM_PER_PAGE,
      'skipCount': self.pageNum_ * MAX_ITEM_PER_PAGE,
      'includeAllowableActions': true
    };
    return self.cmis_session.editingInTrees(cmisFolders, keyword, options);
  }

  /**
   * 編集中検索
   */
  CmisListView.prototype.recentlyInTrees = function (cmisFolders, keyword, column, orderby_column, orderby_order) {
    var self = this;
    var orderby = (orderby_order && orderby_column) ? orderby_column + " " + orderby_order : 'cmis:baseTypeId DESC, cmis:name ASC';
    var options = {
      'orderBy': orderby,
      'maxItems': MAX_ITEM_PER_PAGE,
      'skipCount': self.pageNum_ * MAX_ITEM_PER_PAGE,
      'includeAllowableActions': true
    };
    return self.cmis_session.recentlyInTrees(cmisFolders, keyword, column, options);
  }

  /**
   * 再読み込み
   */
  CmisListView.prototype.reload = function() {
    return this.loadByFolder(this.getCurrentFolder());
  }
  
  /**
   * 一覧のクリア
   */
  CmisListView.prototype.clear = function() {
    this.getListElement().empty().addClass(HIDDEN_CLASS);
    this.el.find('.'+PAGINATION_CLASS).empty();
    //this.el.find("."+NODOCUMENTS_CLASS).addClass(HIDDEN_CLASS);
  }

  /**
   *
   */
  CmisListView.prototype.on = function (event, fn) {
    this.el.on.apply(this.el, arguments);
  }

  /**
   *
   */
  CmisListView.prototype.one = function (event, fn) {
    this.el.one.apply(this.el, arguments);
  }

  /**
   *
   */
  CmisListView.prototype.off = function (event, fn) {
    this.el.off.apply(this.el, arguments);
  }

  CmisListView.prototype.renderFolderInfoParams = function (folder) {
    var obj = $.extend(true, {},
      {
        id: folder.id,
        label: folder.name,
        cmisdata: folder,
        searchKeyword: this.getSearchKeyword(),
        sortColumn: this.getSortColumn(),
        sortOrder: this.getSortOrder(),
        randomId: getRandom(),
        browseUp: folder.root !== undefined && folder.root === false
      },
      (folder.formatter && typeof folder.formatter === 'function') ? folder.formatter(folder) : {}
    );
    return attachmentPermission.setToolOperations(obj, folder, merge(this.permissions, obj.actions));

    function merge(permissions, actions) {
      var result = {};
      for (var key in permissions) {
        if (actions.hasOwnProperty(key)) {
          result[key] = permissions[key] && actions[key];
        } else {
          result[key] = permissions[key];
        }
      }

      for (var key in actions) {
        if (!permissions.hasOwnProperty(key)) {
          result[key] = actions[key];
        }
      }
      return result;
    }
  }

  /**
   * フォルダの情報や操作ツールを表示
   */
  CmisListView.prototype.renderFolderInfo = function(folder) {
    var self = this;
    self.renderFolderInfoParams(folder).done(function(param) {

      var template = JIRA.Templates.cmislistview.folderInfo(param);
      var el = self.el.find('.' + FOLDERINFO_CLASS);

      // ツールチップを破棄
      AJS.$(TOOLTIP_INFO_CLASS, el).tooltip('destroy').tooltip({gravity: 'sw'});

      el.empty().append(template);
      el.removeClass(HIDDEN_CLASS);

      if (folder) {
        self.currentFolder_ = folder;
      }

      self.searchFilterModule.render(el, el.find(".cmis-file-search-frame"), param.searchKeyword);

      el.find("#cmis-sort").on({
        "aui-dropdown2-item-check": function (e) {
          if ($(e.target).hasClass("sort-order")) {
            self.sortOrder_ = $(e.target).attr("id");
          }
          if ($(e.target).hasClass("sort-column")) {
            self.sortColumn_ = $(e.target).attr("id");
          }
          e.data = self.getCurrentFolder();
          $.proxy(self._doQuickSearch, self)(e);
          return false;
        }
      });
      el.find(".folder-create").click(folder, $.proxy(self._doAddFolder, self));
      el.find(".folder-remove").click(folder, $.proxy(self._doRemoveFolder, self));
      el.find(".folder-browseup").click(folder.parentId, $.proxy(self._onFolderSelected, self));

      // ツールチップを設定
      AJS.$(TOOLTIP_INFO_CLASS, el).tooltip({gravity: 'sw'});

    });
  }

  CmisListView.prototype._getRenderDocumentParams = function (doc) {
    var self = this;

    return attachmentPermission.setToolOperations({
      username: doc.cmisSession.username,
      id: doc.id,
      baseTypeId: doc.baseTypeId,
      filename: doc.linkObject ? doc.linkObject.name : doc.name,
      description: doc.linkObject ? doc.linkObject.description : doc.description,
      readableFilesize: miscSize.getReadableSizeString(doc.contentStreamLength),
      version: doc.versionLabel,
      lockType: doc.lockType,
      lockOwner: doc.lockOwner,
      workingCopyLabel: doc.workingCopyLabel,
      isPrivateWorkingCopy: doc.isPrivateWorkingCopy,
      versionSeriesCheckedOutBy: doc.versionSeriesCheckedOutBy,
      versionSeriesCheckedOutId: doc.versionSeriesCheckedOutId,
      sharedLink: doc.shared,
      isLinkItem: doc.linkObject ? true : false,
      createdBy: cmisConfluence.getCreatedBy(doc),
      creationDate: this.dateformat_ ? moment(new Date(doc.creationDate)).format(this.dateformat_) : new Date(doc.creationDate),
      lastModificationDate: this.dateformat_ ? moment(new Date(doc.lastModificationDate)).format(this.dateformat_) : new Date(doc.lastModificationDate),
      href: doc.getContentStreamURL(true),
      shareDetailUrl: cmisConfluence.getShareDocumentDetailUrl(doc),
      link: this.getLinkObjectValues(doc.versionSeriesId),
      isLinked: (function(){
        if (cmisConfluence.getPageId()) {
          var linked = false;
          $.each(self.getLinkObjectValues(doc.versionSeriesId), function(i, link) {
            if (link.pageId == cmisConfluence.getPageId()) {
              linked = true;
              return false;
            }
          });
          return linked;
        }
        if (cmisConfluence.getSpaceId()) {
          var linked = false;
          $.each(self.getLinkObjectValues(doc.versionSeriesId), function(i, link) {
            if (link.spaceId == cmisConfluence.getSpaceId()) {
              linked = true;
              return false;
            }
          });
          return linked;
        }
      })(),
      canOnlineEdit: checkout.canOnlineEdit(doc),
      selectable: this.selectable_,
      selected: $.inArray(doc.id, this.selectedDocuments_) !== -1,
      displays: this.displays,
      randomId: doc.id + "_" + getRandom()
    }, doc, this.permissions);
  }

  CmisListView.prototype._renderDocument = function(doc) {

    var d = new $.Deferred;
    var self = this;
    self._getRenderDocumentParams(doc).done(function (param) {

      var template;
      var thumbnails = self.getListElement();

      if (self.style_ == 'list') {
        template = $(JIRA.Templates.cmislistview.thumbnail(param));
      } else if (self.style_ == 'icon') {
        template = $(JIRA.Templates.cmislistview.icon(param));
      }

      if (!doc.isLink() && thumbnails.find("tr[id = '" + doc.id + "'],tr[id = '" + doc.versionSeriesId + "']").length > 0) {
        thumbnails.find("tr[id = '" + doc.id + "'],tr[id = '" + doc.versionSeriesId + "']").replaceWith(template);
      } else {
        thumbnails.append(template);
      }

      template.find("img").error(function () {
        $(this).attr('src', self.getNoImage());
      });

      // 操作メニューがなければボタンを非表示にする
      if ($("div[id='cmis-acts-" + param.randomId + "']").find("li.action:not(.hidden)").length == 0) {
        $("div[id='cmis-acts-" + param.randomId + "']").remove();
        $("a[id='cmis-act-trigger-" + param.randomId + "']").remove();
      }

      // イベントを飛ばす
      self.onRenderItem_.apply(null, [template, doc, self]);

      template.find(".onlineedit").click(doc, $.proxy(self._doOnlineEdit, self));
      template.find(".download").click(doc, $.proxy(self._doDownload, self));
      template.find(".version").click(doc, $.proxy(self._doVersion, self));
      template.find(".remove").click(doc, $.proxy(self._doRemoveDocument, self));
      template.find(".link").click(doc, $.proxy(self._doLink, self));
      template.find(".unlink").click(doc, $.proxy(self._doUnlink, self));
      template.find(".addfavorite").click(doc, $.proxy(self._doFavorite, self));
      template.find(".delfavorite").click(doc, $.proxy(self._doUnfavorite, self));
      template.find(".sharedlinks.shared").click([doc, template], $.proxy(self._doShowSharedDialog, self));
      template.find(".sharedlinks.share").click([doc, template], $.proxy(self._doShowShareDialog, self));
      template.find(".property").click(doc, $.proxy(self._doProperty, self));
      //template.find(".pushproperty").click(doc, $.proxy(self._doPushProperty, self));
      //template.find(".pullproperty").click(doc, $.proxy(self._doPullProperty, self));
      //template.find(".createissue").click(doc, $.proxy(self._doCreateIssue, self));
      template.find(".newversion").click(doc, $.proxy(self._doNewVersion, self));
      template.find(".editonline").click(doc, $.proxy(self._doEditOnline, self));
      template.find(".editoffline").click(doc, $.proxy(self._doEditOffline, self));
      template.find(".canceledit").click(doc, $.proxy(self._doCancelEditing, self));
      template.find(".linked:not(.hidden)").click(doc, $.proxy(self._doShowLinks, self));

      if (self.selectable_) {
        template.click({doc: doc, el: template}, $.proxy(self._doSelect, self));
      }

      // お気に入りの状態を取得
      cmisConfluence.getFavorite(doc.versionSeriesId).done(function (favorite) {
        if (favorite) {
          template.find(".delfavorite").removeClass(HIDDEN_CLASS);
        } else {
          template.find(".addfavorite").removeClass(HIDDEN_CLASS);
        }
      }).fail(function (error) {
        errorHandler.showError($(".messages", self.el), {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.listview.getfavorite'),
          error: error
        });
      });

      // サムネイルを取得
      doc.getThumbnail().pipe($.proxy(self._getPreviewLink, self)).done(function (info, data, previewLink, previewType) {
        if (previewLink) {
          template.find("a.filename, a.preview").click({
            'doc': doc,
            'previewType': previewType,
            'previewLink': previewLink
          }, $.proxy(self._doPreview, self));
        } else {
          template.find("a.preview").remove();
        }
        if (info && data && self.displays.thumbnail) {
          blobUtil.binary2dataURISheme(data, info.mimeType).done(function (dataURIScheme) {
            if (dataURIScheme) {
              template.find(".thumbnail,div.icon-thumbnail").find("img").attr("src", dataURIScheme);
            }
          }).fail(function (error) {
          });
        }
      }).fail(function (error) {
      });

      // イベントを飛ばす
      self.el.trigger(self.EVENT_RENDERED_DOCUMENT, [doc, template, self]);
      self.el.trigger(self.EVENT_RENDERED_DOCUMENT + "_" + doc.id, [doc, template, self]);

    });

    return d.resolve().promise();
  }

  CmisListView.prototype._getRenderFolderParams = function (folder) {
    var self = this;
    return attachmentPermission.setToolOperations({
      username: folder.cmisSession.username,
      id: folder.id,
      baseTypeId: folder.baseTypeId,
      filename: folder.linkObject ? folder.linkObject.name : folder.name,
      description: folder.linkObject ? folder.linkObject.description : folder.description,
      isLinkItem: folder.linkObject ? true : false,
      createdBy: cmisConfluence.getCreatedBy(folder),
      creationDate: this.dateformat_ ? moment(new Date(folder.creationDate)).format(this.dateformat_) : new Date(folder.creationDate),
      lastModificationDate: this.dateformat_ ? moment(new Date(folder.lastModificationDate)).format(this.dateformat_) : new Date(folder.lastModificationDate),
      displays: this.displays
    }, folder, this.permissions);
  }

  CmisListView.prototype._renderFolder = function(folder) {

    var d = new $.Deferred;
    var self = this;

    self._getRenderFolderParams(folder).done(function (param) {

      var template;
      var thumbnails = self.getListElement();

      if (self.style_ == 'list') {
        template = $(JIRA.Templates.cmislistview.thumbnail(param));
      } else if (self.style_ == 'icon') {
        template = $(JIRA.Templates.cmislistview.icon(param));
      }

      if (!folder.isLink() && thumbnails.find("tr[id = '" + folder.id + "']").length > 0) {
        thumbnails.find("tr[id = '" + folder.id + "']").replaceWith(template);
      } else {
        thumbnails.append(template);
      }

      template.find(".thumbnail").css("cursor", "pointer");

      // 操作メニューがなければボタンを非表示にする
      if ($("div[id='cmis-acts-" + param.id + "']").find("li.action:not(.hidden)").length == 0) {
        $("div[id='cmis-acts-" + param.id + "']").remove();
        $("a[id='cmis-act-trigger-" + param.id + "']").remove();
      }

      // イベントを飛ばす
      self.onRenderItem_.apply(null, [folder, self]);

      template.find(".remove").click(folder, $.proxy(self._doRemoveFolder, self));
      template.find(".thumbnail,.icon-thumbnail").click(folder, $.proxy(self._onFolderSelected, self));
      template.find(".foldername").click(folder, $.proxy(self._onFolderSelected, self));
      template.find(".addfavorite").click(folder, $.proxy(self._doFavorite, self));
      template.find(".delfavorite").click(folder, $.proxy(self._doUnfavorite, self));

      // お気に入りの状態を取得
      cmisConfluence.getFavorite(folder.id).done(function (favorite) {
        if (favorite) {
          template.find(".delfavorite").removeClass(HIDDEN_CLASS);
        } else {
          template.find(".addfavorite").removeClass(HIDDEN_CLASS);
        }
      }).fail(function (error) {
        errorHandler.showError($(".messages", self.el), {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.listview.getfavorite'),
          error: error
        });
      });

    });

    return d.resolve().promise();
  }

  CmisListView.prototype._renderLink = function (link) {
    var d = new $.Deferred,
      self = this,
      template = $(JIRA.Templates.cmislistview.linkitem({destination:link.destination})),
      thumbnails = self.getListElement(),
      renderFunction;

    thumbnails.append(template);

    if (link.isDocumentLink()) {
      renderFunction = self._renderDocument;
    } else if (link.isFolderLink()) {
      renderFunction = self._renderFolder;
    }

    link.getDestinationObject(false, {'includeAllowableActions':true}).pipe($.proxy(renderFunction, self)).done(function() {
      d.resolve();
    }).fail(function() {
      d.reject();
    })
    return d.promise();
  }

  CmisListView.prototype._getPreviewLink = function(data, info, doc) {

    var self = this;
    var d = new $.Deferred;
    var cmisSession = doc.cmisSession;
    var property = doc.succinctProperties;
    var nodeRef = doc.nodeRef;
    var mimeType = doc.contentStreamMimeType;

    if (!mimeType) {
      d.resolve(info, data);
    } else if (mimeType.indexOf('video/') === 0 || mimeType.indexOf('audio/') === 0) {
      d.resolve(info, data, self._createMovieURL(nodeRef, property), "movie");
    } else if (mimeType.indexOf('image/') === 0) {
      d.resolve(info, data, self._createThumbnailURL(nodeRef, property), "image");
    } else if ("application/pdf" === mimeType) {
      d.resolve(info, data, doc.getContentStreamURL(), "pdf");
    } else {
      // mimeTypeがpdf,image,video,audio以外の場合は、サムネイル定義を調べる
      $.ajax({
        url: self._createThumbnailDefinitionsURL(nodeRef),
        type: "GET",
        beforeSend: function (xhr) {
          if (cmisSession.authType == 'Basic') {
            xhr.setRequestHeader('Authorization', cmisSession.token);
          }
          if (cmisSession.authType == 'WSSE') {
            xhr.setRequestHeader('X-WSSE', cmisSession.token);
          }
        },
        timeout: 0,
        success: function (definitions) {
          if (!!definitions && definitions.indexOf("pdf") != -1) {
            d.resolve(info, data, self._createThumbnailURL(nodeRef), "pdf");
          } else if (!!definitions && definitions.indexOf("imgpreview") != -1) {
            d.resolve(info, data, self._createThumbnailURL(nodeRef), "image");
          } else {
            d.resolve(info, data);
          }
        },
        error: function () {
          d.resolve(info, data);
        }
      });
    }

    return d.promise();
  }

  // TODO Alfresco依存コード
  CmisListView.prototype._createThumbnailDefinitionsURL = function (node) {
    var api = this.alfrescoUrl + "/service/api";
    var nodeRefAsLink = node.replace(":/", "");

    return api + "/node/" + nodeRefAsLink + "/content/thumbnaildefinitions";
  }

  //TODO Alfresco依存コード
  CmisListView.prototype._createThumbnailURL = function (node) {
    var api = this.alfrescoUrl + "/service/api";
    var nodeRefAsLink = node.replace(":/", "");

    return api + "/node/" + nodeRefAsLink + "/content/thumbnails/pdf?c=force";
  }

  //TODO Alfresco依存コード
  CmisListView.prototype._createMovieURL = function (node, contentStreamFileName) {
    var api = this.alfrescoUrl + "/service/api";
    var nodeRefAsLink = node.replace(":/", "");
    return api + "/node/" + nodeRefAsLink + "/content/" + contentStreamFileName;
  }


  /**
   * ダウンロードを行う
   * @param
   */
  CmisListView.prototype._doDownload = function(e) {
    e.preventDefault();
    
    var doc = e.data;
    doc.download();
    
    return false;
  }
  

  /**
   * プレビューを行う
   * @param
   */
  CmisListView.prototype._doPreview = function(e) {
    var self = this;

    e.preventDefault();
    
    var doc = e.data.doc;
    var previewType = e.data.previewType;
    var previewLink = e.data.previewLink;
    preview.doPreview(doc, previewType, previewLink, self.permissions);
    
    return false;
  }
  
  /**
   * バージョンを行う
   * @param
   */
  CmisListView.prototype._doVersion = function(e) {
    var self = this,
        doc = e.data;
    
    e.preventDefault();
    
    version.doVersion(self, doc, self.dateformat_);
    
    return false;
  }

  /**
   * プロパティー表示・編集
   * @param
   */
  CmisListView.prototype._doProperty = function (e) {
    var self = this,
      doc = e.data;

    e.preventDefault();

    property.doProperty(self, doc, self.dateformat_);
  }

  /**
   * ファイル削除を行う
   * @param
   */
  CmisListView.prototype._doRemoveDocument = function(e) {
    var self = this,
        doc = e.data;

    e.preventDefault();

    (function () {

      var d = new AJS.$.Deferred;

      remove.doRemove(doc).done(function(data) {
        d.resolve(data);
      });

      return d.promise();

    })().pipe(function(data) {

      var d = new AJS.$.Deferred;

      // 課題キーがなければリンクを削除しない(プロジェクトビュー)
      if (!cmisConfluence.getPageId()) {
        d.resolve(data);
        return d.promise();
      }

      // リンクを削除する
      cmisConfluence.removeLinkByObject(doc, cmisConfluence.getPageId()).done(function (data) {

        var objectId = doc.versionSeriesId;

        var links = self.formatLinks(data.links);

        // リンク済みリストを更新
        self.putLinkObject(objectId, links[objectId]);

        d.resolve(data, data.links);

      });

      return d.promise();

    }).pipe(function (data, links) {

      // イベントを飛ばす
      self.onRemove_.apply(null, [doc, self]);

      // 削除したドキュメントの行を削除する
      $(e.target).closest("tr").remove();

      // ページングナビゲーションをリロード
      self.numItems_ -= 1;
      self.reloadPagination(self);

    });
  }

  /**
   * クイック検索を行う
   * @param
   */
  CmisListView.prototype._doQuickSearch = function (e) {
    var self = this,
      folder = e.data;

    e.preventDefault();

    self.loadByFolder(folder).done(function (docs) {
      // イベントを飛ばす
      self.onQuickSearch_.apply(null, [folder, docs, self]);
    });
  }
  
  /**
   * フォルダ追加を行う
   * @param
   */
  CmisListView.prototype._doAddFolder = function(e) {
    var self = this,
        folder = e.data;

    e.preventDefault();

    create.doCreate(folder).done(function(created) {
      
      //再描画
      if (self.autoReloadMode_) {
        self.reload();
      }
      
      // イベントを飛ばす
      self.onFolderCreate_.apply(null, [folder, created, self]);
    });
    return false;
  }
  
  /**
   * フォルダ削除を行う
   * @param
   */
  CmisListView.prototype._doRemoveFolder = function(e) {
    var self = this,
        folder = e.data;

    e.preventDefault();
    
    remove.doRemove(folder).done(function(removed) {
      // イベントを飛ばす
      self.onFolderRemove_.apply(null, [folder, removed, self]);
      
      $(e.target).closest("tr").remove();
      
      // ページングナビゲーションをリロード
      self.numItems_ -= 1;
      self.reloadPagination(self);
    });
    return false;
  }
  
  /**
   * フォルダ選択を行う
   * @param
   */
  CmisListView.prototype._onFolderSelected = function(e) {
    var self = this,
        folder = e.data;

    e.preventDefault();
    
    var current = self.getCurrentFolder();

    // イベントを飛ばす
    self.onFolderSelected_.apply(null, [folder, current, self]);
    
  }
  
  /**
   * リンクを行う
   * @param
   */
  CmisListView.prototype._doLink = function(e) {
    var self = this,
        doc = e.data,
        $el = $(e.currentTarget);

    e.preventDefault();

    // リンクを追加
    link.doLink(self, doc, { dateformat: self.dateformat_ });
  }
  
  /**
   * リンク解除
   * @param
   */
  CmisListView.prototype._doUnlink = function(e) {
    var self = this,
      doc = e.data,
      $el = $(e.currentTarget);

    e.preventDefault();

    // リンクを削除
    link.doUnLink(self, doc, { dateformat: self.dateformat_ });
  }

  /**
   * リンクを表示
   * @param
   */
  CmisListView.prototype._doShowLinks = function (e) {
    var self = this,
      doc = e.data;

    e.preventDefault();

    // リンクを表示
    link.doShowLinks(self, doc, self.dateformat_);

  }

    /**
     * 新規バージョンのアップロード
     * @param
     */
    CmisListView.prototype._doNewVersion = function (e) {
      var self = this,
        doc = e.data,
        $el = $(e.currentTarget);

      e.preventDefault();

      // 新規バージョンのアップロード
      checkin.doNewVersion(self, doc, { dateformat: self.dateformat_ });

    }

    /**
     * オンライン編集を行う
     * @param e
     * @private
     */
    CmisListView.prototype._doEditOnline = function (e) {
      var self = this,
        doc = e.data,
        $el = $(e.currentTarget);

      e.preventDefault();

      // オンライン編集
      checkout.doEditOnline(self, doc, { dateformat: self.dateformat_ });

    }

    /**
     * オフライン編集
     * @param
     */
    CmisListView.prototype._doEditOffline = function (e) {
      var self = this,
        doc = e.data,
        $el = $(e.currentTarget);

      e.preventDefault();

      // オフライン編集
      checkout.doEditOffline(self, doc, { dateformat: self.dateformat_ });

    }

    /**
     * 編集のキャンセル
     * @param
     */
    CmisListView.prototype._doCancelEditing = function (e) {
      var self = this,
        doc = e.data,
        $el = $(e.currentTarget);

      e.preventDefault();

      // 編集のキャンセル
      checkout.doCancelEditing(self, doc, { dateformat: self.dateformat_ });

    }

  /**
   * お気に入り追加
   * @param
   */
  CmisListView.prototype._doFavorite = function (e) {
    var self = this,
      doc = e.data,
      $el = $(e.currentTarget);

    e.preventDefault();

    // リンクファイルを追加
    self.helper_.addFavorite(doc).done(function () {

      $parent = $el.parents('.attachement-content');
      $parent.find('a.delfavorite').removeClass(HIDDEN_CLASS);
      $parent.find('a.addfavorite').addClass(HIDDEN_CLASS);

      // イベントを飛ばす
      self.onFavorite_.apply(null, [doc, self]);
    }).fail(function (error) {
      errorHandler.showError($(".messages", self.el), {
        body: AJS.I18n.getText('alfresco.for.jira.ajax.error.listview.favorite'),
        error: error
      });
    }).always(function () {
    });
  }

  /**
   * お気に入り削除
   * @param
   */
  CmisListView.prototype._doUnfavorite = function (e) {
    var self = this,
      doc = e.data,
      $el = $(e.currentTarget);

    e.preventDefault();

    // お気に入り削除
    self.helper_.delFavorite(doc).done(function (link) {

      $parent = $el.parents('.attachement-content');
      $parent.find('a.addfavorite').removeClass(HIDDEN_CLASS);
      $parent.find('a.delfavorite').addClass(HIDDEN_CLASS);

      // イベントを飛ばす
      self.onUnfavorite_.apply(null, [doc, self]);
    }).fail(function (error) {
      errorHandler.showError($(".messages", self.el), {
        body: AJS.I18n.getText('alfresco.for.jira.ajax.error.listview.unlink'),
        error: error
      });
    }).always(function () {
    });
  }

  /**
   * 選択
   * @param
   */
  CmisListView.prototype._doSelect = function(e) {
    var self = this,
        doc = e.data.doc,
        $el = e.data.el;

    e.preventDefault();
    
    if ($el.hasClass('selected')) {
      self.deselectDocument_($el, doc);
    } else {      
      self.selectDocument_($el, doc);
    }

    return false;
  }

  CmisListView.prototype._doShowSharedDialog = function(e) {
    var self = this,
      doc = e.data[0],
      $el = e.data[1];

    e.preventDefault();

    sharedlinks.showSharedDialog(doc, $el, self);

    return false;
  }

  CmisListView.prototype._doShowShareDialog = function(e) {
    var self = this,
      doc = e.data[0],
      $el = e.data[1];

    sharedlinks.showShareDialog(doc, $el, self);
  }

  /**
   * 規定のフォルダーを取得
   * @return 
   */
  CmisListView.prototype.getRootFolder = function() {
    return this.rootFolder;
  }
  
  /**
   * 規定のフォルダーを設定
   * @param rootFolder
   */
  CmisListView.prototype.setRootFolder = function(rootFolder) {
    return this.rootFolder = rootFolder;
  }
  
  /**
   * 存在しないことを示すイメージを取得
   * @param
   */
  CmisListView.prototype.getNoImage = function(e) {
    return contextPath + "/download/resources/" + PLUGIN_KEY + ":" + RESOURCE_KEY + "/images/noimage.png";
  }

  /**
   * ドラッグオーバー時のメッセージを追加する
   */
  CmisListView.prototype.setDragoverMessage = function (cmisFolder) {
    this.dragoverMessage = AJS.I18n.getText('alfresco.for.confluence.listview.dragover', cmisFolder.label);
  }

  /**
   * フォルダを示すイメージを取得
   * @param
   */
  CmisListView.prototype.getFolderImage = function(e) {
    return contextPath + "/download/resources/" + PLUGIN_KEY + ":" + RESOURCE_KEY + "/images/folder.png";
  }
  
  return {
    /**
     * @param {object} options
     */
    setup: function(options) {
      return new CmisListView(options);
    }
  }
});
