/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/cmischeckout', ['jquery', 'cmis/cmisconfluence', 'cmis/confluence-error-handler', 'attachments/attachment-permission', 'officeservice/officeservice'], function ($, cmisConfluence, errorHandler, attachmentPermission, officeservice) {

  /**
   * オンライン編集を行う
   * @param {CmisListView} invoker
   * @param {CmisDocument} doc
   * @param {string} dateformat
   */
  var doEditOnline = function (invoker, doc, dateformat) {

    // オンライン編集
    officeservice.onActionEditOnlineAos(doc).fail(function(options) {
      errorHandler.showError($(".messages", invoker.el), options);
    });

  }

  /**
   * オフライン編集を行う
   * @param {CmisListView} invoker
   * @param {CmisDocument} doc
   * @param {string} dateformat
   */
  var doEditOffline = function (invoker, doc, dateformat) {

    doc.checkOut().done(function(pwc) {

      pwc.download();

      invoker.reload();

    }).fail(function(error) {

      errorHandler.showError($(".messages", invoker.el), { body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.checkout.checkout'), error: error });

    });

  }

  /**
   * 編集のキャンセルを行う
   * @param {CmisListView} invoker
   * @param {CmisDocument} doc
   * @param {string} dateformat
   */
  var doCancelEditing = function (invoker, doc, dateformat) {

    doc.cancelCheckOut().done(function() {

      invoker.reload();

    }).fail(function(error) {

      errorHandler.showError($(".messages", invoker.el), { body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.checkout.cancelcheckout'), error: error });

    });

  }

  /**
   * オンライン編集が可能か判定を行う
   * @param doc
   * @returns {*}
   */
  var canOnlineEdit = function(doc) {

    return officeservice.canOnlineEdit(doc.name);

  }

  return {
    doEditOnline: doEditOnline,
    doEditOffline: doEditOffline,
    doCancelEditing: doCancelEditing,
    canOnlineEdit : canOnlineEdit,
  }
});
