/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/cmischeckin', ['jquery', 'cmis/cmisconfluence', 'misc/Size', 'misc/BlobUtil', 'cmis/cmisuploader', 'cmis/confluence-error-handler', 'attachments/attachment-permission', 'confluence/message-controller'], function ($, cmisConfluence, miscSize, blobUtil, uploader, errorHandler, attachmentPermission, MessageController) {

  var DIALOG_ID = 'cmischeckin-dialog';
  var DIALOG_SECTION = '<section role="dialog" id="' + DIALOG_ID + '" class="aui-layer aui-dialog2 aui-dialog2-medium loadingInProgress" aria-hidden="true"></section>';
  var HIDDEN_CLASS = 'hidden';
  var LOADING_CLASS = "loading-documents";
  /**
   * チェックインを行う
   * @param {CmisListView} invoker
   * @param {CmisDocument} doc
   * @param {string} dateformat
   */
  var doCheckin = function (invoker, doc, dateformat) {

    if ($('#' + DIALOG_ID).length <= 0) {
      $('body').append(DIALOG_SECTION);
    }

    var ajsDlg = AJS.dialog2("#" + DIALOG_ID);

    render(invoker, $("#" + DIALOG_ID), doc, dateformat);

    ajsDlg.show();

  }

  function render(invoker, context, doc, dateformat) {

    var cmisSession = doc.cmisSession;
    var versionSeriesId = doc.versionSeriesId;

    (function(){

      $("." + LOADING_CLASS, context).removeClass(HIDDEN_CLASS);

      return cmisSession.getObject(versionSeriesId, false, {'includeAllowableActions': true});

    })().pipe(function(originaldoc) {

      var currentVersion = originaldoc.versionLabel;

      var majorVersion = getMajorVersion(currentVersion);

      var minorVersion = getMinorVersion(currentVersion);

      var dialogMethod = cmisConfluence.isGreaterThanOrEqualTo(AJS.version, "9.0") ? 'dialog2' : 'dialog';
      var template = $(JIRA.Templates.cmischeckin[dialogMethod]({
        filename: doc.name,
        version: currentVersion
      }));
      context.empty().append(template);

      var template_frame = $(JIRA.Templates.cmischeckin.frame({
        majorVersion: (majorVersion + 1) + '.' + '0',
        minorVersion: majorVersion + '.' + (minorVersion + 1)
      }));
      $(".checkin-content", context).empty().append(template_frame);

      var template_footer = $(JIRA.Templates.cmischeckin.footer());
      $(".aui-dialog2-footer", context).empty().append(template_footer);

      $("#dialog-submit-button").click(function(e) {

        e.preventDefault();

        AJS.dialog2("#" + DIALOG_ID).hide();

        var uploadButton = $("#upload-button").get(0);

        if (uploadButton.files.length != 1) {
          return;
        }

        upload(invoker, doc, uploadButton.files[0]);

      });

      $("#dialog-cancel-button").click(function(e) {

        e.preventDefault();

        AJS.dialog2("#" + DIALOG_ID).hide();

      });

    }).fail(function() {

      errorHandler.showError($(".messages", "#"+DIALOG_ID), { body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.checkin.render'), error: error });

    }).always(function() {

      $("." + LOADING_CLASS, context).addClass(HIDDEN_CLASS);

    });

    function getMajorVersion(version) { return 'pwc' !== version ? new Number(version.split(".")[0]) : undefined; }
    function getMinorVersion(version) { return 'pwc' !== version ? new Number(version.split(".")[1]) : undefined; }

  }

  function upload(invoker, doc, file) {

    (function () {

      return uploader.upload({
        cmis_session: invoker.cmis_session,
        uploadFolder: invoker.getCurrentFolder(),
        uploadFiles: [file],
        targetFiles: [doc],
        major: $('input[name=version]:checked').attr('id') === 'major'
      });

    })().pipe(function (docs) {

      var d = new AJS.$.Deferred;

      // 課題キーがなければリンクを追加しない(プロジェクトビュー)
      if (!cmisConfluence.getPageId()) {
        d.resolve(docs);
        return d.promise();
      }

      // リンクを追加
      cmisConfluence.addLinksByPage(docs, cmisConfluence.getPageId()).done(function (data) {

        $.each(docs, function(doc) {

          var objectId = doc.versionSeriesId;

          var links = invoker.formatLinks(data.links);

          // リンク済みリストを更新
          invoker.putLinkObject(objectId, links[objectId]);

        }).fail(function (jqXhr) {
          MessageController.showError(MessageController.parseError(jqXhr), MessageController.Location.FLAG);
        });

        d.resolve(docs, data.links);

      });

      return d.promise();

    }).pipe(function (docs, links) {

      //再描画
      if (invoker.autoReloadMode_) {
        invoker.reload();
      }

      // イベントを飛ばす
      invoker.onUpload_.apply(null, [docs, invoker]);

    });

  }

  return {
    doNewVersion: doCheckin,
  }
});
