/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.util;

import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractIterator;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionPageIterable;

public abstract class AbstractIterable<T>
implements ItemIterable<T> {
    private final AbstractPageFetcher<T> pageFetcher;
    private final long skipCount;
    private AbstractIterator<T> iterator;

    protected AbstractIterable(AbstractPageFetcher<T> pageFetcher) {
        this(0L, pageFetcher);
    }

    protected AbstractIterable(long position, AbstractPageFetcher<T> pageFetcher) {
        this.pageFetcher = pageFetcher;
        this.skipCount = position;
    }

    protected long getSkipCount() {
        return this.skipCount;
    }

    protected AbstractPageFetcher<T> getPageFetcher() {
        return this.pageFetcher;
    }

    protected abstract AbstractIterator<T> createIterator();

    @Override
    public AbstractIterator<T> iterator() {
        return this.getIterator();
    }

    @Override
    public ItemIterable<T> skipTo(long position) {
        return new CollectionIterable<T>(position, this.pageFetcher);
    }

    @Override
    public ItemIterable<T> getPage() {
        return new CollectionPageIterable<T>(this.skipCount, this.pageFetcher);
    }

    @Override
    public ItemIterable<T> getPage(int maxNumItems) {
        this.pageFetcher.setMaxNumItems(maxNumItems);
        return new CollectionPageIterable<T>(this.skipCount, this.pageFetcher);
    }

    @Override
    public long getPageNumItems() {
        return this.getIterator().getPageNumItems();
    }

    @Override
    public boolean getHasMoreItems() {
        return this.getIterator().getHasMoreItems();
    }

    @Override
    public long getTotalNumItems() {
        return this.getIterator().getTotalNumItems();
    }

    private AbstractIterator<T> getIterator() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator;
    }
}

