/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyServicePort;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;

public class PolicyServiceImpl
extends AbstractWebServicesService
implements PolicyService {
    private final AbstractPortProvider portProvider;

    public PolicyServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    @Override
    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        PolicyServicePort port = this.portProvider.getPolicyServicePort(this.getCmisVersion(repositoryId), "applyPolicy");
        try {
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.applyPolicy(repositoryId, policyId, objectId, portExtension);
            WSConverter.setExtensionValues(portExtension, extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        PolicyServicePort port = this.portProvider.getPolicyServicePort(this.getCmisVersion(repositoryId), "removePolicy");
        try {
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.removePolicy(repositoryId, policyId, objectId, portExtension);
            WSConverter.setExtensionValues(portExtension, extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        PolicyServicePort port = this.portProvider.getPolicyServicePort(this.getCmisVersion(repositoryId), "getAppliedPolicies");
        try {
            List<CmisObjectType> policyList = port.getAppliedPolicies(repositoryId, objectId, filter, WSConverter.convert(extension));
            ArrayList<ObjectData> result = new ArrayList<ObjectData>();
            if (policyList == null) {
                ArrayList<ObjectData> arrayList = result;
                return arrayList;
            }
            for (CmisObjectType policy : policyList) {
                result.add(WSConverter.convert(policy));
            }
            ArrayList<ObjectData> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

