/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest.permission;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.ao.service.FeaturePermissionService;
import jp.ricksoft.plugins.alfresco.permission.FeaturePermissionManager;
import jp.ricksoft.plugins.alfresco.permission.PermissionKeys;
import jp.ricksoft.plugins.alfresco.rest.DocumentLink;
import jp.ricksoft.plugins.alfresco.rest.permission.ActorBean;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionBean;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import jp.ricksoft.plugins.alfresco.rest.permission.UpdateRequestBean;
import org.apache.commons.lang3.StringUtils;

public class FeaturePermissionResourceHelperImpl
implements FeaturePermissionResourceHelper {
    private final UserAccessor userAccessor;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final CredentialService credentialService;
    private final FeaturePermissionManager featurePermissionManager;
    private final I18nResolver i18n;

    public FeaturePermissionResourceHelperImpl(UserAccessor userAccessor, SpaceManager spaceManager, PermissionManager permissionManager, CredentialService credentialService, FeaturePermissionManager featurePermissionManager, I18nResolver i18n) {
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.credentialService = credentialService;
        this.featurePermissionManager = featurePermissionManager;
        this.i18n = i18n;
    }

    @Override
    public FeaturePermissionBean getPeopleIn(Space space, PermissionKeys permissionKeys) {
        ArrayList<ActorBean> actors = Lists.newArrayList();
        FeaturePermissionService.SeachResult result = this.featurePermissionManager.get(space, permissionKeys);
        for (String userName : result.getUsers()) {
            ConfluenceUser user = this.getUser(userName);
            if (user == null) continue;
            ProfilePictureInfo userProfilePicture = this.userAccessor.getUserProfilePicture((User)user);
            actors.add(new ActorBean("user", userName, user.getFullName(), userProfilePicture != null ? userProfilePicture.getUriReference() : ""));
        }
        for (String groupName : result.getGroups()) {
            actors.add(new ActorBean("group", groupName, groupName, ""));
        }
        return new FeaturePermissionBean(permissionKeys, this.getFeatureLabel(permissionKeys), actors, this.i18n);
    }

    @Override
    public FeaturePermissionBean getDefaultPeopleIn(PermissionKeys permissionKeys) {
        return this.getPeopleIn(null, permissionKeys);
    }

    @Override
    public FeaturePermissionBean updatePeopleIn(PermissionKeys permissionKeys, UpdateRequestBean requestBean) {
        UpdateRequestBean.CategorisedActorsBean category = requestBean.getCategorisedActors();
        Space space = this.spaceManager.getSpace(requestBean.getSpaceKey());
        this.featurePermissionManager.put(space, permissionKeys, this.validatedUsers(category.getUser()), category.getGroup());
        return this.getPeopleIn(space, permissionKeys);
    }

    @Override
    public boolean canLinkDocument(AbstractPage page, ConfluenceUser user) {
        return this.featurePermissionManager.hasPermission(PermissionKeys.DOCUMENT_LINK, page, user);
    }

    @Override
    public boolean canUnlinkDocument(AbstractPage page, DocumentLink link, ConfluenceUser user) {
        if (this.featurePermissionManager.hasPermission(PermissionKeys.DOCUMENT_ALL_UNLINK, page, user)) {
            return true;
        }
        if (this.featurePermissionManager.hasPermission(PermissionKeys.DOCUMENT_OWN_UNLINK, page, user)) {
            if (StringUtils.isEmpty((CharSequence)link.getAuthorKey())) {
                return true;
            }
            if (link.getAuthorKey().equals(user.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canUnlinkDocument(Space space, DocumentLink link, ConfluenceUser user) {
        if (this.featurePermissionManager.hasPermission(PermissionKeys.DOCUMENT_ALL_UNLINK, space, user)) {
            return true;
        }
        if (this.featurePermissionManager.hasPermission(PermissionKeys.DOCUMENT_OWN_UNLINK, space, user)) {
            if (StringUtils.isEmpty((CharSequence)link.getAuthorKey())) {
                return true;
            }
            if (link.getAuthorKey().equals(user.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBrowsePanel(AbstractPage page, ConfluenceUser user) {
        return this.featurePermissionManager.hasPermission(PermissionKeys.PANEL_BROWSE, page, user);
    }

    @Override
    public boolean canBrowsePanel(Space space, ConfluenceUser user) {
        return this.featurePermissionManager.hasPermission(PermissionKeys.PANEL_BROWSE, space, user);
    }

    @Override
    public boolean canBrowsePanelWithoutAccount(AbstractPage page, ConfluenceUser user) {
        return this.credentialService.hasAccessType("WithOwnProfile") && this.featurePermissionManager.isEnablePermission(page.getSpace()) && this.featurePermissionManager.hasPermission(PermissionKeys.PANEL_BROWSE_WITHOUT_ACCOUNT, page, user);
    }

    @Override
    public boolean canBrowsePanelWithoutAccount(Space space, ConfluenceUser user) {
        return this.credentialService.hasAccessType("WithOwnProfile") && this.featurePermissionManager.isEnablePermission(space) && this.featurePermissionManager.hasPermission(PermissionKeys.PANEL_BROWSE_WITHOUT_ACCOUNT, space, user);
    }

    @Override
    public Map<String, Boolean> getFeaturePermissions(AbstractPage page, ConfluenceUser user) {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        for (PermissionKeys permissionKeys : PermissionKeys.values()) {
            permissions.put(permissionKeys.name().toLowerCase(), this.featurePermissionManager.hasPermission(permissionKeys, page, user));
        }
        permissions.put(PermissionKeys.PANEL_BROWSE.name().toLowerCase(), true);
        permissions.put(PermissionKeys.PANEL_BROWSE_WITHOUT_ACCOUNT.name().toLowerCase(), false);
        return permissions;
    }

    @Override
    public Map<String, Boolean> getFeaturePermissions(Space space, ConfluenceUser user) {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        for (PermissionKeys permissionKeys : PermissionKeys.values()) {
            permissions.put(permissionKeys.name().toLowerCase(), this.featurePermissionManager.hasPermission(permissionKeys, space, user));
        }
        permissions.put(PermissionKeys.PANEL_BROWSE.name().toLowerCase(), true);
        permissions.put(PermissionKeys.PANEL_BROWSE_WITHOUT_ACCOUNT.name().toLowerCase(), false);
        return permissions;
    }

    @Override
    public Map<String, Boolean> getFeaturePermissionsWitoutAccount(AbstractPage page, ConfluenceUser user) {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        for (PermissionKeys permissionKeys : PermissionKeys.values()) {
            permissions.put(permissionKeys.name().toLowerCase(), false);
        }
        permissions.put(PermissionKeys.DOCUMENT_PREVIEW.name().toLowerCase(), true);
        permissions.put(PermissionKeys.PANEL_BROWSE_WITHOUT_ACCOUNT.name().toLowerCase(), true);
        return permissions;
    }

    @Override
    public Map<String, Boolean> getFeaturePermissionsWitoutAccount(Space space, ConfluenceUser user) {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        for (PermissionKeys permissionKeys : PermissionKeys.values()) {
            permissions.put(permissionKeys.name().toLowerCase(), false);
        }
        permissions.put(PermissionKeys.DOCUMENT_PREVIEW.name().toLowerCase(), true);
        permissions.put(PermissionKeys.PANEL_BROWSE_WITHOUT_ACCOUNT.name().toLowerCase(), true);
        return permissions;
    }

    @Override
    public Map<String, Boolean> getUnusableFeaturePermissions() {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        for (PermissionKeys permissionKeys : PermissionKeys.values()) {
            permissions.put(permissionKeys.name().toLowerCase(), false);
        }
        return permissions;
    }

    @Override
    public boolean hasBrowsePanelAndBrowseSpace(Space space, ConfluenceUser user) {
        if (!this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)space)) {
            return false;
        }
        return this.canBrowsePanel(space, user);
    }

    @Override
    public boolean hasUserCredential(ConfluenceUser user) {
        return this.credentialService.hasUserCredential(user);
    }

    private String getFeatureLabel(PermissionKeys permissionKeys) {
        return this.i18n.getText("alfresco.for.jira.admin.permission.feature." + permissionKeys.name().toLowerCase());
    }

    private List<String> validatedUsers(List<String> users) {
        ArrayList<String> result = Lists.newArrayList();
        for (String name : users) {
            ConfluenceUser user = this.getUser(name);
            if (user == null) continue;
            result.add(name);
        }
        return result;
    }

    private ConfluenceUser getUser(String userName) {
        try {
            return this.userAccessor.getUserByName(userName);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

