/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest.healthcheck;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import javax.servlet.http.HttpServletRequest;
import jp.ricksoft.plugins.alfresco.cmis.BaseCmisSession;
import jp.ricksoft.plugins.alfresco.cmis.CmisOperation;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckBean;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckItem;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckStatus;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;

public class HealthCheckServerConnection
extends HealthCheckItem {
    private static final String ID = "serverconn";
    private final CmisOperation cmisOperation;

    public HealthCheckServerConnection(I18nResolver i18n, SoyTemplateRenderer soyRenderer, CmisOperation cmisOperation) {
        super(i18n, soyRenderer);
        this.cmisOperation = cmisOperation;
    }

    @Override
    HealthCheckBean check(HttpServletRequest request, ConfluenceUser user) {
        String title = this.getText("alfresco.for.confluence.admin.healthcheck.serverconnection.title");
        String message = null;
        try {
            Session cmisSession = ((BaseCmisSession)((Object)this.cmisOperation)).getCmisSession(user, true);
            return new HealthCheckBean(ID, title, HealthCheckStatus.SUCCESS, this.getText("alfresco.for.confluence.admin.healthcheck.serverconnection.success.message"));
        }
        catch (CmisUnauthorizedException e) {
            message = this.getText("alfresco.for.confluence.admin.healthcheck.serverconnection.error.unauthorized.message");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (message == null) {
            message = this.getText("alfresco.for.confluence.admin.healthcheck.serverconnection.error.notconnected");
        }
        return new HealthCheckBean(ID, title, HealthCheckStatus.ERROR, message);
    }
}

