/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialSecret;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialSecretService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialTokenProvider;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import jp.ricksoft.plugins.alfresco.license.LicenseManager;
import jp.ricksoft.plugins.alfresco.permission.FeaturePermissionManager;
import jp.ricksoft.plugins.alfresco.rest.UpdateCurrentLoginFailed;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/updateCurrentLoginFailed")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UpdateCurrentLoginFailedResource {
    private static final Logger log = LoggerFactory.getLogger(UpdateCurrentLoginFailedResource.class);
    private final CredentialService credentialService;
    private final CredentialSecretService credentialSecretService;
    private final FeaturePermissionManager featurePermissionManager;
    private final FeaturePermissionResourceHelper featurePermissionResourceHelper;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final UserManager userManager;
    private final LicenseManager licenseManager;

    public UpdateCurrentLoginFailedResource(CredentialService credentialService, CredentialSecretService credentialSecretService, FeaturePermissionManager featurePermissionManager, FeaturePermissionResourceHelper featurePermissionResourceHelper, SpaceManager spaceManager, PageManager pageManager, UserManager userManager, LicenseManager licenseManager) {
        this.credentialService = credentialService;
        this.credentialSecretService = credentialSecretService;
        this.featurePermissionManager = featurePermissionManager;
        this.featurePermissionResourceHelper = featurePermissionResourceHelper;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.userManager = userManager;
        this.licenseManager = licenseManager;
    }

    @POST
    public Response updateCurrentLoginFailed(@Context HttpServletRequest request, UpdateCurrentLoginFailed updateCurrentLoginFailed) {
        try {
            ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
            if (loggedInUser == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            boolean admin = updateCurrentLoginFailed.isAdmin();
            if (admin && !this.userManager.isAdmin(loggedInUser.getKey()) && !this.userManager.isSystemAdmin(loggedInUser.getKey())) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            if (admin) {
                CredentialEntity credentialEntity = this.credentialService.find();
                if (credentialEntity == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                this.credentialService.updateCurrentLoginFailed(credentialEntity);
            } else {
                CredentialSecret credentialSecretEntity = this.credentialSecretService.find(loggedInUser);
                if (credentialSecretEntity == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                this.credentialSecretService.updateCurrentLoginFailed(credentialSecretEntity);
            }
            CredentialTokenProvider credentialTokenProvider = this.credentialService.generateTokenProvider(loggedInUser, admin);
            boolean overMaximumLoginAttemptAllowed = credentialTokenProvider == null ? false : credentialTokenProvider.isOverMaximumLoginAttemptAllowed();
            updateCurrentLoginFailed.setOverMaximumLoginAttemptAllowed(overMaximumLoginAttemptAllowed);
            return Response.ok((Object)updateCurrentLoginFailed).build();
        }
        catch (InvalidTokenException e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

