/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialTokenProvider;
import jp.ricksoft.plugins.alfresco.rest.ErrorBean;
import jp.ricksoft.plugins.alfresco.rest.ErrorCauseKeys;
import jp.ricksoft.plugins.alfresco.rest.SearchResult;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import jp.ricksoft.plugins.alfresco.search.DocumentSearch;
import jp.ricksoft.plugins.alfresco.search.DocumentSearchResult;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/search")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SearchResource {
    private static final Logger log = LoggerFactory.getLogger(SearchResource.class);
    private final I18nResolver i18n;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final FeaturePermissionResourceHelper featurePermissionResourceHelper;
    private final CredentialService credentialService;
    private final DocumentSearch documentSearch;

    public SearchResource(I18nResolver i18n, SpaceManager spaceManager, PermissionManager permissionManager, FeaturePermissionResourceHelper featurePermissionResourceHelper, CredentialService credentialService, DocumentSearch documentSearch) {
        this.i18n = i18n;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.featurePermissionResourceHelper = featurePermissionResourceHelper;
        this.credentialService = credentialService;
        this.documentSearch = documentSearch;
    }

    @GET
    public Response search(@Context HttpServletRequest request, @QueryParam(value="q") String query, @QueryParam(value="p") int pageNum, @QueryParam(value="spaceKey") String spaceKey) {
        long start = System.currentTimeMillis();
        log.debug("+++ SearchResource.search start");
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.featurePermissionResourceHelper.hasBrowsePanelAndBrowseSpace(space, user)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBean(ErrorCauseKeys.UNAUTHORIZED)).build();
        }
        try {
            CredentialTokenProvider credentialTokenProvider = this.credentialService.generateTokenProvider(user);
            if ("WithOwnProfile".equals(credentialTokenProvider.getAccessType()) && credentialTokenProvider.getToken() == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBean(ErrorCauseKeys.UNREGISTERED_CREDENTIAL_TOKEN)).build();
            }
            DocumentSearchResult documentSearchResult = this.documentSearch.search(user, space, query.trim(), pageNum);
            log.debug("+++ SearchResource.search end");
            long end = System.currentTimeMillis();
            log.debug("+++ " + (end - start) + " ms -> " + (end - start) / 1000L + " s");
            return Response.ok((Object)new SearchResult(documentSearchResult.getSearchResultItemList(), documentSearchResult.getTotalNumber().intValue(), pageNum, this.documentSearch.getMaxItemsPerPage(), this.getFeaturePermissions(space, user))).build();
        }
        catch (CmisUnauthorizedException e) {
            log.debug("failed search.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBean(ErrorCauseKeys.UNAUTHORIZED, this.i18n.getText("alfresco.for.confluence.ajax.error.unauthorized"))).build();
        }
        catch (Exception e) {
            log.debug("failed search.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBean(ErrorCauseKeys.UNEXPECTED, this.i18n.getText("alfresco.for.confluence.ajax.error.server"))).build();
        }
    }

    Map<String, Boolean> getFeaturePermissions(Space space, ConfluenceUser loggedInUser) {
        boolean hasUserCredential = this.featurePermissionResourceHelper.hasUserCredential(loggedInUser);
        boolean canBrowsePanelWithAccount = this.featurePermissionResourceHelper.canBrowsePanel(space, loggedInUser);
        boolean canBrowsePanelWithoutAccount = this.featurePermissionResourceHelper.canBrowsePanelWithoutAccount(space, loggedInUser);
        if (!(hasUserCredential && canBrowsePanelWithAccount || !canBrowsePanelWithoutAccount)) {
            return this.featurePermissionResourceHelper.getFeaturePermissionsWitoutAccount(space, loggedInUser);
        }
        return this.featurePermissionResourceHelper.getFeaturePermissions(space, loggedInUser);
    }
}

