/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest;

import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolderType;
import jp.ricksoft.plugins.alfresco.ao.service.GeneralConfigService;
import jp.ricksoft.plugins.alfresco.ao.service.MappingFolderService;
import jp.ricksoft.plugins.alfresco.configuration.AdvancedConfigurationData;
import jp.ricksoft.plugins.alfresco.rest.PageInfo;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/pageinfo")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PageInfoResource {
    private static final Logger log = LoggerFactory.getLogger(PageInfoResource.class);
    private final SpaceManager spaceManager;
    private final I18nResolver i18n;
    private final ConfluenceSidManager sidManager;
    private final MappingFolderService mappingFolderService;
    private final FeaturePermissionResourceHelper featurePermissionResourceHelper;
    private final GeneralConfigService generalConfigService;

    public PageInfoResource(ConfluenceSidManager sidManager, SpaceManager spaceManager, I18nResolver i18n, MappingFolderService mappingFolderService, FeaturePermissionResourceHelper featurePermissionResourceHelper, GeneralConfigService generalConfigService) {
        this.sidManager = sidManager;
        this.spaceManager = spaceManager;
        this.i18n = i18n;
        this.mappingFolderService = mappingFolderService;
        this.featurePermissionResourceHelper = featurePermissionResourceHelper;
        this.generalConfigService = generalConfigService;
    }

    @GET
    public Response getStartupInfo(@Context HttpServletRequest request, @QueryParam(value="spaceKey") String spaceKey) {
        String serverId = null;
        try {
            serverId = this.sidManager.getSid();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty((CharSequence)serverId)) {
            return Response.serverError().build();
        }
        ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Long spaceId = space.getId();
        List<MappingFolder> publicFolder = this.mappingFolderService.getFoldersBySpaceId(spaceId, MappingFolderType.PUBLIC);
        ArrayList<String> publicFolderId = new ArrayList<String>();
        if (publicFolder != null) {
            for (MappingFolder folder : publicFolder) {
                if (folder == null || folder.getPath() == null) continue;
                publicFolderId.add(folder.getPath().getCmisFolderId());
            }
        }
        String publicPathLabel = this.i18n.getText("alfresco.for.confluence.page.folder.public.label");
        MappingFolder privateFolder = this.mappingFolderService.getFolderBySpaceId(spaceId, MappingFolderType.PRIVATE);
        String privateFolderId = privateFolder != null && privateFolder.getPath() != null ? privateFolder.getPath().getCmisFolderId() : null;
        String privatePathLabel = this.i18n.getText("alfresco.for.confluence.page.folder.private.label");
        Map<String, Boolean> permissions = this.getFeaturePermissions(space, loggedInUser);
        AdvancedConfigurationData advancedConfiguration = this.generalConfigService.getAdvancedConfig();
        return Response.ok((Object)new PageInfo(serverId, spaceId, publicFolderId, publicPathLabel, privateFolderId, privatePathLabel, permissions, advancedConfiguration)).build();
    }

    Map<String, Boolean> getFeaturePermissions(Space space, ConfluenceUser loggedInUser) {
        boolean hasUserCredential = this.featurePermissionResourceHelper.hasUserCredential(loggedInUser);
        boolean canBrowsePanelWithAccount = this.featurePermissionResourceHelper.canBrowsePanel(space, loggedInUser);
        boolean canBrowsePanelWithoutAccount = this.featurePermissionResourceHelper.canBrowsePanelWithoutAccount(space, loggedInUser);
        if (!canBrowsePanelWithAccount && !canBrowsePanelWithoutAccount) {
            return this.featurePermissionResourceHelper.getUnusableFeaturePermissions();
        }
        if (!(hasUserCredential && canBrowsePanelWithAccount || !canBrowsePanelWithoutAccount)) {
            return this.featurePermissionResourceHelper.getFeaturePermissionsWitoutAccount(space, loggedInUser);
        }
        return this.featurePermissionResourceHelper.getFeaturePermissions(space, loggedInUser);
    }
}

