/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.profile;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.PermittedMethods;
import java.util.ArrayList;
import java.util.List;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialSecretService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialTokenProvider;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import jp.ricksoft.plugins.alfresco.profile.AlfrescoProfileBaseAction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileAction
extends AlfrescoProfileBaseAction {
    private static final long serialVersionUID = -9108941554551211472L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserProfileAction.class);
    protected CredentialService credentialService;
    protected CredentialSecretService credentialSecretService;
    protected boolean credential;
    protected boolean credentialToken;
    protected boolean accessTypeWithOwnProfile;
    protected String credentialUsername;
    protected String credentialPassword;
    protected boolean overMaximumLoginAttemptAllowed;
    protected Integer maximumLoginAttemptAllowed;
    protected String lastFailedLogin;
    protected Integer currentLoginFailedCount;
    protected boolean limitMaximumLoginAttemptAllowed;
    protected List<String> messages = new ArrayList<String>();

    @XsrfProtectionExcluded
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws InvalidTokenException {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            CredentialTokenProvider credentialTokenProvider = this.credentialService.generateTokenProvider(user);
            if (credentialTokenProvider != null) {
                this.setCredential(credentialTokenProvider != null);
                this.setCredentialToken(!StringUtils.isEmpty((CharSequence)credentialTokenProvider.getToken()));
                this.setAccessTypeWithOwnProfile(credentialTokenProvider != null ? "WithOwnProfile".equals(credentialTokenProvider.getAccessType()) : false);
                this.setCredentialUsername(credentialTokenProvider != null ? credentialTokenProvider.getUsername() : "");
                this.setOverMaximumLoginAttemptAllowed(credentialTokenProvider.isOverMaximumLoginAttemptAllowed());
                this.setLastFailedLogin(credentialTokenProvider.getLastFailedLogin());
                this.setCurrentLoginFailedCount(credentialTokenProvider.getCurrentLoginFailedCount());
                this.setLimitMaximumLoginAttemptAllowed(credentialTokenProvider.isLimitMaximumLoginAttemptAllowed());
            }
        }
        catch (InvalidTokenException e) {
            this.addActionError(this.getText("alfresco.for.confluence.user.credential.update.error.empty"));
        }
        return "success";
    }

    public void setCredentialSecretService(CredentialSecretService credentialSecretService) {
        this.credentialSecretService = credentialSecretService;
    }

    @Override
    public void setCredentialService(CredentialService credentialService) {
        this.credentialService = credentialService;
    }

    public boolean isHasCredential() {
        return this.credential;
    }

    @ParameterSafe
    public void setCredential(boolean credential) {
        this.credential = credential;
    }

    public boolean isCredentialToken() {
        return this.credentialToken;
    }

    @ParameterSafe
    public void setCredentialToken(boolean credentialToken) {
        this.credentialToken = credentialToken;
    }

    public boolean isAccessTypeWithOwnProfile() {
        return this.accessTypeWithOwnProfile;
    }

    @ParameterSafe
    public void setAccessTypeWithOwnProfile(boolean accessTypeWithOwnProfile) {
        this.accessTypeWithOwnProfile = accessTypeWithOwnProfile;
    }

    public String getCredentialUsername() {
        return this.credentialUsername;
    }

    @ParameterSafe
    public void setCredentialUsername(String credentialUsername) {
        this.credentialUsername = credentialUsername;
    }

    @ParameterSafe
    public void setCredentialPassword(String credentialPassword) {
        this.credentialPassword = credentialPassword;
    }

    public boolean getOverMaximumLoginAttemptAllowed() {
        return this.overMaximumLoginAttemptAllowed;
    }

    @ParameterSafe
    public void setOverMaximumLoginAttemptAllowed(boolean overMaximumLoginAttemptAllowed) {
        this.overMaximumLoginAttemptAllowed = overMaximumLoginAttemptAllowed;
    }

    public Integer getMaximumLoginAttemptAllowed() {
        return this.maximumLoginAttemptAllowed;
    }

    @ParameterSafe
    public void setMaximumLoginAttemptAllowed(Integer maximumLoginAttemptAllowed) {
        this.maximumLoginAttemptAllowed = maximumLoginAttemptAllowed;
    }

    public String getLastFailedLogin() {
        return this.lastFailedLogin;
    }

    @ParameterSafe
    public void setLastFailedLogin(String lastFailedLogin) {
        this.lastFailedLogin = lastFailedLogin;
    }

    public Integer getCurrentLoginFailedCount() {
        return this.currentLoginFailedCount;
    }

    @ParameterSafe
    public void setCurrentLoginFailedCount(Integer currentLoginFailedCount) {
        this.currentLoginFailedCount = currentLoginFailedCount;
    }

    public boolean isLimitMaximumLoginAttemptAllowed() {
        return this.limitMaximumLoginAttemptAllowed;
    }

    @ParameterSafe
    public void setLimitMaximumLoginAttemptAllowed(boolean limitMaximumLoginAttemptAllowed) {
        this.limitMaximumLoginAttemptAllowed = limitMaximumLoginAttemptAllowed;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }
}

