/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.listener;

import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import jp.ricksoft.plugins.alfresco.ao.service.DocumentLinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PageEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PageEventListener.class);
    private final EventPublisher eventPublisher;
    private final DocumentLinkService documentLinkService;

    public PageEventListener(EventPublisher eventPublisher, DocumentLinkService documentLinkService) {
        this.eventPublisher = eventPublisher;
        this.documentLinkService = documentLinkService;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPageRemoveEvent(PageRemoveEvent event) {
        this.deleteDocumentLink(event.getPage());
    }

    void deleteDocumentLink(Page page) {
        if (page == null) {
            return;
        }
        this.documentLinkService.delete((AbstractPage)page);
    }
}

