/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.cmis;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.upm.api.util.Either;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialSecret;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialSecretService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialTokenProvider;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import jp.ricksoft.plugins.alfresco.auth.LoginAttemptsException;
import jp.ricksoft.plugins.alfresco.cmis.BasicAuthenticationProvider;
import jp.ricksoft.plugins.alfresco.cmis.CmisAuthenticationProvider;
import jp.ricksoft.plugins.alfresco.cmis.UsernameTokenAuthenticationProvider;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;

public class BaseCmisSession {
    private final CredentialService credentialService;
    private final CredentialSecretService credentialSecretService;

    public BaseCmisSession(CredentialService credentialService, CredentialSecretService credentialSecretService) {
        this.credentialService = credentialService;
        this.credentialSecretService = credentialSecretService;
    }

    public Session getCmisSession(ConfluenceUser user, boolean admin) throws InvalidTokenException, LoginAttemptsException {
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        CredentialTokenProvider credentialTokenProvider = this.credentialService.generateTokenProvider(user, admin);
        if (credentialTokenProvider == null) {
            return null;
        }
        if (credentialTokenProvider.isOverMaximumLoginAttemptAllowed()) {
            throw new LoginAttemptsException("over maximum login attempts allowed.");
        }
        String authType = credentialTokenProvider.getAuthType();
        String url = credentialTokenProvider.getAlfrescoApplicationUrl();
        String username = credentialTokenProvider.getUsername();
        String token = credentialTokenProvider.getToken();
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.binding.browser.url", url + "/api/-default-/public/cmis/versions/1.1/browser");
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.BROWSER.value());
        parameter.put("org.apache.chemistry.opencmis.user", username);
        parameter.put("org.apache.chemistry.opencmis.password", token);
        parameter.put("org.apache.chemistry.opencmis.binding.httpinvoker.classname", "jp.ricksoft.plugins.alfresco.cmis.BaseCmisHttpInvoker");
        parameter.put("REPOSITORY_URL", url + "/api/-default-/public/cmis/versions/1.1/browser");
        AbstractAuthenticationProvider authenticationProvider = null;
        if ("Basic".equals(authType)) {
            parameter.put("org.apache.chemistry.opencmis.binding.auth.http.basic", "true");
            authenticationProvider = new BasicAuthenticationProvider(token);
        }
        if ("WSSE".equals(authType)) {
            authenticationProvider = new UsernameTokenAuthenticationProvider(token);
        }
        ((CmisAuthenticationProvider)((Object)authenticationProvider)).setSSLSocketFactory(this.getSelfSignedCertificatesSocketFactory());
        ((CmisAuthenticationProvider)((Object)authenticationProvider)).setHostnameVerifier(this.getHostnameVerifier());
        try {
            List<Repository> repositories = factory.getRepositories(parameter, null, authenticationProvider, null, null);
            return repositories.get(0).createSession();
        }
        catch (Exception e) {
            Either<CredentialEntity, CredentialSecret> credentialEither = credentialTokenProvider.getCredentialEither();
            if (credentialEither.isLeft()) {
                this.credentialService.updateCurrentLoginFailed((CredentialEntity)credentialEither.left().get());
            } else {
                this.credentialSecretService.updateCurrentLoginFailed((CredentialSecret)credentialEither.right().get());
            }
            throw e;
        }
    }

    public Session getCmisSession(ConfluenceUser user) throws InvalidTokenException, LoginAttemptsException {
        return this.getCmisSession(user, false);
    }

    private SSLSocketFactory getSelfSignedCertificatesSocketFactory() throws InvalidTokenException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidTokenException(e);
        }
        catch (KeyManagementException e) {
            throw new InvalidTokenException(e);
        }
    }

    private HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }
}

