/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service.jdbc;

import java.util.Locale;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.Dialect;
import org.apache.commons.lang3.StringUtils;

public class OracleDialect
implements Dialect {
    @Override
    public String limit(String sql, int limit, int offset) {
        sql = sql.trim();
        String forUpdateClause = null;
        boolean isForUpdate = false;
        int forUpdateIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("for update");
        if (forUpdateIndex > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        StringBuilder pagingSelect = new StringBuilder(sql.length());
        if (offset > 0) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (offset > 0) {
            pagingSelect.append(" ) row_ where rownum <= " + (offset + limit) + ") where rownum_ > " + offset + " ");
        } else {
            pagingSelect.append(" ) where rownum <= " + limit + " ");
        }
        if (isForUpdate) {
            pagingSelect.append(" ");
            pagingSelect.append(forUpdateClause);
        }
        return pagingSelect.toString();
    }

    @Override
    public String quote(String columnOrTable) {
        if (StringUtils.isBlank((CharSequence)columnOrTable)) {
            return columnOrTable;
        }
        return "\"" + columnOrTable + "\"";
    }
}

