/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolderType;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingPath;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingSpace;
import jp.ricksoft.plugins.alfresco.ao.service.MappingFolderService;
import jp.ricksoft.plugins.alfresco.ao.service.MappingSpaceCallback;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class MappingFolderServiceImpl
implements MappingFolderService {
    private final ActiveObjects ao;

    public MappingFolderServiceImpl(ActiveObjects ao) {
        this.ao = Preconditions.checkNotNull(ao);
    }

    @Override
    public List<MappingFolder> getFolders() {
        return Lists.newArrayList((MappingFolder[])this.ao.find(MappingFolder.class));
    }

    @Override
    public List<MappingFolder> getFolders(MappingFolderType type) {
        return Lists.newArrayList((MappingFolder[])this.ao.find(MappingFolder.class, Query.select().where("TYPE = ?", new Object[]{type.name()}).order("ID ASC")));
    }

    @Override
    public MappingFolder getFolder(Integer folderId) {
        return (MappingFolder)this.ao.get(MappingFolder.class, (Object)folderId);
    }

    @Override
    public MappingFolder getFolderBySpaceId(Long spaceId) {
        MappingSpace[] spaces = (MappingSpace[])this.ao.find(MappingSpace.class, Query.select().where("SPACE_ID = ?", new Object[]{spaceId}).order("ID ASC").limit(1));
        if (spaces == null || spaces.length == 0) {
            return null;
        }
        return spaces[0].getFolder();
    }

    @Override
    public List<MappingFolder> getFoldersBySpaceId(Long spaceId) {
        MappingSpace[] spaces = (MappingSpace[])this.ao.find(MappingSpace.class, Query.select().where("SPACE_ID = ?", new Object[]{spaceId}).order("ID ASC"));
        if (spaces == null) {
            return Lists.newArrayList();
        }
        ArrayList<MappingFolder> result = new ArrayList<MappingFolder>();
        for (MappingSpace space : spaces) {
            result.add(space.getFolder());
        }
        return result;
    }

    @Override
    public MappingFolder getFolderBySpaceId(Long spaceId, MappingFolderType type) {
        MappingSpace[] spaces = (MappingSpace[])this.ao.find(MappingSpace.class, Query.select().where("SPACE_ID = ?", new Object[]{spaceId}).order("ID ASC"));
        if (spaces == null || spaces.length == 0) {
            return null;
        }
        for (MappingSpace space : spaces) {
            MappingFolder folder = space.getFolder();
            if (!type.name().equals(folder.getType())) continue;
            return folder;
        }
        return null;
    }

    @Override
    public List<MappingFolder> getFoldersBySpaceId(Long spaceId, MappingFolderType type) {
        MappingSpace[] spaces = (MappingSpace[])this.ao.find(MappingSpace.class, Query.select().where("SPACE_ID = ?", new Object[]{spaceId}).order("ID ASC"));
        if (spaces == null || spaces.length == 0) {
            return null;
        }
        ArrayList<MappingFolder> result = new ArrayList<MappingFolder>();
        for (MappingSpace space : spaces) {
            MappingFolder folder = space.getFolder();
            if (!type.name().equals(folder.getType())) continue;
            result.add(folder);
        }
        if (result.size() <= 0) {
            return null;
        }
        return result;
    }

    @Override
    public List<MappingSpace> getSpaces(MappingFolderType type) {
        MappingSpace[] spaces;
        ArrayList<MappingSpace> results = new ArrayList<MappingSpace>();
        for (MappingSpace space : spaces = (MappingSpace[])this.ao.find(MappingSpace.class)) {
            MappingFolder folder = space.getFolder();
            if (!type.name().equals(folder.getType())) continue;
            results.add(space);
        }
        return results;
    }

    @Override
    public List<MappingSpace> getSpacesByFolderId(Integer folderId) {
        MappingFolder folder = this.getFolder(folderId);
        if (folder == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(folder.getSpaces());
    }

    @Override
    public List<Long> getSpaceIds(MappingFolderType type) {
        return this.transform(this.getSpaces(type));
    }

    @Override
    public List<Long> getSpaceIdsByFolderId(Integer folderId) {
        return this.transform(this.getSpacesByFolderId(folderId));
    }

    @Override
    public MappingFolder saveFolder(String name, String cmisFolderId, List<Long> spaceIds, MappingFolderType type) {
        MappingFolder folder = (MappingFolder)this.ao.create(MappingFolder.class, new DBParam[0]);
        folder.setName(name);
        folder.setType(type.name());
        folder.save();
        MappingPath folderPath = (MappingPath)this.ao.create(MappingPath.class, new DBParam[0]);
        folderPath.setCmisFolderId(cmisFolderId);
        folderPath.setFolder(folder);
        folderPath.save();
        for (Long spaceId : spaceIds) {
            MappingSpace project = (MappingSpace)this.ao.create(MappingSpace.class, new DBParam[0]);
            project.setSpaceId(spaceId);
            project.setFolder(folder);
            project.save();
        }
        return folder;
    }

    @Override
    public MappingFolder updateFolder(Integer folderId, String name, String cmisFolderId, List<Long> spaceIds) {
        MappingFolder folder = this.getFolder(folderId);
        folder.setName(name);
        folder.save();
        MappingPath folderPath = folder.getPath();
        folderPath.setCmisFolderId(cmisFolderId);
        folderPath.setFolder(folder);
        folderPath.save();
        MappingSpace[] projects = folder.getSpaces();
        this.ao.delete((RawEntity[])projects);
        for (Long spaceId : spaceIds) {
            MappingSpace project = (MappingSpace)this.ao.create(MappingSpace.class, new DBParam[0]);
            project.setSpaceId(spaceId);
            project.setFolder(folder);
            project.save();
        }
        return folder;
    }

    @Override
    public void deleteFolder(Integer folderId) {
        MappingFolder folder = this.getFolder(folderId);
        this.ao.delete(new RawEntity[]{folder.getPath()});
        this.ao.delete((RawEntity[])folder.getSpaces());
        this.ao.delete(new RawEntity[]{folder});
    }

    List<Long> transform(List<MappingSpace> projects) {
        return Lists.transform(projects, new Function<MappingSpace, Long>(){

            @Override
            public Long apply(MappingSpace input) {
                return input.getSpaceId();
            }
        });
    }

    @Override
    public void streamAll(final MappingSpaceCallback callback) {
        this.ao.stream(MappingSpace.class, Query.select((String)"ID, SPACE_ID, FOLDER_ID"), (EntityStreamCallback)new EntityStreamCallback<MappingSpace, Integer>(){

            public void onRowRead(MappingSpace t) {
                callback.valueRead(t);
            }
        });
    }
}

