/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import java.util.Arrays;
import java.util.Collection;
import jp.ricksoft.plugins.alfresco.ao.entity.GeneralConfig;
import jp.ricksoft.plugins.alfresco.ao.service.GeneralConfigService;
import jp.ricksoft.plugins.alfresco.configuration.AdvancedConfigurationData;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class GeneralConfigServiceImpl
implements GeneralConfigService {
    private final ActiveObjects ao;

    public GeneralConfigServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    public GeneralConfig find(int id) {
        return (GeneralConfig)this.ao.get(GeneralConfig.class, (Object)id);
    }

    @Override
    public GeneralConfig find() {
        Collection<GeneralConfig> configurations = this.findAll();
        if (configurations != null && !configurations.isEmpty()) {
            return configurations.iterator().next();
        }
        GeneralConfig entity = (GeneralConfig)this.ao.create(GeneralConfig.class, new DBParam[0]);
        entity.setAdvancedConfig(null);
        entity.save();
        return entity;
    }

    public Collection<GeneralConfig> findAll() {
        return Arrays.asList((GeneralConfig[])this.ao.find(GeneralConfig.class, Query.select().order("ID ASC")));
    }

    @Override
    public AdvancedConfigurationData getAdvancedConfig() {
        GeneralConfig generalConfig = this.find();
        String advancedConfigXml = generalConfig.getAdvancedConfig();
        if (advancedConfigXml == null) {
            return new AdvancedConfigurationData();
        }
        return AdvancedConfigurationData.deserialize(advancedConfigXml);
    }

    @Override
    public GeneralConfig saveAdvancedConfig(AdvancedConfigurationData config) {
        String xml = config.serialize();
        GeneralConfig entity = this.find();
        if (entity == null) {
            entity = (GeneralConfig)this.ao.create(GeneralConfig.class, new DBParam[0]);
        }
        entity.setAdvancedConfig(xml);
        entity.save();
        return entity;
    }

    @Override
    public void delete() {
        GeneralConfig entity = this.find();
        if (entity == null) {
            return;
        }
        this.ao.delete(new RawEntity[]{entity});
    }
}

