/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('alfresco-macro/linked-list',
    ['jquery', 'cmis/cmisconfluence', 'cmis/cmisbrowser', 'cmis/cmislistview', 'cmis/confluence-listview-helper', 'cmis/confluence-error-handler', 'attachments/attachment-navigation', 'attachments/attachment-permission'],
    function($, cmisConfluence, treeview, listview, listviewHelper, errorHandler, attachmentNavigation, attachmentPermission) {'use strict'
  
  var HIDDEN_CLASS = 'hidden';
  var LOADING_CLASS = "loading-documents";
  var ERROR_PREFIX = "Alfresco Document List Macro: ";

  function LinkedListMacro(frame, data, cmisSession, permissions) {

    this.$frame = $(frame);
    this.$el_ = this.$frame.find('.cmis-linked-list');
    this.data = data;
    this.cmisSession = cmisSession;
    this.cmis_session = cmisConfluence.getCmisSession();
    this.permissions = permissions;
    
    this.init_().done(function() {
      
    }).fail(function() {
      
    });
  }
  
  LinkedListMacro.prototype.cmis_session;
  LinkedListMacro.prototype.expListView;
  LinkedListMacro.prototype.expTreeView;
  LinkedListMacro.prototype.permissions;
  LinkedListMacro.prototype.publicFolderId;

  
  /**
   * アップロード可能か
   */
  LinkedListMacro.prototype.isEnableUpload_ = function() {
    return this.$el_.attr('param-enable-upload') == 'true';
  }
  
  /**
   * プレビュー表示か
   */
  LinkedListMacro.prototype.isPreview_ = function() {
    return this.$el_.attr('param-is-preview') == 'true';
  }
  
  /**
   * 初期化
   */
  LinkedListMacro.prototype.init_ = function() {

    var self = this;
    var d = new AJS.$.Deferred;

    (function() {

      var d = new AJS.$.Deferred;

      if (!self.getPublicFolderId()) {
        d.resolve(self.data, null);
        return d.promise();
      }

      self.cmis_session.getFolder(self.getPublicFolderId(), false, {'includeAllowableActions':true}).done(function(publicFolder) {
        d.resolve(data, publicFolder);
      }).fail(function(error) {
        errorHandler.showError(self.$frame, { body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.folder.public') + getPublicFolderId(), error: error });
        d.reject();
      });

      return d.promise();

    })().pipe(function(data) {

      self.expListView = listview.setup({
        cmis_session: self.cmis_session,
        el:$('.cmis-listbrowser', self.$el_),
        helper: listviewHelper.create(),
        alfrescoUrl:cmisConfluence.getAlfrescoUrl(),
        dateformat:'YYYY/MM/DD',
        autoReloadMode:true,
        permissions: $.extend(self.permissions, {
          document_createissue: false,
          document_create: self.isEnableUpload_() ? self.permissions.document_create : false
        }),
        onFolderCreate: $.proxy(self.doFolderCreate, self),
        onFolderRemove: $.proxy(self.doFolderRemove, self),
        onFolderSelected: $.proxy(self.doFolderSelected, self),
        onRenderList: $.proxy(self.doRenderList, self)
      });

      var navigation = attachmentNavigation.setup({
        cmis_session: self.cmis_session,
        data: data,
        listView: self.expListView
      });

      navigation.loadFolders({
        'all': data.advancedConfiguration.enableAllFiles,
        'editing': data.advancedConfiguration.enableImEditing,
        'recent-modified': data.advancedConfiguration.enableRecentlyModified,
        'recent-added': data.advancedConfiguration.enableRecentlyAdded,
        'favorite': attachmentPermission.isEnableFavorite(self.permissions),
        'shared-links': attachmentPermission.isEnableSharedLinks(self.permissions),
        'link': {
          getChildren: function () {
            return self.expListView.getDocumentByPage();
          }
        }
      }).done(function (folders) {

        if ((folders['public'] && folders['public'].length > 0) || folders['private']) {

          self.expTreeView = treeview.setup({
            cmis_session: self.cmis_session,
            el: $('.cmis-treebrowser', self.$el_),
            rootFolder: folders.asArray(),
            folderOnly: true,
            allowFolderSelect: true,
            resizable: true
          });
          self.expTreeView.bind('tree.select', function (e) {
            var node = e.node;
            if (!node || !node.cmisdata) {
              return;
            }
            self.expListView.setPageNum(0);
            navigation.loadByFolder(node);
            self.expListView.initUpload();
          });
          self.expTreeView.addToSelection(navigation.LINK_FOLDER_ID);

        } else {

          $('.cmis-sidebar', self.$el_).remove();

        }

        self.expListView.setRootFolder(folders['link']);
        self.expListView.renderFolderInfo(folders['link']);
        self.expListView.loadByFolder(folders['link']);
        self.expListView.initUpload();

      });

      d.resolve();

    }).fail(function(error) {

      d.reject();

    }).always(function() {

      $("." + LOADING_CLASS, self.$frame).addClass(HIDDEN_CLASS);

    });

    return d.promise();
    
  }

  /**
   * 
   */
  LinkedListMacro.prototype.doFolderCreate = function(folder, created, listview) {
    cmisConfluence.getDocumentById(created.id).done(function(doc) {
      this.expTreeView.appendObjectToSelectedNode(doc);
    });
  }
  
  /**
   * 
   */
  LinkedListMacro.prototype.doFolderRemove = function(folder, removed, listview) {
    this.expTreeView.removeSelectedNode();
  }
  
  /**
   * 
   */
  LinkedListMacro.prototype.doFolderSelected = function(selected, current, listview) {
    this.expTreeView.selectOpenNode(selected, current);
  }

  /**
   *
   */
  LinkedListMacro.prototype.doRenderList = function() {

    // プレビュー表示の場合はイベントを無効化しておく
    if (this.isPreview_()) {
      var preventEvents = {
        click: ['.folder-create','.folder-remove','.sort-order','.sort-column',
          '.link', '.unlink', 'newversion', 'canceledit', 'editoffline', '.upload-button', '.download', '.preview', '.filename', '.version', '.property', '.remove', '.linked', '.detail-link', '.addfavorite', '.delfavorite', '.cmis-pagination',
          '.cmis-pagination a'].join(','),
        keypress: '.search',
        'aui-dropdown2-item-check':'#cmis-sort'
      };

      for (var name in preventEvents) {
        var selector = preventEvents[name];

        this.$el_.find(selector).off(name).on(name, function(e) {
          e.stopImmediatePropagation(); // バブリング停止と他の設定されたイベント処理をブロック
          return false;
        });
      }
    }

  }

  /**
   * 添付ファイルのパブリック・フォルダのIDを取得します
   * @return {String}
   */
  LinkedListMacro.prototype.getPublicFolderId = function() {
    return this.publicFolderId;
  }
  
  return {
    setupMacro: function(el, data, cmisSession, permissions) {
      return new LinkedListMacro(el, data, cmisSession, permissions);
    },

    getErrorPrefix: function() {
      return ERROR_PREFIX;
    }
  };
});

AJS.toInit(function() {

  require(['alfresco-macro/linked-list', 'alfresco-macro/macroCommon', 'cmis/confluence-error-handler'], function(main, macroCommon, errorHandler) {
    
    var $els = AJS.$('.cmis-linked-list-frame');

    macroCommon.init(main.getErrorPrefix()).done(function(initData) {

      AJS.$.each($els, function(i, el) {
        main.setupMacro(el, initData.data, initData.cmisSession, initData.permissions);
      });

    }).fail(function(error) {

      AJS.$.each($els, function(i, el) {
        errorHandler.showError($(el).empty(), error);
      });

    });
  });
});
