/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
//Register TinyMCE plugin
(function() {
  function plugin() {
    return {
      init: function (ed) {
//      ed.addCommand('mceJiralink', AJS.Editor.JiraConnector.hotKey);
        ed.onPostRender.add(function (ed) {
//        AJS.$.get(Confluence.getContextPath() + '/rest/jiraanywhere/1.0/servers', function(data){
//          AJS.Editor.JiraConnector.servers = data;
//        });
//        AJS.$('#jiralink').click(function(e) {
//          AJS.Editor.JiraConnector.open(AJS.Editor.JiraConnector.source.editorDropdownLink, true);
//          return AJS.stopEvent(e);
//        });
//        AJS.$('#insert-menu .macro-jiralink').show();
//        ed.addShortcut('ctrl+shift+j', '', 'mceJiralink');
        });
      },
      getInfo: function () {
        return {
          longname: "Alfresco Linked Document",
          author: "Ricksoft Inc",
          authorurl: "https://www.ricksoft.jp/",
          version: tinymce.majorVersion + "." + tinymce.minorVersion
        }
      }
    }
  }

  tinymce.PluginManager.add('alfresco-document-macro', plugin);
})();

define('alfresco-macro/linked-document-dialogs', ['jquery', 'cmis/cmisconfluence', 'cmis/cmisbrowser', 'cmis/cmislistview', 'cmis/confluence-listview-helper', 'cmis/confluence-error-handler', 'attachments/attachment-navigation', 'attachments/attachment-permission'],
    function($, cmisConfluence, treeview, listview, listviewHelper, errorHandler, attachmentNavigation, attachmentPermission) {'use strict'

  var MACRO_NAME = 'alfresco-document-macro';
  var DIALOG_ID = 'alfresco-linked-document-dialog';
  var DIALOG_SECTION = '<section role="dialog" id="'+DIALOG_ID+'" class="aui-layer aui-dialog2 aui-dialog2-xlarge loadingInProgress" aria-hidden="true" data-aui-modal="true"></section>';
  var HIDDEN_CLASS = 'hidden';
  var LOADING_CLASS = "loading-documents";

  var THUMBNAIL_SIZE_SMALL= 150,
      THUMBNAIL_SIZE_MEDIUM = 250,
      THUMBNAIL_SIZE_LARGE= 400;


  var cmis_session;
  var serverId;
  var spaceId;
  var pageId;
  var permissions;

  var $editDialog_;
  var editDialog_;
  var $content;
  var expListView;
  var expTreeView;
  var selectedDocuments_;

  /**
   * ドキュメント選択ダイアログ表示処理
   * @param reopen
   */
  function openEditDialog(reopen) {
    if ($('#'+DIALOG_ID).length <= 0) {
      $('body').append(DIALOG_SECTION);
    }

    var template = Confluence.Templates.alfrescoLinkedDocumentDialog.editDialog({});

    $editDialog_ = $('#'+DIALOG_ID).empty().append(template);
    $editDialog_.find('.cancel').click(function() {
      // ダイアログを閉じる
      closeEditDialog();
    });
    $editDialog_.find('.insert').click(function() {
      closeEditDialog();

      AJS.Rte.BookmarkManager.storeBookmark();

      var macroRenderRequest = {
          contentId : Confluence.Editor.getContentId(),
          macro : {
              name : "alfresco-document-macro",
              params : {},
              defaultParameterValue : "",
              body : ""
          }
      };

      var documents = expListView.getSelectedDocuments();
      var index;
      var id;
      for (var i = 0; i < documents.length; i++) {
        index = documents[i].indexOf(';');
        if (index >= 0) {
          id = documents[i].substring(0, index);
        } else {
          id = documents[i];
        }
        macroRenderRequest.macro.params.documentId = id;
        macroRenderRequest.macro.params.displayMode = 'thumbnail';
        macroRenderRequest.macro.params.thumbnailSizeMode = 'small';
        macroRenderRequest.macro.params.thumbnailSize = THUMBNAIL_SIZE_SMALL;

        tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest);
      }

      AJS.Rte.BookmarkManager.restoreBookmark();

    });

    $content = $(".aui-dialog2-content", $editDialog_);

    initListView(reopen);

    editDialog_ = AJS.dialog2('#'+DIALOG_ID);
    editDialog_.show();
  }

  /**
   * ドキュメント選択ダイアログ非表示処理
   */
  function closeEditDialog() {
    if (editDialog_) { 
      editDialog_.hide(); 
      tinymce.confluence.macrobrowser.macroBrowserCancel();
    }
  }

  function onSelect(doc, listview) {
    var $insert = $editDialog_.find('.insert');
    if (listview.getSelectedDocuments().length > 0) {
      $insert.prop('disabled', false);
    } else {
      $insert.prop('disabled', true);
    }
  }

  /**
   * アップロード前イベント
   */
  function onPreUpload(files, listview) {
    AJS.log("dialogs.onPreUpload");

    selectedDocuments_ = listview.getSelectedDocuments();

    // マクロブラウザを閉じる
    closeEditDialog();
  }

  /**
   * アップロード後イベント
   */
  function onUpload(documents, listview) {
    AJS.log("dialogs.onUpload");

    if (selectedDocuments_) {
      // アップロードされたドキュメントを選択済みにする
      selectedDocuments_ = selectedDocuments_.concat(documents);
    }

    // マクロブラウザを開く
    openEditDialog(true);
  }

  /**
   * ListViewの初期化
   */
  function initListView(reopen) {
    var d = new AJS.$.Deferred;

    (function () {

      var d = new AJS.$.Deferred;

      $("." + LOADING_CLASS, $editDialog_).removeClass(HIDDEN_CLASS);

      cmisConfluence.initPageInfo().done(function (info) {
        d.resolve(info);
      }).fail(function (error) {
        errorHandler.showError($content, {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.info'),
          error: error
        });
        d.reject();
      });

      return d.promise();

    })().pipe(function (data) {

      var d = new AJS.$.Deferred;

      // フォルダマッピングが設定されていない場合はCMISのセッションを作成しない
      if (!data.isFederatable()) {
        d.reject(data);
        return d.promise();
      }

      cmisConfluence.initCmisSession(data, true).done(function () {

        // 表示権限がない場合は表示しない
        if (!data.permissions.panel_browse && !data.permissions.panel_browse_without_account) {
          errorHandler.showError($content, {
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.noauthorized')
          });
          d.reject();
          return d.promise();
        }

        // ユーザーcmisJiraへ認証登録を促す
        if (attachmentPermission.shouldNavigateAccountRegistration(data.permissions)) {
          errorHandler.showError($content, {
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.token') + cmisConfluence.getUserProfilePanelUrl()
          });
          d.reject();
          return d.promise();
        }

        // ライセンスが無効な場合は表示しない
        if (cmisConfluence.isInvalidLicense()) {
          errorHandler.showError($content, {
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.license')
          });
          d.reject();
          return d.promise();
        }

        // 最大ログイン試行回数を超えた場合はユーザーにログイン確認とリセットを促す
        if (attachmentPermission.isOverMaximumLoginAttemptAllowed(data.permissions)) {
          errorHandler.showError($content, {
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.reset-failed-login-count', cmisConfluence.getUserProfilePanelUrl())
          });
          d.reject();
          return d.promise();
        }

        // 最大ログイン試行回数を超えた場合（admin profile時）
        if (cmisConfluence.isOverMaximumLoginAttemptAllowed()) {
          errorHandler.showError($content, {
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.session')
          });
          d.reject();
          return d.promise();
        }

        cmis_session = cmisConfluence.getCmisSession();
        serverId = data.serverId;
        spaceId = data.spaceId;
        pageId = data.pageId;
        permissions = $.extend(data.permissions, { document_createissue: false });;

        d.resolve(data);
      }).fail(function (error) {
        errorHandler.showError($content, {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.session'),
          error: error
        });
        d.reject();
      });

      return d.promise();

    }).pipe(function (data) {

      expListView = listview.setup({
        cmis_session: cmis_session,
        el: $editDialog_.find('.cmis-listbrowser'),
        style: 'icon',
        helper: listviewHelper.create(),
        alfrescoUrl: cmisConfluence.getAlfrescoUrl(),
        dateformat: 'YYYY/MM/DD',
        selectable: true,
        autoReloadMode: true,
        permissions: $.extend(permissions, {
          document_createissue: false,
          document_create: false,
          folder_create: false,
          folder_remove: false
        }),
        // onFolderCreate: doFolderCreate,
        // onFolderRemove: doFolderRemove,
        onSelect: onSelect,
        onDeselect: onSelect,
        onFolderSelected: onFolderSelected
      });

      var navigation = attachmentNavigation.setup({
        cmis_session: cmis_session,
        data: data,
        listView: expListView
      });

      navigation.loadFolders({
        'favorite': permissions.document_favorite != false || permissions.folder_favorite != false,
        'link': {
          getChildren: function () {
            return expListView.getDocumentByPage();
          }
        }
      }).done(function (folders) {

        if ((folders['public'] && folders['public'].length > 0) || folders['private']) {

          expTreeView = treeview.setup({
            cmis_session: cmis_session,
            el: $editDialog_.find('.cmis-treebrowser'),
            rootFolder: folders.asArray(),
            folderOnly: true,
            allowFolderSelect: true
          });
          expTreeView.bind('tree.select', function (e) {
            var node = e.node;
            if (!node || !node.cmisdata) {
              return;
            }
            expListView.setPageNum(0);
            navigation.loadByFolder(node);
            expListView.initUpload();
          });
          expTreeView.addToSelection(navigation.LINK_FOLDER_ID);

        } else {

          $('.cmis-sidebar', $editDialog_).remove();

        }

        expListView.setRootFolder(folders['link']);
        expListView.renderFolderInfo(folders['link']);
        expListView.loadByFolder(folders['link']);
        expListView.initUpload();

      });

      d.resolve();

    }).fail(function (error) {

      d.reject();

    }).always(function () {

      $("." + LOADING_CLASS, $editDialog_).addClass(HIDDEN_CLASS);

    });

    return d.promise();
  }

  function onFolderSelected(selected, current, listview) {
    expTreeView.selectOpenNode(selected, current);
  }

  /**
   * 初期化処理
   */
  function init() {

    var getMacroParameters = function(macroNode) {
      var macroDiv = AJS.$(macroNode);
      return extractParameters(AJS.$(macroDiv).data("macro-parameters"));
    }

    var extractParameters = function(s) {
      var params = {};
      AJS.$.each((s || '').split('|'), function(i, a) {
        var b = a.split('=');
        params[b[0]] = b[1];
      });
      return params;
    };

    var updateMacro = function(macroNode, key, value) {
      var macroDiv = AJS.$(macroNode);
      var components = getMacroParameters(macroNode);

      AJS.Rte.getEditor().selection.select(macroDiv[0]);
      AJS.Rte.BookmarkManager.storeBookmark();

      var param;
      if (typeof key === "object") {
        param = key;
      } else {
        param = {};
        param[key] = value;
      }


      var macroRenderRequest = {
        contentId : Confluence.Editor.getContentId(),
        macro : {
          name : "alfresco-document-macro",
          params : $.extend(components, param),
          defaultParameterValue : "",
          body : ""
        }
      };

      tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest, macroNode);
    }

    AJS.MacroBrowser.setMacroJsOverride(MACRO_NAME, {
      opener: function(macro) {
        openEditDialog();
      },
      propertyPanelIFrameInjector: function(currentPanel) {

        var components = currentPanel.options.components;
        if (components.displayMode == '') {
          return ;
        }

        // サイズの入力フィールド作成
        var $input = $("<input class='editable last first' style='padding-right:5px;'>");
        $(".panel-buttons", currentPanel.panel).prepend($input);

        if (components.thumbnailSize === undefined) {
          components.thumbnailSize = THUMBNAIL_SIZE_SMALL;
        }

        $input
          .val(components.thumbnailSize + "px")
          .change(function() {
            var size = parseInt($(this).val(), 10);
            if (isNaN(size)) {
              size = 100;
            }
            updateMacro(currentPanel.options.macroNode, {
              thumbnailSizeMode: "direct",
              thumbnailSize: size
            });
          });
      }
    });

    AJS.Confluence.PropertyPanel.Macro.registerInitHandler(function(macroNode, buttons, options) {

      var components = getMacroParameters(macroNode);

      var getButton = function(buttons, parameterName) {
        var result;
        $.each(buttons, function(index, value) {
          if (value.parameterName == parameterName) {
            result = value;
          }
        });
        return result;
      }

      options.components = components;
      options.macroNode = macroNode;

      var editButton = buttons[0],
        thumbnailSize_small = getButton(buttons, 'thumbnailSize_small'),
        thumbnailSize_medium = getButton(buttons, 'thumbnailSize_medium'),
        thumbnailSize_large = getButton(buttons, 'thumbnailSize_large'),
        //thumbnailSize_original = getButton(buttons, 'thumbnailSize_original'),
        thumbnailBorder = getButton(buttons, 'thumbnailBorder'),
        displayMode_thumbnail = getButton(buttons, 'displayMode_thumbnail'),
        displayMode_text = getButton(buttons, 'displayMode_text');

      // マクロの「編集」ボタンを非表示
      editButton.className += " hidden";
      // ボタンのスタイルを変更
      displayMode_thumbnail.className += " first lst";
      displayMode_text.className += " first last";

      if (components.thumbnailSizeMode == "small" || components.thumbnailSize === undefined) {
        thumbnailSize_small.className += " selected";
      } else if (components.thumbnailSizeMode == "medium") {
        thumbnailSize_medium.className += " selected";
      } else if (components.thumbnailSizeMode == "large") {
        thumbnailSize_large.className += " selected";
      }

      if (components.thumbnailBorder == "true") {
        thumbnailBorder.className += " selected";
      }

      if (components.displayMode == '') {
        // テキスト表示モード時は「テキスト表示」やサムネネイルのサイズボタンを非表示
        displayMode_text.className += " hidden";
        thumbnailSize_small.className += " hidden";
        thumbnailSize_medium.className += " hidden";
        thumbnailSize_large.className += " hidden";
        //thumbnailSize_original.className += " hidden";
        thumbnailBorder.className += " hidden";
      } else if (components.displayMode == 'thumbnail') {
        // サムネイル表示モード時は「サムネイル表示」ボタンを非表示
        displayMode_thumbnail.className += " hidden";
      }

    }, MACRO_NAME);

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("thumbnailSize_small", function(e, macroNode) {

      updateMacro(macroNode, {thumbnailSizeMode: "small", thumbnailSize: THUMBNAIL_SIZE_SMALL});

    }, MACRO_NAME);

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("thumbnailSize_medium", function(e, macroNode) {

      updateMacro(macroNode, {thumbnailSizeMode: "medium", thumbnailSize: THUMBNAIL_SIZE_MEDIUM});

    }, MACRO_NAME);

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("thumbnailSize_large", function(e, macroNode) {

      updateMacro(macroNode, {thumbnailSizeMode: "large", thumbnailSize: THUMBNAIL_SIZE_LARGE});

    }, MACRO_NAME);

    // 「テキスト表示」ボタン押下時のイベント
    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("displayMode_text", function(e, macroNode) {
      updateMacro(macroNode, "displayMode", "");
    }, MACRO_NAME);

    // 「サムネイル表示」ボタン押下時のイベント
    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("displayMode_thumbnail", function(e, macroNode) {
      updateMacro(macroNode, "displayMode", "thumbnail");
    }, MACRO_NAME);

    // 「Border」ボタン押下時のイベント
    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("thumbnailBorder", function(e, macroNode) {

      var parameters = getMacroParameters(macroNode);
      var value = parameters.thumbnailBorder == "true" ? "false" : "true";
      updateMacro(macroNode, "thumbnailBorder", value);

    }, MACRO_NAME);

  }

  return {
    init: init
  }
});

require(['jquery', 'alfresco-macro/linked-document-dialogs'], function($, main) {


  main.init();


});
