if ( window.XDomainRequest ) {
  jQuery.ajaxTransport(function( s ) {
    if ( s.crossDomain && s.async ) {
      if ( s.timeout ) {
        s.xdrTimeout = s.timeout;
        delete s.timeout;
      }
      var xdr;
      return {
        send: function( _, complete ) {
          function callback( status, statusText, responses, responseHeaders ) {
            xdr.onload = xdr.onerror = xdr.ontimeout = function() { };
            xdr = undefined;
            complete( status, statusText, responses, responseHeaders );
          }
          xdr = new XDomainRequest();
          xdr.onload = function() {
            callback( 200, "OK", { text: xdr.responseText }, "Content-Type: " + xdr.contentType );
          };
          xdr.onerror = function() {
            callback( 404, "Not Found" );
          };
          xdr.onprogress = function() { };
          xdr.ontimeout = function() {
            callback( 0, "timeout" );
          };
          xdr.timeout = s.xdrTimeout || Number.MAX_VALUE;
          xdr.open( s.type, s.url );
          xdr.send( ( s.hasContent && s.data ) || null );
        },
        abort: function() {
          if ( xdr ) {
            xdr.onerror = function() { };
            xdr.abort();
          }
        }
      };
    }
  });
}