/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/confluence-error-handler', ['jquery', 'cmis/cmisconfluence'], function($, cmisConfluence) {
  
  $(document).ajaxError(function (e, xhr, ajaxOptions) {
    if (ajaxOptions.url && ajaxOptions.url.indexOf("/api/-default-/public/cmis/versions/1.1/browser") !== -1) {
      // 認証エラーの場合は"現在のログイン失敗回数"を更新する。
      if (cmisConfluence.isLimitMaximumLoginAttemptAllowed() && xhr.status == 401) {
        cmisConfluence.updateCurrentLoginFailed(cmisConfluence.isAdmin());
      }
    }
  });

  $.ajaxSetup({ beforeSend: function (xhr, ajaxOptions) {
      if (ajaxOptions.url && ajaxOptions.url.indexOf("/api/-default-/public/cmis/versions/1.1/browser") !== -1) {
        // "ログイン試行最大回数"を超えていた場合は送信を中止する。
        if (cmisConfluence.isLimitMaximumLoginAttemptAllowed() && cmisConfluence.isOverMaximumLoginAttemptAllowed()) {
          return false;
        }
      }
    }});

  /**
   * From JIRA 6.4, Confluence 5.7
   * https://docs.atlassian.com/aui/latest/docs/flag.html
   * https://bitbucket.org/atlassian/aui-adg/wiki/versions/product-version-matrix
   */
  var showErrorFlagForXhr = function(xhr) {
    var data = null;
    try {
      data = xhr.responseText && $.parseJSON(xhr.responseText);
    } catch (e) {
    }
    return showErrorFlag({ 
      body : data && data.errorMessages && data.errorMessages.length ? data.errorMessages.join(' ') : undefined 
    });
  }
  
  /**
   * From JIRA 6.4, Confluence 5.7
   * https://docs.atlassian.com/aui/latest/docs/flag.html
   * https://bitbucket.org/atlassian/aui-adg/wiki/versions/product-version-matrix
   */
  var showErrorFlag = function(options) {
    //@see https://answers.atlassian.com/questions/32522285/ajs.flag-is-not-a-function
    return require('aui/flag')($.extend({
      type: 'warning',
      close: 'auto',
      body : AJS.I18n.getText("alfresco.for.confluence.ajax.error.server")
    }, options));
  }
  
  /**
   * @param {Object} context
   * @param {Object} xhr
   * @return {Object} AJS.messages.warning
   */
  var showErrorForXhr = function(context, xhr) {
    var data = null;
    try {
      data = xhr.responseText && $.parseJSON(xhr.responseText);
    } catch (e) {
    }
    return showError(context, {  
      body : data && data.errorMessages && data.errorMessages.length ? data.errorMessages.join(' ') : undefined 
    });
  }
  
  /**
   * @param {Object} context
   * @param {Object} options
   * @return {Object} AJS.messages.warning
   */
  var showError = function(context, options) {
    var $options = $.extend({
      body : AJS.I18n.getText("alfresco.for.confluence.ajax.error.server"),
      closeable: false
    }, options);
    var warning = AJS.messages.warning(context, $.extend($options, {
      body : (function() {
        if ($options.error) {
          var status = $options.error.response ? $options.error.response.status : $options.error.status;
          var statusText = $options.error.response ? $options.error.response.statusText : $options.error.statusText;
          return '<span class="toggle icon-default aui-icon aui-icon-small aui-iconfont-devtools-folder-closed"></span>' +
            defaultErrorMessage($options.body, $options.error.response) +
            '<span style="display:none;">' + 
              '<div>' + AJS.I18n.getText("alfresco.for.confluence.ajax.error.status.code") + status + '</div>' + 
              '<div>' + AJS.I18n.getText("alfresco.for.confluence.ajax.error.status.message") + statusText + '</div>' +
            '</span>';
        }
        return '<p>' + $options.body + '</p>';
      })()
    })).css('fontSize', '12px');
    if ($options.error) {
      AJS.$('span.toggle', context).toggle(
        function() { 
          AJS.$('span.details', context).show();
          AJS.$('span.toggle', context).removeClass('aui-iconfont-collapsed').addClass('aui-iconfont-expanded');
        },
        function() {
          AJS.$('span.details', context).hide();
          AJS.$('span.toggle', context).removeClass('aui-iconfont-expanded').addClass('aui-iconfont-collapsed');
        }
      );
    }
    return warning;
  }

  var defaultErrorMessage = function (body, errorResponse) {
    if (errorResponse && errorResponse.status === 401) {
      if (cmisConfluence.isAdmin()) {
        return AJS.I18n.getText('alfresco.for.confluence.ajax.error.unauthorized', cmisConfluence.getAdminCredentialUrl());
      } else {
        return AJS.I18n.getText('alfresco.for.confluence.ajax.error.unauthorized', cmisConfluence.getUserProfilePanelUrl());
      }
    }
    return body;
  }

  return {
    showErrorFlagForXhr: showErrorFlagForXhr,
    showErrorFlag: showErrorFlag,
    showError: showError,
    showErrorForXhr: showErrorForXhr,
  };
});
