/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectIdAndChangeTokenType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRenditionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumUnfileObject;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumVersioningState;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

public class ObjectServiceImpl
extends AbstractWebServicesService
implements ObjectService {
    private final AbstractPortProvider portProvider;

    public ObjectServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    @Override
    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createDocument");
        try {
            Holder<String> objectId = new Holder<String>();
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.createDocument(repositoryId, WSConverter.convert(properties), folderId, WSConverter.convert(contentStream, false), WSConverter.convert(EnumVersioningState.class, versioningState), policies, WSConverter.convert(addACEs), WSConverter.convert(removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues(portExtension, extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createDocumentFromSource");
        try {
            Holder<String> objectId = new Holder<String>();
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.createDocumentFromSource(repositoryId, sourceId, WSConverter.convert(properties), folderId, WSConverter.convert(EnumVersioningState.class, versioningState), policies, WSConverter.convert(addACEs), WSConverter.convert(removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues(portExtension, extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createFolder");
        try {
            Holder<String> objectId = new Holder<String>();
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.createFolder(repositoryId, WSConverter.convert(properties), folderId, policies, WSConverter.convert(addACEs), WSConverter.convert(removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues(portExtension, extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createPolicy");
        try {
            Holder<String> objectId = new Holder<String>();
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.createPolicy(repositoryId, WSConverter.convert(properties), folderId, policies, WSConverter.convert(addACEs), WSConverter.convert(removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues(portExtension, extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        ObjectServicePort port = this.portProvider.getObjectServicePort(CmisVersion.CMIS_1_1, "");
        try {
            Holder<String> objectId = new Holder<String>();
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.createItem(repositoryId, WSConverter.convert(properties), folderId, WSConverter.convert(addACEs), WSConverter.convert(removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues(portExtension, extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createRelationship");
        try {
            Holder<String> objectId = new Holder<String>();
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.createRelationship(repositoryId, WSConverter.convert(properties), policies, WSConverter.convert(addACEs), WSConverter.convert(removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues(portExtension, extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void updateProperties(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "updateProperties");
        try {
            Holder<String> portObjectId = WSConverter.convertHolder(objectId);
            Holder<String> portChangeToken = this.getSession().get("org.apache.chemistry.opencmis.workaround.omitChangeTokens", false) ? null : WSConverter.convertHolder(changeToken);
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.updateProperties(repositoryId, portObjectId, portChangeToken, WSConverter.convert(properties), portExtension);
            WSConverter.setHolderValue(portObjectId, objectId);
            WSConverter.setHolderValue(portChangeToken, changeToken);
            WSConverter.setExtensionValues(portExtension, extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        ObjectServicePort port = this.portProvider.getObjectServicePort(CmisVersion.CMIS_1_1, "bulkUpdateProperties");
        try {
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            Holder<CmisObjectIdAndChangeTokenType> bulkUpdateResponse = new Holder<CmisObjectIdAndChangeTokenType>();
            port.bulkUpdateProperties(repositoryId, WSConverter.convert(objectIdAndChangeToken, properties, addSecondaryTypeIds, removeSecondaryTypeIds), portExtension, bulkUpdateResponse);
            WSConverter.setExtensionValues(portExtension, extension);
            List<BulkUpdateObjectIdAndChangeToken> result = null;
            if (bulkUpdateResponse.value != null) {
                // empty if block
            }
            List<BulkUpdateObjectIdAndChangeToken> list = result;
            return list;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "deleteObject");
        try {
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.deleteObject(repositoryId, objectId, allVersions, portExtension);
            WSConverter.setExtensionValues(portExtension, extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "deleteTree");
        try {
            FailedToDeleteData failedToDeleteData = WSConverter.convert(port.deleteTree(repositoryId, folderId, allVersions, WSConverter.convert(EnumUnfileObject.class, unfileObjects), continueOnFailure, WSConverter.convert(extension)));
            return failedToDeleteData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getAllowableActions");
        try {
            AllowableActions allowableActions = WSConverter.convert(port.getAllowableActions(repositoryId, objectId, WSConverter.convert(extension)));
            return allowableActions;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getContentStream");
        try {
            boolean isPartial = false;
            if (offset != null && offset.signum() == 1 || length != null) {
                isPartial = true;
            }
            ContentStream contentStream = WSConverter.convert(port.getContentStream(repositoryId, objectId, streamId, offset, length, WSConverter.convert(extension)), isPartial);
            return contentStream;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getObject");
        try {
            ObjectData objectData = WSConverter.convert(port.getObject(repositoryId, objectId, filter, includeAllowableActions, WSConverter.convert(EnumIncludeRelationships.class, includeRelationships), renditionFilter, includePolicyIds, includeACL, WSConverter.convert(extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getObjectByPath");
        try {
            ObjectData objectData = WSConverter.convert(port.getObjectByPath(repositoryId, path, filter, includeAllowableActions, WSConverter.convert(EnumIncludeRelationships.class, includeRelationships), renditionFilter, includePolicyIds, includeACL, WSConverter.convert(extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getProperties");
        try {
            Properties properties = WSConverter.convert(port.getProperties(repositoryId, objectId, filter, WSConverter.convert(extension)));
            return properties;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getRenditions");
        try {
            List<CmisRenditionType> renditionList = port.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, WSConverter.convert(extension));
            if (renditionList == null) {
                List<RenditionData> list = null;
                return list;
            }
            ArrayList<RenditionData> result = new ArrayList<RenditionData>();
            for (CmisRenditionType rendition : renditionList) {
                result.add(WSConverter.convert(rendition));
            }
            ArrayList<RenditionData> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void moveObject(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "moveObject");
        try {
            Holder<String> portObjectId = WSConverter.convertHolder(objectId);
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.moveObject(repositoryId, portObjectId, targetFolderId, sourceFolderId, portExtension);
            WSConverter.setHolderValue(portObjectId, objectId);
            WSConverter.setExtensionValues(portExtension, extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void setContentStream(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, Boolean overwriteFlag, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "setContentStream");
        try {
            Holder<String> portObjectId = WSConverter.convertHolder(objectId);
            Holder<String> portChangeToken = this.getSession().get("org.apache.chemistry.opencmis.workaround.omitChangeTokens", false) ? null : WSConverter.convertHolder(changeToken);
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.setContentStream(repositoryId, portObjectId, overwriteFlag, portChangeToken, WSConverter.convert(contentStream, false), portExtension);
            WSConverter.setHolderValue(portObjectId, objectId);
            WSConverter.setHolderValue(portChangeToken, changeToken);
            WSConverter.setExtensionValues(portExtension, extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void deleteContentStream(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "deleteContentStream");
        try {
            Holder<String> portObjectId = WSConverter.convertHolder(objectId);
            Holder<String> portChangeToken = this.getSession().get("org.apache.chemistry.opencmis.workaround.omitChangeTokens", false) ? null : WSConverter.convertHolder(changeToken);
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.deleteContentStream(repositoryId, portObjectId, portChangeToken, portExtension);
            WSConverter.setHolderValue(portObjectId, objectId);
            WSConverter.setHolderValue(portChangeToken, changeToken);
            WSConverter.setExtensionValues(portExtension, extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void appendContentStream(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        ObjectServicePort port = this.portProvider.getObjectServicePort(CmisVersion.CMIS_1_1, "appendContentStream");
        try {
            Holder<String> portObjectId = WSConverter.convertHolder(objectId);
            Holder<String> portChangeToken = this.getSession().get("org.apache.chemistry.opencmis.workaround.omitChangeTokens", false) ? null : WSConverter.convertHolder(changeToken);
            Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
            port.appendContentStream(repositoryId, portObjectId, isLastChunk, portChangeToken, WSConverter.convert(contentStream, false), portExtension);
            WSConverter.setHolderValue(portObjectId, objectId);
            WSConverter.setHolderValue(portChangeToken, changeToken);
            WSConverter.setExtensionValues(portExtension, extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

