/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest.permission;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jp.ricksoft.plugins.alfresco.ao.entity.SpaceConfig;
import jp.ricksoft.plugins.alfresco.ao.service.SpaceConfigService;
import jp.ricksoft.plugins.alfresco.permission.PermissionKeys;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionBean;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionUsageBean;
import jp.ricksoft.plugins.alfresco.rest.permission.UpdateRequestBean;
import org.apache.commons.lang3.StringUtils;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FeaturePermissionResource {
    private final UserManager userManager;
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionManager;
    private final I18nResolver i18;
    private final PermissionManager permissionManager;
    private final FeaturePermissionResourceHelper featureResourceHelper;
    private final SpaceConfigService spaceConfigService;

    public FeaturePermissionResource(UserManager userManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, I18nResolver i18, PermissionManager permissionManager, FeaturePermissionResourceHelper featureResourceHelper, SpaceConfigService spaceConfigService) {
        this.userManager = userManager;
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.i18 = i18;
        this.permissionManager = permissionManager;
        this.featureResourceHelper = featureResourceHelper;
        this.spaceConfigService = spaceConfigService;
    }

    @GET
    @Path(value="permission")
    public Response getAllActors(@QueryParam(value="spaceKey") String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ArrayList<FeaturePermissionBean> beans = new ArrayList<FeaturePermissionBean>();
        for (PermissionKeys key : PermissionKeys.values()) {
            beans.add(this.featureResourceHelper.getPeopleIn(space, key));
        }
        return Response.ok(beans).build();
    }

    @GET
    @Path(value="default/permission")
    public Response getDefaultAllActors() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(user.getKey()) && this.userManager.isSystemAdmin(user.getKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ArrayList<FeaturePermissionBean> beans = new ArrayList<FeaturePermissionBean>();
        for (PermissionKeys key : PermissionKeys.values()) {
            beans.add(this.featureResourceHelper.getDefaultPeopleIn(key));
        }
        return Response.ok(beans).build();
    }

    @GET
    @Path(value="permission/{key}")
    public Response getActors(@PathParam(value="key") String key, @QueryParam(value="spaceKey") String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)this.featureResourceHelper.getPeopleIn(space, PermissionKeys.valueOf(key.toUpperCase()))).build();
    }

    @GET
    @Path(value="default/permission/{key}")
    public Response getDefaultActors(@PathParam(value="key") String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(user.getKey()) && this.userManager.isSystemAdmin(user.getKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)this.featureResourceHelper.getDefaultPeopleIn(PermissionKeys.valueOf(key.toUpperCase()))).build();
    }

    @PUT
    @Path(value="permission/{key}")
    public Response updateActors(@PathParam(value="key") String key, UpdateRequestBean bean) {
        ConfluenceUser user;
        Space space = this.spaceManager.getSpace(bean.getSpaceKey());
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)(user = AuthenticatedUserThreadLocal.get()))) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)this.featureResourceHelper.updatePeopleIn(PermissionKeys.valueOf(key.toUpperCase()), bean)).build();
    }

    @PUT
    @Path(value="default/permission/{key}")
    @ReadOnlyAccessAllowed
    public Response updateDefaultActors(@PathParam(value="key") String key, UpdateRequestBean bean) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(user.getKey()) && this.userManager.isSystemAdmin(user.getKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)this.featureResourceHelper.updatePeopleIn(PermissionKeys.valueOf(key.toUpperCase()), bean)).build();
    }

    @GET
    @Path(value="usage/permission")
    public Response getPermissionUsage(@QueryParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user;
        Space space = this.spaceManager.getSpace(spaceKey);
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)(user = AuthenticatedUserThreadLocal.get()))) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean enablePermission = this.spaceConfigService.isEnableUsageFeaturePermission(space.getId());
        return Response.ok((Object)new FeaturePermissionUsageBean(enablePermission, spaceKey)).build();
    }

    @POST
    @Path(value="usage/permission")
    public Response updatePermissionUsage(FeaturePermissionUsageBean usageBean) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String spaceKey = usageBean.getSpaceKey();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        SpaceConfig spaceConfig = this.spaceConfigService.saveUsageFeaturePermission(space.getId(), usageBean.isEnable());
        boolean enablePermission = spaceConfig.isEnablePermission();
        return Response.ok((Object)new FeaturePermissionUsageBean(enablePermission, spaceKey)).build();
    }
}

