/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialSecretService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialTokenProvider;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import jp.ricksoft.plugins.alfresco.license.LicenseManager;
import jp.ricksoft.plugins.alfresco.rest.Credential;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/credential")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CredentialResource {
    private static final Logger log = LoggerFactory.getLogger(CredentialResource.class);
    private final CredentialService credentialService;
    private final CredentialSecretService credentialSecretService;
    private final FeaturePermissionResourceHelper featurePermissionResourceHelper;
    private final UserManager userManager;
    private final LicenseManager licenseManager;
    private final PageManager pageManager;
    private final SpaceManager spaceManager;

    public CredentialResource(CredentialService credentialService, CredentialSecretService credentialSecretService, FeaturePermissionResourceHelper featurePermissionResourceHelper, UserManager userManager, LicenseManager licenseManager, PageManager pageManager, SpaceManager spaceManager) {
        this.credentialService = credentialService;
        this.credentialSecretService = credentialSecretService;
        this.featurePermissionResourceHelper = featurePermissionResourceHelper;
        this.userManager = userManager;
        this.licenseManager = licenseManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
    }

    @GET
    public Response getCredential(@Context HttpServletRequest request, @QueryParam(value="admin") @DefaultValue(value="false") boolean admin, @QueryParam(value="pageId") Long pageId, @QueryParam(value="spaceKey") String spaceKey) {
        try {
            boolean hasUserCredential;
            CredentialTokenProvider credentialTokenProvider;
            ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
            if (loggedInUser == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (admin && !this.userManager.isAdmin(loggedInUser.getKey()) && !this.userManager.isSystemAdmin(loggedInUser.getKey())) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Page page = null;
            if (pageId != null && (page = this.pageManager.getPage(pageId.longValue())) == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Space space = null;
            if (!StringUtils.isEmpty((CharSequence)spaceKey)) {
                space = this.spaceManager.getSpace(spaceKey);
            }
            if ((credentialTokenProvider = this.getCredentialTokenProvider(admin, loggedInUser, (AbstractPage)page, space, hasUserCredential = this.credentialService.hasUserCredential(loggedInUser))) == null) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            String url = credentialTokenProvider.getAlfrescoDisplayUrl();
            String shareUrl = credentialTokenProvider.getShareDisplayUrl();
            String authType = credentialTokenProvider.getAuthType();
            String accessType = credentialTokenProvider.getAccessType();
            String username = credentialTokenProvider.getUsername();
            String token = credentialTokenProvider.getToken();
            boolean limitMaximumLoginAttemptAllowed = credentialTokenProvider.isLimitMaximumLoginAttemptAllowed();
            boolean overMaximumLoginAttemptAllowed = credentialTokenProvider.isOverMaximumLoginAttemptAllowed();
            boolean invalidLicense = this.licenseManager.isInvalidLicense();
            return Response.ok((Object)new Credential(url, shareUrl, authType, accessType, username, token, limitMaximumLoginAttemptAllowed, overMaximumLoginAttemptAllowed, invalidLicense)).build();
        }
        catch (InvalidTokenException e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    CredentialTokenProvider getCredentialTokenProvider(boolean admin, ConfluenceUser loggedInUser, AbstractPage page, Space space, boolean hasUserCredential) throws InvalidTokenException {
        boolean canBrowsePanelWithoutAccount;
        boolean canBrowsePanelWithAccount;
        if (page != null) {
            canBrowsePanelWithAccount = this.featurePermissionResourceHelper.canBrowsePanel(page, loggedInUser);
            canBrowsePanelWithoutAccount = this.featurePermissionResourceHelper.canBrowsePanelWithoutAccount(page, loggedInUser);
            if (!(hasUserCredential && canBrowsePanelWithAccount || !canBrowsePanelWithoutAccount)) {
                return this.credentialService.generateTokenProvider(loggedInUser, true);
            }
        }
        if (space != null) {
            canBrowsePanelWithAccount = this.featurePermissionResourceHelper.canBrowsePanel(space, loggedInUser);
            canBrowsePanelWithoutAccount = this.featurePermissionResourceHelper.canBrowsePanelWithoutAccount(space, loggedInUser);
            if (!(hasUserCredential && canBrowsePanelWithAccount || !canBrowsePanelWithoutAccount)) {
                return this.credentialService.generateTokenProvider(loggedInUser, true);
            }
        }
        return this.credentialService.generateTokenProvider(loggedInUser, admin);
    }
}

