/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.profile;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.atlassian.xwork.RequireSecurityToken;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialSecret;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialTokenProvider;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import jp.ricksoft.plugins.alfresco.profile.UserProfileAction;

public class UserProfileResetFailedLoginCountAction
extends UserProfileAction {
    private static final long serialVersionUID = 3168028463546273384L;

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    @RequireSecurityToken(value=true)
    public String execute() throws InvalidTokenException {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        if (this.hasErrors()) {
            return "error";
        }
        ConfluenceUser user = this.getAuthenticatedUser();
        CredentialTokenProvider credentialTokenProvider = this.credentialService.generateTokenProvider(user);
        CredentialSecret credentialSecret = this.credentialSecretService.find(user);
        if (credentialSecret != null) {
            this.credentialSecretService.resetFailedLoginCount(credentialSecret);
        }
        return "success";
    }
}

