/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import java.util.Map;

public class DocumentMacro
implements Macro {
    private static final String PARAM_IS_PREVIEW_MODE = "isPreviewMode";
    private static final String PARAM_DOCUMENT_ID = "documentId";
    private static final String PARAM_DISPLAY_MODE = "displayMode";
    private static final String PARAM_SIZE = "thumbnailSize";
    private static final String PARAM_BORDER = "thumbnailBorder";
    private static final String TEMPLATE = "templates/macro/linked-document.vm";

    public String execute(Map<String, String> parameters, String body, ConversionContext renderContext) throws MacroExecutionException {
        Map context = MacroUtils.defaultVelocityContext();
        boolean isPreviewMode = ConversionContextOutputType.PREVIEW.name().equalsIgnoreCase(renderContext.getOutputType());
        context.put(PARAM_DOCUMENT_ID, parameters.get(PARAM_DOCUMENT_ID));
        context.put(PARAM_DISPLAY_MODE, parameters.get(PARAM_DISPLAY_MODE));
        context.put(PARAM_SIZE, parameters.get(PARAM_SIZE));
        context.put(PARAM_BORDER, parameters.get(PARAM_BORDER));
        context.put(PARAM_IS_PREVIEW_MODE, isPreviewMode);
        return VelocityUtils.getRenderedTemplate((String)TEMPLATE, (Map)context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

