/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.auth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ricksoft.plugins.alfresco.auth.AuthUtils;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class UsernameToken {
    private String username;
    private String passwordDigest;
    private String nonce;
    private String created;

    public UsernameToken() {
    }

    public UsernameToken(String username, String secret) {
        this.username = username;
        this.nonce = AuthUtils.generateNonce();
        this.created = AuthUtils.generateCreated();
        this.passwordDigest = AuthUtils.generatePasswordDigest(this.nonce, this.created, secret);
    }

    public UsernameToken(UsernameToken usernameToken, String secret) {
        this.username = usernameToken.getUsername();
        this.nonce = usernameToken.getNonce();
        this.created = usernameToken.getCreated();
        this.passwordDigest = AuthUtils.generatePasswordDigest(this.nonce, this.created, secret);
    }

    public String getUsername() {
        return this.username;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getPasswordDigest() {
        return this.passwordDigest;
    }

    public String getCreated() {
        return this.created;
    }

    public String generate() throws InvalidTokenException {
        if (StringUtils.isEmpty((CharSequence)this.getUsername()) || StringUtils.isEmpty((CharSequence)this.getPasswordDigest()) || StringUtils.isEmpty((CharSequence)this.getNonce()) || StringUtils.isEmpty((CharSequence)this.getCreated())) {
            throw new InvalidTokenException("Token parameters must not be null or empty.");
        }
        return String.format("UsernameToken Username=\"%s\", PasswordDigest=\"%s\", Nonce=\"%s\", Created=\"%s\"", this.getUsername(), this.getPasswordDigest(), this.getNonce(), this.getCreated());
    }

    public void parse(String usernameToken) throws InvalidTokenException {
        String patternStr = "UsernameToken Username=\"(.*)\", PasswordDigest=\"(.*)\", Nonce=\"(.*)\", Created=\"(.*)\"";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(usernameToken);
        boolean matchFound = matcher.find();
        if (!matchFound || matcher.groupCount() != 4) {
            throw new InvalidTokenException("UsernameToken format is invalid or Token parameters is null or empty .");
        }
        this.username = matcher.group(1);
        this.passwordDigest = matcher.group(2);
        this.nonce = matcher.group(3);
        this.created = matcher.group(4);
    }

    public boolean same(UsernameToken usernameToken) {
        return !StringUtils.isEmpty((CharSequence)this.passwordDigest) && this.passwordDigest.equals(usernameToken.getPasswordDigest());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UsernameToken)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        UsernameToken rhs = (UsernameToken)obj;
        return new EqualsBuilder().append((Object)this.username, (Object)rhs.username).append((Object)this.nonce, (Object)rhs.nonce).append((Object)this.passwordDigest, (Object)rhs.passwordDigest).append((Object)this.created, (Object)rhs.created).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.username).append((Object)this.nonce).append((Object)this.passwordDigest).append((Object)this.created).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("username", (Object)this.username).append("passwordDigest", (Object)this.passwordDigest).append("nonce", (Object)this.nonce).append("created", (Object)this.created).toString();
    }
}

