/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import jp.ricksoft.plugins.alfresco.ao.entity.SpaceConfig;
import jp.ricksoft.plugins.alfresco.ao.service.SpaceConfigService;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class SpaceConfigServiceImpl
implements SpaceConfigService {
    private final ActiveObjects ao;

    public SpaceConfigServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public SpaceConfig find(Long spaceId) {
        SpaceConfig[] configurations = (SpaceConfig[])this.ao.find(SpaceConfig.class, Query.select().where("SPACE_ID = ?", new Object[]{spaceId}).order("ID ASC").limit(1));
        if (configurations == null || configurations.length <= 0) {
            SpaceConfig config = (SpaceConfig)this.ao.create(SpaceConfig.class, new DBParam[0]);
            config.setSpaceId(spaceId);
            config.setEnablePermission(false);
            config.save();
            return config;
        }
        return configurations[0];
    }

    @Override
    public SpaceConfig saveUsageFeaturePermission(Long spaceId, boolean enableFeaturePermission) {
        SpaceConfig entity = this.find(spaceId);
        if (entity == null) {
            entity = (SpaceConfig)this.ao.create(SpaceConfig.class, new DBParam[0]);
        }
        entity.setSpaceId(spaceId);
        entity.setEnablePermission(enableFeaturePermission);
        entity.save();
        return entity;
    }

    @Override
    public boolean isEnableUsageFeaturePermission(Long spaceId) {
        SpaceConfig entity = this.find(spaceId);
        if (entity == null) {
            return false;
        }
        return entity.isEnablePermission();
    }

    @Override
    public void delete(Long spaceId) {
        SpaceConfig entity = this.find(spaceId);
        if (entity == null) {
            return;
        }
        this.ao.delete(new RawEntity[]{entity});
    }
}

